/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.soap.client.http;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.List;
import java.util.function.Function;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.component.AbstractInitializableComponent;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.xml.ParserPool;
import net.shibboleth.utilities.java.support.xml.SerializeSupport;
import net.shibboleth.utilities.java.support.xml.XMLParserException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.io.Marshaller;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.io.Unmarshaller;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.messaging.context.InOutOperationContext;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.security.SecurityException;
import org.opensaml.soap.client.SOAPClient;
import org.opensaml.soap.client.SOAPClientContext;
import org.opensaml.soap.client.SOAPClientException;
import org.opensaml.soap.client.SOAPFaultException;
import org.opensaml.soap.client.http.HttpSOAPRequestParameters;
import org.opensaml.soap.common.SOAPException;
import org.opensaml.soap.messaging.context.SOAP11Context;
import org.opensaml.soap.soap11.Envelope;
import org.opensaml.soap.soap11.Fault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@ThreadSafe
public class HttpSOAPClient
extends AbstractInitializableComponent
implements SOAPClient {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(HttpSOAPClient.class);
    @NonnullAfterInit
    private HttpClient httpClient;
    @NonnullAfterInit
    private ParserPool parserPool;
    @Nonnull
    private Function<MessageContext, SOAPClientContext> soapClientContextLookupStrategy = new ChildContextLookup(SOAPClientContext.class);
    @Nonnull
    private Function<MessageContext, SOAP11Context> soap11ContextLookupStrategy = new ChildContextLookup(SOAP11Context.class);

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.httpClient == null) {
            throw new ComponentInitializationException("HttpClient cannot be null");
        }
        if (this.parserPool == null) {
            throw new ComponentInitializationException("ParserPool cannot be null");
        }
    }

    public void setHttpClient(@Nonnull HttpClient client) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.httpClient = (HttpClient)Constraint.isNotNull((Object)client, (String)"HttpClient cannot be null");
    }

    public void setParserPool(@Nonnull ParserPool parser) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.parserPool = (ParserPool)Constraint.isNotNull((Object)parser, (String)"ParserPool cannot be null");
    }

    @Nonnull
    public Function<MessageContext, SOAPClientContext> getSOAPClientContextLookupStrategy() {
        return this.soapClientContextLookupStrategy;
    }

    public void setSOAPClientContextLookupStrategy(@Nonnull Function<MessageContext, SOAPClientContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.soapClientContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"SOAP client context lookup strategy cannot be null");
    }

    @Nonnull
    public Function<MessageContext, SOAP11Context> getSOAP11ContextLookupStrategy() {
        return this.soap11ContextLookupStrategy;
    }

    public void setSOAP11ContextLookupStrategy(@Nonnull Function<MessageContext, SOAP11Context> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.soap11ContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"SOAP 1.1 context lookup strategy cannot be null");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send(@Nonnull @NotEmpty String endpoint, @Nonnull InOutOperationContext context) throws SOAPException, SecurityException {
        block18: {
            Constraint.isNotNull((Object)endpoint, (String)"Endpoint cannot be null");
            Constraint.isNotNull((Object)context, (String)"Operation context cannot be null");
            SOAP11Context soapCtx = this.soap11ContextLookupStrategy.apply(context.getOutboundMessageContext());
            SOAPClientContext clientCtx = this.soapClientContextLookupStrategy.apply(context.getOutboundMessageContext());
            HttpSOAPRequestParameters soapRequestParams = null;
            if (soapCtx == null || soapCtx.getEnvelope() == null) {
                throw new SOAPClientException("Operation context did not contain an outbound SOAP Envelope");
            }
            if (clientCtx != null) {
                soapRequestParams = (HttpSOAPRequestParameters)clientCtx.getSOAPRequestParameters();
            }
            HttpPost post = null;
            try {
                post = this.createPostMethod(endpoint, soapRequestParams, soapCtx.getEnvelope());
                HttpResponse response = null;
                try {
                    response = this.httpClient.execute((HttpUriRequest)post);
                    int code = response.getStatusLine().getStatusCode();
                    this.log.debug("Received HTTP status code of {} when POSTing SOAP message to {}", (Object)code, (Object)endpoint);
                    if (code == 200) {
                        this.processSuccessfulResponse(response, context);
                        break block18;
                    }
                    if (code == 500) {
                        this.processFaultResponse(response, context);
                        break block18;
                    }
                    throw new SOAPClientException("Received " + code + " HTTP response status code from HTTP request to " + endpoint);
                }
                finally {
                    try {
                        if (response != null && response instanceof CloseableHttpResponse) {
                            ((CloseableHttpResponse)response).close();
                        }
                    }
                    catch (IOException e) {
                        this.log.error("Error closing HttpResponse", (Throwable)e);
                    }
                }
            }
            catch (IOException e) {
                throw new SOAPClientException("Unable to send request to " + endpoint, e);
            }
            finally {
                if (post != null) {
                    post.reset();
                }
            }
        }
    }

    protected HttpPost createPostMethod(@Nonnull @NotEmpty String endpoint, @Nullable HttpSOAPRequestParameters requestParams, @Nonnull Envelope message) throws SOAPClientException {
        this.log.debug("POSTing SOAP message to {}", (Object)endpoint);
        HttpPost post = new HttpPost(endpoint);
        post.setEntity(this.createRequestEntity(message, Charset.forName("UTF-8")));
        if (requestParams != null && requestParams.getSOAPAction() != null) {
            post.setHeader("SOAPAction", requestParams.getSOAPAction());
        }
        return post;
    }

    protected HttpEntity createRequestEntity(@Nonnull Envelope message, @Nullable Charset charset) throws SOAPClientException {
        try {
            Marshaller marshaller = (Marshaller)Constraint.isNotNull((Object)XMLObjectProviderRegistrySupport.getMarshallerFactory().getMarshaller(message), (String)"SOAP Envelope marshaller not available");
            ByteArrayOutputStream arrayOut = new ByteArrayOutputStream();
            if (this.log.isDebugEnabled()) {
                this.log.debug("Outbound SOAP message is:\n" + SerializeSupport.prettyPrintXML((Node)marshaller.marshall(message)));
            }
            SerializeSupport.writeNode((Node)marshaller.marshall(message), (OutputStream)arrayOut);
            return new ByteArrayEntity(arrayOut.toByteArray(), ContentType.create((String)"text/xml", (Charset)charset));
        }
        catch (MarshallingException e) {
            throw new SOAPClientException("Unable to marshall SOAP envelope", e);
        }
    }

    protected void processSuccessfulResponse(@Nonnull HttpResponse httpResponse, @Nonnull InOutOperationContext context) throws SOAPClientException {
        try {
            if (httpResponse.getEntity() == null) {
                throw new SOAPClientException("No response body from server");
            }
            Envelope response = this.unmarshallResponse(httpResponse.getEntity().getContent());
            context.setInboundMessageContext(new MessageContext());
            ((SOAP11Context)context.getInboundMessageContext().getSubcontext(SOAP11Context.class, true)).setEnvelope(response);
        }
        catch (IOException e) {
            throw new SOAPClientException("Unable to read response", e);
        }
    }

    protected void processFaultResponse(@Nonnull HttpResponse httpResponse, @Nonnull InOutOperationContext context) throws SOAPClientException, SOAPFaultException {
        try {
            if (httpResponse.getEntity() == null) {
                throw new SOAPClientException("No response body from server");
            }
            Envelope response = this.unmarshallResponse(httpResponse.getEntity().getContent());
            context.setInboundMessageContext(new MessageContext());
            ((SOAP11Context)context.getInboundMessageContext().getSubcontext(SOAP11Context.class, true)).setEnvelope(response);
            if (response.getBody() != null) {
                List<XMLObject> faults = response.getBody().getUnknownXMLObjects(Fault.DEFAULT_ELEMENT_NAME);
                if (faults.size() < 1) {
                    throw new SOAPClientException("HTTP status code was 500 but SOAP response did not contain a Fault");
                }
                String code = "(not set)";
                String msg = "(not set)";
                Fault fault = (Fault)faults.get(0);
                if (fault.getCode() != null) {
                    code = fault.getCode().getValue().toString();
                }
                if (fault.getMessage() != null) {
                    msg = fault.getMessage().getValue();
                }
                this.log.debug("SOAP fault code {} with message {}", (Object)code, (Object)msg);
                SOAPFaultException faultException = new SOAPFaultException("SOAP Fault: " + code + " Fault Message: " + msg);
                faultException.setFault(fault);
                throw faultException;
            }
            throw new SOAPClientException("HTTP status code was 500 but SOAP response did not contain a Body");
        }
        catch (IOException e) {
            throw new SOAPClientException("Unable to read response", e);
        }
    }

    protected Envelope unmarshallResponse(@Nonnull InputStream responseStream) throws SOAPClientException {
        try {
            Element responseElem = this.parserPool.parse(responseStream).getDocumentElement();
            if (this.log.isDebugEnabled()) {
                this.log.debug("Inbound SOAP message was:\n" + SerializeSupport.prettyPrintXML((Node)responseElem));
            }
            Unmarshaller unmarshaller = (Unmarshaller)Constraint.isNotNull((Object)XMLObjectProviderRegistrySupport.getUnmarshallerFactory().getUnmarshaller(responseElem), (String)"SOAP envelope unmarshaller not available");
            return (Envelope)unmarshaller.unmarshall(responseElem);
        }
        catch (XMLParserException e) {
            throw new SOAPClientException("Unable to parse the XML within the response", (Exception)((Object)e));
        }
        catch (UnmarshallingException e) {
            throw new SOAPClientException("Unable to unmarshall the response DOM", e);
        }
    }

    protected void evaluateSecurityPolicy(SOAPClientContext messageContext) throws SOAPClientException {
    }
}

