/*
 * Decompiled with CFR 0.152.
 */
package componenttest.app;

public class JavaInfo {
    private static JavaInfo instance;
    public static int JAVA_VERSION;
    private final int MAJOR;
    private final int MINOR;
    private final int MICRO;
    private final int SERVICE_RELEASE;
    private final int FIXPACK;

    private JavaInfo() {
        String version = System.getProperty("java.version");
        String[] versionElements = version.split("\\D");
        int i = Integer.parseInt(versionElements[0]) == 1 ? 1 : 0;
        this.MAJOR = Integer.parseInt(versionElements[i++]);
        this.MINOR = i < versionElements.length ? Integer.parseInt(versionElements[i++]) : 0;
        this.MICRO = i < versionElements.length ? Integer.parseInt(versionElements[i]) : 0;
        String buildInfo = System.getProperty("java.specification.version");
        int sr = 0;
        int srloc = buildInfo.toLowerCase().indexOf("sr");
        if (srloc > -1 && (srloc += 2) < buildInfo.length()) {
            int len = 0;
            while (srloc + len < buildInfo.length() && Character.isDigit(buildInfo.charAt(srloc + len))) {
                ++len;
            }
            sr = Integer.parseInt(buildInfo.substring(srloc, srloc + len));
        }
        this.SERVICE_RELEASE = sr;
        int fp = 0;
        int fploc = buildInfo.toLowerCase().indexOf("fp");
        if (fploc > -1 && (fploc += 2) < buildInfo.length()) {
            int len = 0;
            while (fploc + len < buildInfo.length() && Character.isDigit(buildInfo.charAt(fploc + len))) {
                ++len;
            }
            fp = Integer.parseInt(buildInfo.substring(fploc, fploc + len));
        }
        this.FIXPACK = fp;
    }

    private static JavaInfo instance() {
        if (instance == null) {
            instance = new JavaInfo();
        }
        return instance;
    }

    public static int majorVersion() {
        return JavaInfo.instance().MAJOR;
    }

    public static int minorVersion() {
        return JavaInfo.instance().MINOR;
    }

    public static int microVersion() {
        return JavaInfo.instance().MICRO;
    }

    public static int serviceRelease() {
        return JavaInfo.instance().SERVICE_RELEASE;
    }

    public static int fixpack() {
        return JavaInfo.instance().FIXPACK;
    }

    public String toString() {
        return "major=" + this.MAJOR + ", minor=" + this.MINOR + ", micro=" + this.MICRO + ", service release=" + this.SERVICE_RELEASE + ", fixpack=" + this.FIXPACK;
    }

    static {
        JAVA_VERSION = JavaInfo.majorVersion();
    }
}

