/*
 * Decompiled with CFR 0.152.
 */
package componenttest.app;

import componenttest.app.FATServlet;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonBuilderFactory;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonReader;
import javax.json.JsonReaderFactory;
import javax.json.JsonWriter;
import javax.json.JsonWriterFactory;

public class AssertionErrorSerializer {
    public static final String START_TAG = "###AssertionError Json Start###";
    public static final String END_TAG = "###AssertionError Json End###";
    private static final String CLASS_NAME_KEY = "className";
    private static final String METHOD_NAME_KEY = "methodName";
    private static final String EXCEPTION_TYPE_KEY = "exceptionType";
    private static final String MESSAGE_KEY = "message";
    private static final String STACK_KEY = "stack";
    private static final String FILE_NAME_KEY = "fileName";
    private static final String LINE_NUMBER_KEY = "lineNumber";
    private static final String DO_GET = "doGet";
    private static final JsonBuilderFactory BUILDER_FACTORY = Json.createBuilderFactory(null);
    private static final JsonReaderFactory READER_FACTORY = Json.createReaderFactory(null);
    private static final JsonWriterFactory WRITER_FACTORY = Json.createWriterFactory(null);

    public static String serialize(AssertionError e) {
        StringWriter writer = new StringWriter();
        AssertionErrorSerializer.serialize(e, writer);
        return writer.toString();
    }

    public static void serialize(AssertionError e, Writer writer) {
        JsonObject json = AssertionErrorSerializer.serializeAssertionError(e);
        JsonWriter jsonWriter = WRITER_FACTORY.createWriter(writer);
        jsonWriter.writeObject(json);
    }

    public static AssertionError deserialize(String json) {
        StringReader reader = new StringReader(json);
        AssertionError e = AssertionErrorSerializer.deserialize(reader);
        return e;
    }

    public static AssertionError deserialize(Reader reader) {
        JsonReader jsonReader = READER_FACTORY.createReader(reader);
        JsonObject jsonObject = jsonReader.readObject();
        jsonReader.close();
        AssertionError e = AssertionErrorSerializer.deserializeAssertionError(jsonObject);
        return e;
    }

    private static JsonObject serializeAssertionError(AssertionError e) {
        JsonObjectBuilder builder = BUILDER_FACTORY.createObjectBuilder();
        builder.add(EXCEPTION_TYPE_KEY, "AssertionError");
        builder.add(MESSAGE_KEY, ((Throwable)((Object)e)).getMessage());
        StackTraceElement[] stack = ((Throwable)((Object)e)).getStackTrace();
        JsonArray stackJson = AssertionErrorSerializer.serializeStack(stack);
        builder.add(STACK_KEY, stackJson);
        return builder.build();
    }

    private static AssertionError deserializeAssertionError(JsonObject jsonObject) {
        String exceptionType = jsonObject.getString(EXCEPTION_TYPE_KEY);
        if (!"AssertionError".equals(exceptionType)) {
            throw new IllegalStateException("Unknown exception type: " + exceptionType);
        }
        String message = jsonObject.getString(MESSAGE_KEY);
        JsonArray stackJson = jsonObject.getJsonArray(STACK_KEY);
        StackTraceElement[] stack = AssertionErrorSerializer.deserializeStack(stackJson);
        AssertionError assertionError = new AssertionError((Object)message);
        ((Throwable)((Object)assertionError)).setStackTrace(stack);
        return assertionError;
    }

    private static JsonArray serializeStack(StackTraceElement[] stack) {
        JsonArrayBuilder stackBuilder = BUILDER_FACTORY.createArrayBuilder();
        for (StackTraceElement element : stack) {
            JsonObject elementJson = AssertionErrorSerializer.serializeStackTraceElement(element);
            stackBuilder.add(elementJson);
        }
        return stackBuilder.build();
    }

    private static StackTraceElement[] deserializeStack(JsonArray jsonArray) {
        int size = jsonArray.size();
        StackTraceElement[] stack = new StackTraceElement[size];
        for (int i = 0; i < size; ++i) {
            StackTraceElement element;
            JsonObject elementJson = jsonArray.getJsonObject(i);
            stack[i] = element = AssertionErrorSerializer.deserializeStackTraceElement(elementJson);
        }
        return stack;
    }

    private static JsonObject serializeStackTraceElement(StackTraceElement stackTraceElement) {
        JsonObjectBuilder builder = BUILDER_FACTORY.createObjectBuilder();
        builder.add(CLASS_NAME_KEY, stackTraceElement.getClassName());
        builder.add(METHOD_NAME_KEY, stackTraceElement.getMethodName());
        if (stackTraceElement.getFileName() != null) {
            builder.add(FILE_NAME_KEY, stackTraceElement.getFileName());
        }
        builder.add(LINE_NUMBER_KEY, stackTraceElement.getLineNumber());
        return builder.build();
    }

    private static StackTraceElement deserializeStackTraceElement(JsonObject jsonObject) {
        String declaringClass = jsonObject.getString(CLASS_NAME_KEY, null);
        String methodName = jsonObject.getString(METHOD_NAME_KEY, null);
        String fileName = jsonObject.getString(FILE_NAME_KEY, null);
        int lineNumber = jsonObject.getInt(LINE_NUMBER_KEY);
        StackTraceElement element = new StackTraceElement(declaringClass, methodName, fileName, lineNumber);
        return element;
    }

    public static <T extends FATServlet> AssertionError simplify(Class<T> fatClass, String fatMethodName, AssertionError e) {
        AssertionError assertionError = new AssertionError((Object)(fatClass.getSimpleName() + "." + fatMethodName + ": " + ((Throwable)((Object)e)).getMessage()));
        StackTraceElement[] originalStack = ((Throwable)((Object)e)).getStackTrace();
        ArrayList<StackTraceElement> shortenedStack = new ArrayList<StackTraceElement>();
        for (StackTraceElement element : originalStack) {
            String declaringClass = element.getClassName();
            String methodName = element.getMethodName();
            String fileName = element.getFileName();
            int lineNumber = element.getLineNumber();
            StackTraceElement newElement = new StackTraceElement(declaringClass, methodName, fileName, lineNumber);
            shortenedStack.add(newElement);
            if ((FATServlet.class.getSimpleName() + ".java").equals(fileName) && DO_GET.equals(methodName)) break;
        }
        ((Throwable)((Object)assertionError)).setStackTrace(shortenedStack.toArray(new StackTraceElement[shortenedStack.size()]));
        return assertionError;
    }
}

