/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.reporting.internal;

import com.ibm.json.java.JSONObject;
import com.ibm.websphere.kernel.server.ServerInfoMBean;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.kernel.feature.FeatureProvisioner;
import com.ibm.ws.kernel.feature.FixManager;
import com.ibm.ws.kernel.productinfo.DuplicateProductInfoException;
import com.ibm.ws.kernel.productinfo.ProductInfo;
import com.ibm.ws.kernel.productinfo.ProductInfoParseException;
import com.ibm.ws.kernel.productinfo.ProductInfoReplaceException;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.reporting.internal.CVEResponseHandler;
import io.openliberty.reporting.internal.CVEServiceClient;
import io.openliberty.reporting.internal.DataCollector;
import io.openliberty.reporting.internal.DataCollectorException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Map;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ReporterTask
implements Runnable {
    private static final TraceComponent tc = Tr.register(ReporterTask.class, (String)"cveReporting", (String)"io.openliberty.reporting.internal.resources.CVEReporting");
    private final FeatureProvisioner featureProvisioner;
    private final FixManager fixManager;
    private final ServerInfoMBean serverInfo;
    private final Map<String, Object> props;
    static final long serialVersionUID = -307460603857886525L;

    public ReporterTask(FeatureProvisioner featureProvisioner, FixManager fixManager, ServerInfoMBean serverInfo, Map<String, Object> properties) {
        this.featureProvisioner = featureProvisioner;
        this.fixManager = fixManager;
        this.serverInfo = serverInfo;
        this.props = properties;
    }

    @Override
    @FFDCIgnore(value={DataCollectorException.class, MalformedURLException.class, IOException.class})
    public void run() {
        try {
            Map allProductInfo = ProductInfo.getAllProductInfo();
            DataCollector collector = new DataCollector(this.featureProvisioner, this.fixManager, this.serverInfo, allProductInfo);
            Map<String, String> data = collector.getData();
            String productUri = allProductInfo.containsKey("com.ibm.websphere.appserver") ? ((ProductInfo)allProductInfo.get("com.ibm.websphere.appserver")).getCVEReportingUri() : ((ProductInfo)allProductInfo.get("io.openliberty")).getCVEReportingUri();
            String urlLink = ReporterTask.setUrl(productUri, (String)this.props.get("urlLink"));
            JSONObject response = new CVEServiceClient().retrieveCVEData(data, urlLink);
            CVEResponseHandler.handleResponse(data.get("productEdition"), response);
        }
        catch (MalformedURLException e) {
            Tr.warning((TraceComponent)tc, (String)"CWWKF1704.incorrect.url", (Object[])new Object[]{e.getMessage()});
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Caused by: " + e), (Object[])new Object[0]);
            }
        }
        catch (IOException e) {
            Tr.warning((TraceComponent)tc, (String)"CWWKF1705.failed.response", (Object[])new Object[0]);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                String causes = ReporterTask.buildExceptionMessage(e);
                Tr.debug((TraceComponent)tc, (String)("Failed due to: " + causes), (Object[])new Object[0]);
            }
        }
        catch (DuplicateProductInfoException | ProductInfoParseException | ProductInfoReplaceException | DataCollectorException e) {
            Tr.warning((TraceComponent)tc, (String)"CWWKF1706.issue.parsing", (Object[])new Object[0]);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                String causes = ReporterTask.buildExceptionMessage(e);
                Tr.debug((TraceComponent)tc, (String)("Failed due to: " + causes), (Object[])new Object[0]);
            }
        }
        catch (Throwable e) {
            FFDCFilter.processException((Throwable)e, (String)"io.openliberty.reporting.internal.ReporterTask", (String)"86", (Object)this, (Object[])new Object[0]);
            Tr.warning((TraceComponent)tc, (String)"CWWKF1707.internal.error", (Object[])new Object[]{e});
            throw e;
        }
    }

    public static String buildExceptionMessage(Throwable e) {
        Throwable cause = null;
        Throwable e2 = e;
        StringBuilder causes = new StringBuilder(e2.toString());
        while (null != (cause = e2.getCause())) {
            causes.append(": ");
            causes.append(cause.toString());
            e2 = cause;
        }
        return causes.toString();
    }

    public static String setUrl(String cveReportingUri, String link) throws DataCollectorException {
        if ((link == null || link.isEmpty()) && ((link = cveReportingUri) == null || link.isEmpty())) {
            link = "https://cves.openliberty.io/report";
        }
        return link;
    }
}

