/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.reporting.internal;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.HashMap;
import java.util.Map;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class CVEResponseHandler {
    private static final TraceComponent tc = Tr.register(CVEResponseHandler.class, (String)"cveReporting", (String)"io.openliberty.reporting.internal.resources.CVEReporting");
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    static final long serialVersionUID = 6245706102574939453L;

    public static void handleResponse(String productEdition, JSONObject response) {
        JSONArray productArray = new JSONArray();
        String productUrl = "https://openliberty.io/docs/latest/security-vulnerabilities.html";
        if (response.get((Object)"cveProducts") != null) {
            productArray = (JSONArray)response.get((Object)"cveProducts");
            if (productArray.isEmpty()) {
                Tr.info((TraceComponent)tc, (String)"CWWKF1703.cve.not.found", (Object[])new Object[0]);
            }
            for (int i = 0; i < productArray.size(); ++i) {
                JSONObject cveProduct = (JSONObject)productArray.get(i);
                JSONArray cvesArray = new JSONArray();
                cvesArray = (JSONArray)cveProduct.get((Object)"cves");
                productUrl = cveProduct.get((Object)"url").toString();
                HashMap<String, String> bulletin = new HashMap<String, String>();
                for (int j = 0; j < cvesArray.size(); ++j) {
                    bulletin.clear();
                    for (int k = 0; k < cvesArray.size(); ++k) {
                        JSONObject cveObj = (JSONObject)cvesArray.get(k);
                        if (bulletin.containsKey(cveObj.get((Object)"url"))) {
                            StringBuilder cve = new StringBuilder((String)bulletin.get(cveObj.get((Object)"url")));
                            cve.append(", ").append(cveObj.get((Object)"id"));
                            bulletin.put(cveObj.get((Object)"url").toString(), cve.toString());
                            continue;
                        }
                        bulletin.put(cveObj.get((Object)"url").toString(), cveObj.get((Object)"id").toString());
                    }
                }
                StringBuilder message = new StringBuilder();
                for (Map.Entry e : bulletin.entrySet()) {
                    message.append(LINE_SEPARATOR);
                    message.append((String)e.getKey()).append(" - ").append((String)e.getValue());
                }
                Tr.warning((TraceComponent)tc, (String)"CWWKF1702.cve.found", (Object[])new Object[]{cveProduct.get((Object)"productName"), message.toString()});
                Tr.warning((TraceComponent)tc, (String)"more.information.message", (Object[])new Object[]{productUrl});
            }
        }
    }
}

