/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.tx.jta.ut.util;

import com.ibm.tx.jta.DestroyXAResourceException;
import com.ibm.tx.jta.XAResourceFactory;
import com.ibm.tx.jta.XAResourceNotAvailableException;
import com.ibm.tx.jta.ut.util.AbortableXAResourceImpl;
import com.ibm.tx.jta.ut.util.LastingXAResourceImpl;
import com.ibm.tx.jta.ut.util.XAResourceImpl;
import com.ibm.tx.jta.ut.util.XAResourceInfoImpl;
import java.io.Serializable;
import java.util.Hashtable;
import javax.transaction.xa.XAResource;

public class XAResourceFactoryImpl
implements XAResourceFactory {
    public static final int RETURN_NULL = 0;
    private static XAResourceFactoryImpl _instance = new XAResourceFactoryImpl();
    private static boolean _stateLoaded;
    private static final Hashtable<XAResourceInfoImpl, Object> _getActions;
    private static final Hashtable<XAResourceInfoImpl, Integer> _getActionRepeatCounts;
    private static final Hashtable<XAResourceImpl, Object> _destroyActions;
    private static final Hashtable<XAResourceImpl, Integer> _destroyActionRepeatCounts;

    public static XAResourceFactoryImpl instance() {
        return _instance;
    }

    public static void setGetAction(XAResourceInfoImpl xaResInfo, Object getAction) {
        _getActions.put(xaResInfo, getAction);
    }

    public static void setDestroyAction(XAResourceImpl xaRes, Object destroyAction) {
        _destroyActions.put(xaRes, destroyAction);
    }

    public static void setGetActionRepeatCount(XAResourceInfoImpl xaResInfo, int i) {
        _getActionRepeatCounts.put(xaResInfo, i);
    }

    public static void setDestroyActionRepeatCount(XAResourceImpl xaRes, int i) {
        _destroyActionRepeatCounts.put(xaRes, i);
    }

    private int getGetActionRepeatCount(Serializable xaResInfo) {
        Integer i = _getActionRepeatCounts.get(xaResInfo);
        if (i == null) {
            return 0;
        }
        return i;
    }

    private int getDestroyActionRepeatCount(XAResource xaRes) {
        Integer i = _destroyActionRepeatCounts.get(xaRes);
        if (i == null) {
            return 0;
        }
        return i;
    }

    public void destroyXAResource(XAResource xaRes) throws DestroyXAResourceException {
        Object action = _destroyActions.get(xaRes);
        if (action instanceof DestroyXAResourceException) {
            int repeatCount = this.getDestroyActionRepeatCount(xaRes);
            _destroyActionRepeatCounts.put((XAResourceImpl)xaRes, repeatCount - 1);
            if (repeatCount >= 0) {
                throw (DestroyXAResourceException)action;
            }
        } else if (action instanceof RuntimeException) {
            int repeatCount = this.getDestroyActionRepeatCount(xaRes);
            _destroyActionRepeatCounts.put((XAResourceImpl)xaRes, repeatCount - 1);
            if (repeatCount >= 0) {
                throw (RuntimeException)action;
            }
        }
        XAResourceImpl.destroy((XAResourceImpl)xaRes);
    }

    public XAResource getXAResource(Serializable xaResInfo) throws XAResourceNotAvailableException {
        Object action;
        if (!XAResourceImpl.isStateLoaded()) {
            XAResourceImpl.loadState(((XAResourceInfoImpl)xaResInfo).getStateFile());
        }
        if ((action = _getActions.get(xaResInfo)) instanceof XAResourceNotAvailableException) {
            int repeatCount = this.getGetActionRepeatCount(xaResInfo);
            _getActionRepeatCounts.put((XAResourceInfoImpl)xaResInfo, repeatCount - 1);
            if (repeatCount >= 0) {
                throw (XAResourceNotAvailableException)action;
            }
        } else if (action instanceof RuntimeException) {
            int repeatCount = this.getGetActionRepeatCount(xaResInfo);
            _getActionRepeatCounts.put((XAResourceInfoImpl)xaResInfo, repeatCount - 1);
            if (repeatCount >= 0) {
                throw (RuntimeException)action;
            }
        } else if (action instanceof Integer) {
            switch ((Integer)action) {
                case 0: {
                    int repeatCount = this.getGetActionRepeatCount(xaResInfo);
                    _getActionRepeatCounts.put((XAResourceInfoImpl)xaResInfo, repeatCount - 1);
                    if (repeatCount < 0) break;
                    return null;
                }
            }
        }
        return XAResourceImpl.getXAResourceImpl(((XAResourceInfoImpl)xaResInfo).getKey());
    }

    public XAResourceImpl getXAResourceImpl(Serializable xaresinfo) throws XAResourceNotAvailableException {
        return XAResourceImpl.getXAResourceImpl(((XAResourceInfoImpl)xaresinfo).getKey());
    }

    public LastingXAResourceImpl getLastingXAResourceImpl(int i) throws XAResourceNotAvailableException {
        return LastingXAResourceImpl.getLastingXAResourceImpl(i);
    }

    public AbortableXAResourceImpl getAbortableXAResourceImpl(Serializable xaresinfo) throws XAResourceNotAvailableException {
        return AbortableXAResourceImpl.getAbortableXAResourceImpl(((XAResourceInfoImpl)xaresinfo).getKey());
    }

    public LastingXAResourceImpl getLastingXAResourceImpl() {
        return LastingXAResourceImpl.getLastingXAResourceImpl();
    }

    static {
        _getActions = new Hashtable();
        _getActionRepeatCounts = new Hashtable();
        _destroyActions = new Hashtable();
        _destroyActionRepeatCounts = new Hashtable();
    }
}

