/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.tx.jta.ut.util;

import com.ibm.tx.jta.impl.UserTransactionImpl;
import com.ibm.tx.jta.ut.util.XAResourceImpl;
import com.ibm.ws.uow.UOWScope;
import com.ibm.ws.uow.UOWScopeCallback;
import java.io.File;
import java.io.IOException;
import java.net.ConnectException;
import java.nio.file.attribute.FileTime;
import java.sql.SQLException;
import java.sql.SQLNonTransientException;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class TxTestUtils {
    private static final long serialVersionUID = 1L;
    private static final String pattern = "dd/MM/uuuu, HH:mm.ss:SSS z";
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("dd/MM/uuuu, HH:mm.ss:SSS z");
    private static final ZoneId ZONE_ID = ZoneId.systemDefault();
    public static final String CONNECTION_MANAGER_FAILS = "CONNECTION_MANAGER_FAILS";
    public static final String SUCCESS_MESSAGE = "COMPLETED SUCCESSFULLY";
    private static int connectCount;
    private static final int DEFAULT_REQUEST_TIMEOUT = 300000;

    public static final String traceTime(long timestamp) {
        return Instant.ofEpochMilli(timestamp).atZone(ZONE_ID).format(DATE_TIME_FORMATTER);
    }

    public static final String traceTime(FileTime timestamp) {
        return timestamp.toInstant().atZone(ZONE_ID).format(DATE_TIME_FORMATTER);
    }

    public static String printStatus(int status) {
        switch (status) {
            case 0: {
                return "Status.STATUS_ACTIVE";
            }
            case 3: {
                return "Status.STATUS_COMMITTED";
            }
            case 8: {
                return "Status.STATUS_COMMITTING";
            }
            case 1: {
                return "Status.STATUS_MARKED_ROLLBACK";
            }
            case 6: {
                return "Status.STATUS_NO_TRANSACTION";
            }
            case 2: {
                return "Status.STATUS_PREPARED";
            }
            case 7: {
                return "Status.STATUS_PREPARING";
            }
            case 4: {
                return "Status.STATUS_ROLLEDBACK";
            }
            case 9: {
                return "Status.STATUS_ROLLING_BACK";
            }
        }
        return "Status.STATUS_UNKNOWN";
    }

    public static void scupperConnection() throws SQLException {
        String fails = System.getenv(CONNECTION_MANAGER_FAILS);
        System.out.println("SIMHADB: getDriverConnection: CONNECTION_MANAGER_FAILS=" + fails);
        HashSet<Integer> failSet = new HashSet<Integer>();
        if (fails != null) {
            StringTokenizer st = new StringTokenizer(fails, ",");
            while (st.hasMoreTokens()) {
                failSet.add(Integer.parseInt(st.nextToken()));
            }
        }
        System.out.println("SIMHADB: getDriverConnection: connectCount=" + ++connectCount);
        if (failSet.contains(connectCount)) {
            System.out.println("SIMHADB: getDriverConnection: scuppering now");
            throw new SQLNonTransientException(new ConnectException("Scuppering connection attempt number " + connectCount));
        }
    }

    public static void setTestResourcesFile() throws IOException {
        String recoveryId = System.getProperty("LOCAL_RECOVERY_ID");
        System.out.println("setTestResourcesFile: recoveryId prop=" + recoveryId);
        if (recoveryId != null) {
            String resourcesDirPath = System.getenv("WLP_OUTPUT_DIR") + "/../shared/test-resources/" + recoveryId;
            File resourcesDir = new File(resourcesDirPath);
            if (!resourcesDir.exists()) {
                resourcesDir.mkdirs();
            }
            XAResourceImpl.setStateFile(new File(resourcesDir.getPath() + File.separator + "XAResources.dat"));
            System.out.println("setTestResourcesFile: " + XAResourceImpl.STATE_FILE);
        }
    }

    public static void setTimeouts(Map<String, Object> requestContext) {
        TxTestUtils.setTimeouts(requestContext, 300000);
    }

    public static void setTimeouts(Map<String, Object> requestContext, int timeout) {
        requestContext.put("com.sun.xml.ws.connect.timeout", timeout);
        requestContext.put("com.sun.xml.ws.request.timeout", timeout);
        requestContext.put("javax.xml.ws.client.connectionTimeout", timeout);
        requestContext.put("javax.xml.ws.client.receiveTimeout", timeout);
    }

    public static UOWScopeCallback registerUOWScopeCallback() {
        UOWScopeCallbackImpl cb = new UOWScopeCallbackImpl();
        UserTransactionImpl.instance().registerCallback((UOWScopeCallback)cb);
        return cb;
    }

    public static void unregisterUOWScopeCallback(UOWScopeCallback cb) {
        UserTransactionImpl.instance().unregisterCallback(cb);
    }

    public static boolean allCallbacksCalled(UOWScopeCallback cb) {
        return ((UOWScopeCallbackImpl)cb).allCallbacksCalled();
    }

    public static boolean onlyBeginCallbacksCalled(UOWScopeCallback cb) {
        return ((UOWScopeCallbackImpl)cb).onlyBeginCallbacksCalled();
    }

    private static class UOWScopeCallbackImpl
    implements UOWScopeCallback {
        private Set<Integer> _contextChanges = new HashSet<Integer>();

        private UOWScopeCallbackImpl() {
        }

        public boolean allCallbacksCalled() {
            return this._contextChanges.contains(0) && this._contextChanges.contains(1) && this._contextChanges.contains(2) && this._contextChanges.contains(3);
        }

        public boolean onlyBeginCallbacksCalled() {
            return this._contextChanges.contains(0) && this._contextChanges.contains(1) && !this._contextChanges.contains(2) && !this._contextChanges.contains(3);
        }

        public void contextChange(int changeType, UOWScope uowScope) throws IllegalStateException {
            System.out.println("Change Type: " + changeType + ", UOWScope: " + uowScope);
            for (StackTraceElement ste : Thread.currentThread().getStackTrace()) {
                System.out.println(ste + "\n");
            }
            this._contextChanges.add(changeType);
        }
    }
}

