/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.tx.jta.ut.util;

import com.ibm.tx.jta.ut.util.StateKeeper;
import com.ibm.tx.jta.ut.util.XAResourceImpl;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;

public class LastingXAResourceImpl
extends XAResourceImpl {
    private static final long serialVersionUID = -620973956139953529L;
    public static final String STATE_FILE_ROOT = "CloudResources.dat";
    protected static boolean _attemptedStateLoad;
    protected static int _numberloadedResources;
    protected static int _recoveredResourceCount;
    protected static boolean _attemptedFileInit;
    public static boolean STORE_STATE_IN_DATABASE;
    public static boolean INTERRUPT_IN_RECOVERY;
    private static dbStore _dbStore;

    public static LastingXAResourceImpl getLastingXAResourceImpl(int i) {
        return new LastingXAResourceImpl(i);
    }

    public LastingXAResourceImpl(int i) {
        super(i);
        if (STORE_STATE_IN_DATABASE) {
            if (_dbStore == null) {
                try {
                    _dbStore = new dbStore();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } else if (!_attemptedFileInit) {
            _attemptedFileInit = true;
            this.resetFile();
        }
    }

    private void resetFile() {
    }

    public LastingXAResourceImpl(String i) throws Exception {
        super(i);
        if (STORE_STATE_IN_DATABASE) {
            if (_dbStore == null) {
                _dbStore = new dbStore();
                _dbStore.clear();
            }
        } else if (!_attemptedFileInit) {
            _attemptedFileInit = true;
            this.resetFile();
        }
    }

    public LastingXAResourceImpl() {
        if (STORE_STATE_IN_DATABASE) {
            if (_dbStore == null) {
                try {
                    _dbStore = new dbStore();
                    _dbStore.clear();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } else if (!_attemptedFileInit) {
            _attemptedFileInit = true;
            this.resetFile();
        }
    }

    @Override
    public Xid[] recover(int flag) throws XAException {
        Xid[] theXids = null;
        try {
            if (DEBUG_OUTPUT) {
                System.out.println("recover entry");
            }
            if (STORE_STATE_IN_DATABASE) {
                if (_dbStore == null) {
                    _dbStore = new dbStore();
                }
                if (!_attemptedStateLoad) {
                    if (DEBUG_OUTPUT) {
                        System.out.println("recover doing state load");
                    }
                    _attemptedStateLoad = true;
                    _numberloadedResources = LastingXAResourceImpl.loadState();
                    _recoveredResourceCount = 0;
                }
            } else if (!_attemptedStateLoad) {
                _attemptedStateLoad = true;
                _numberloadedResources = XAResourceImpl.loadState();
                _recoveredResourceCount = 0;
            }
            theXids = super.recover(flag);
            ++_recoveredResourceCount;
            if (DEBUG_OUTPUT) {
                System.out.println("recover resource count is " + _recoveredResourceCount);
            }
            if (INTERRUPT_IN_RECOVERY) {
                dbStore.updateLogOwnership();
            }
            if (_recoveredResourceCount >= _numberloadedResources) {
                if (DEBUG_OUTPUT) {
                    System.out.println("recover: Final call to recover");
                }
                _attemptedStateLoad = false;
                if (STORE_STATE_IN_DATABASE) {
                    _dbStore.clear();
                } else if (!_attemptedFileInit) {
                    _attemptedFileInit = true;
                    this.resetFile();
                }
            }
        }
        catch (Throwable t) {
            XAException xae = new XAException();
            xae.errorCode = -7;
            xae.initCause(t);
            xae.printStackTrace();
            throw xae;
        }
        return theXids;
    }

    @Override
    public void commit(Xid xid, boolean onePhase) throws XAException {
        super.commit(xid, onePhase);
        if (DEBUG_OUTPUT) {
            System.out.println("commit - clean up old resource for key: " + this._key);
        }
        _resources.remove(this._key);
    }

    @Override
    public void rollback(Xid xid) throws XAException {
        super.rollback(xid);
        if (DEBUG_OUTPUT) {
            System.out.println("rollback - clean up old resource for key: " + this._key);
        }
        _resources.remove(this._key);
    }

    public static LastingXAResourceImpl getLastingXAResourceImpl() {
        return new LastingXAResourceImpl();
    }

    public static synchronized int loadState() {
        int numResources = stateKeeper.loadState();
        _stateLoaded = true;
        LastingXAResourceImpl.printState();
        return numResources;
    }

    static {
        STORE_STATE_IN_DATABASE = true;
        stateKeeper = new LastingStateKeeperImpl();
    }

    public static class dbStore {
        static DataSource _theDS = null;

        public dbStore() throws Exception {
            this.init();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void init() throws Exception {
            Connection con1 = null;
            try {
                if (_theDS == null) {
                    _theDS = dbStore.lookupDataSource();
                }
                con1 = _theDS.getConnection();
                if (XAResourceImpl.DEBUG_OUTPUT) {
                    System.out.println("init Got connection: " + con1);
                }
                DatabaseMetaData mdata = con1.getMetaData();
                if (XAResourceImpl.DEBUG_OUTPUT) {
                    System.out.println("init Got metadata: " + mdata);
                }
                String dbName = mdata.getDatabaseProductName();
                String dbVersion = mdata.getDatabaseProductVersion();
                if (XAResourceImpl.DEBUG_OUTPUT) {
                    System.out.println("init is now connected to " + dbName + ", version " + dbVersion);
                }
                System.out.println("create a statement");
                Statement stmtBasic = con1.createStatement();
                try {
                    if (XAResourceImpl.DEBUG_OUTPUT) {
                        System.out.println("Execute a query to determine if we need to create a table");
                    }
                    stmtBasic.executeQuery("SELECT RESOURCE_ID, DATA FROM WAS_XA_RESOURCES WHERE RESOURCE_ID='1'");
                }
                catch (Exception e) {
                    if (XAResourceImpl.DEBUG_OUTPUT) {
                        System.out.println("couldn't find the table ... so create it");
                    }
                    Statement stmt2 = con1.createStatement();
                    stmt2.executeUpdate("CREATE TABLE WAS_XA_RESOURCES( RESOURCE_ID VARCHAR(60), DATA LONG VARCHAR FOR BIT DATA) ");
                    if (XAResourceImpl.DEBUG_OUTPUT) {
                        System.out.println("Have created the table");
                    }
                    stmt2.close();
                    con1.commit();
                }
            }
            finally {
                if (con1 != null) {
                    try {
                        if (XAResourceImpl.DEBUG_OUTPUT) {
                            System.out.println("Drive COMMIT processing");
                        }
                        con1.commit();
                    }
                    catch (Exception e) {
                        System.out.println("Exception thrown when committing: " + e);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static int getXAResources() {
            Connection con1 = null;
            Statement stmtBasic = null;
            ResultSet rsBasic = null;
            int resourceCount = 0;
            try {
                if (_theDS == null) {
                    _theDS = dbStore.lookupDataSource();
                }
                con1 = _theDS.getConnection();
                if (XAResourceImpl.DEBUG_OUTPUT) {
                    new Throwable("getXAResources Got connection: " + con1).printStackTrace();
                }
                stmtBasic = con1.createStatement();
                rsBasic = stmtBasic.executeQuery("SELECT RESOURCE_ID, DATA FROM WAS_XA_RESOURCES");
                while (rsBasic.next()) {
                    String resId = rsBasic.getString(1);
                    byte[] data = rsBasic.getBytes(2);
                    if (XAResourceImpl.DEBUG_OUTPUT) {
                        System.out.println("Resource Table: read rid: " + resId);
                        System.out.println("Resource Table: read data: " + data);
                    }
                    if (resId.equals("-99")) {
                        if (XAResourceImpl.DEBUG_OUTPUT) {
                            System.out.println("getXAResources found special interrupt key");
                        }
                        INTERRUPT_IN_RECOVERY = true;
                        continue;
                    }
                    ObjectInputStream objectIn = null;
                    if (data != null) {
                        objectIn = new ObjectInputStream(new ByteArrayInputStream(data));
                    }
                    XAResourceImpl.XAResourceData xares = (XAResourceImpl.XAResourceData)objectIn.readObject();
                    System.out.println("_resources.put(\"" + resId + "\", " + xares + ")");
                    XAResourceImpl._resources.put(resId, xares);
                    ++resourceCount;
                }
                if (XAResourceImpl.DEBUG_OUTPUT) {
                    System.out.println("getXAResources Loaded " + resourceCount + " resources");
                }
            }
            catch (Exception e) {
                System.out.println("getXAResources, Exception thrown when retrieving data: " + e);
                e.printStackTrace();
            }
            finally {
                try {
                    if (stmtBasic != null) {
                        stmtBasic.close();
                    }
                    if (con1 != null) {
                        con1.commit();
                        con1.close();
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            return resourceCount;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void updateLogOwnership() {
            Connection con1 = null;
            Statement stmtBasic = null;
            try {
                if (_theDS == null) {
                    _theDS = dbStore.lookupDataSource();
                }
                con1 = _theDS.getConnection();
                if (XAResourceImpl.DEBUG_OUTPUT) {
                    new Throwable("updateLogOwnership Got connection: " + con1).printStackTrace();
                }
                Statement stmt = con1.createStatement();
                try {
                    System.out.println("updateLogOwnership: sel-for-update against partner log table");
                    String selForUpdateString = "SELECT SERVER_NAME FROM WAS_PARTNER_LOGcloud001 WHERE RU_ID = -1 FOR UPDATE OF SERVER_NAME";
                    ResultSet rs = stmt.executeQuery(selForUpdateString);
                    while (rs.next()) {
                        String owner = rs.getString("SERVER_NAME");
                        System.out.println("updateLogOwnership: owner is - " + owner);
                    }
                    rs.close();
                    String updateString = "UPDATE WAS_PARTNER_LOGcloud001 SET SERVER_NAME = 'cloud001' WHERE RU_ID = -1";
                    stmt.executeUpdate(updateString);
                }
                catch (SQLException x) {
                    System.out.println("updateLogOwnership: caught exception - " + x);
                }
                System.out.println("updateLogOwnership: commit changes to database");
                con1.commit();
            }
            catch (Exception ex) {
                System.out.println("updateLogOwnership: caught exception " + ex);
            }
            finally {
                try {
                    if (stmtBasic != null) {
                        stmtBasic.close();
                    }
                    if (con1 != null) {
                        con1.commit();
                        con1.close();
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clear() {
            if (XAResourceImpl.DEBUG_OUTPUT) {
                System.out.println("clear XAResources table");
            }
            Connection con1 = null;
            Statement stmtBasic = null;
            try {
                if (_theDS == null) {
                    _theDS = dbStore.lookupDataSource();
                }
                con1 = _theDS.getConnection();
                if (XAResourceImpl.DEBUG_OUTPUT) {
                    System.out.println("clear Got connection: " + con1);
                }
                String deleteString = "DELETE FROM WAS_XA_RESOURCES";
                if (XAResourceImpl.DEBUG_OUTPUT) {
                    System.out.println("clear: Delete all rows in  WAS_XA_RESOURCES");
                }
                stmtBasic = con1.createStatement();
                stmtBasic.executeUpdate(deleteString);
            }
            catch (Exception e) {
                System.out.println("caught Exception in dbStore.clear " + e);
            }
            finally {
                try {
                    if (stmtBasic != null) {
                        stmtBasic.close();
                    }
                    if (con1 != null) {
                        con1.commit();
                        con1.close();
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void putXAResources() {
            Connection con1 = null;
            Statement insertStatement = null;
            try {
                if (_theDS == null) {
                    _theDS = dbStore.lookupDataSource();
                }
                con1 = _theDS.getConnection();
                if (XAResourceImpl.DEBUG_OUTPUT) {
                    System.out.println("putXAResources Got connection: " + con1);
                }
                String insertString = "INSERT INTO WAS_XA_RESOURCES (RESOURCE_ID, DATA) VALUES (?,?)";
                insertStatement = con1.prepareStatement(insertString);
                if (XAResourceImpl.DEBUG_OUTPUT) {
                    System.out.println("putXAResources prepare to insert " + XAResourceImpl._resources.size() + " resources");
                }
                for (XAResourceImpl.XAResourceData xares : XAResourceImpl._resources.values()) {
                    String resKey = xares.key;
                    if (XAResourceImpl.DEBUG_OUTPUT) {
                        System.out.println("putXAResources Insert row for key: " + resKey);
                        System.out.println("And data with XID: " + xares.getXids());
                    }
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    ObjectOutputStream oos = new ObjectOutputStream(baos);
                    oos.writeObject(xares);
                    byte[] data = baos.toByteArray();
                    insertStatement.setString(1, resKey);
                    insertStatement.setBytes(2, data);
                    int ret = insertStatement.executeUpdate();
                    if (!XAResourceImpl.DEBUG_OUTPUT) continue;
                    System.out.println("putXAResources Inserted row with return: " + ret);
                }
                if (XAResourceImpl._resources.size() > 0 && INTERRUPT_IN_RECOVERY) {
                    if (XAResourceImpl.DEBUG_OUTPUT) {
                        System.out.println("putXAResources insert special interrupt key");
                    }
                    insertStatement.setInt(1, -99);
                    insertStatement.setBytes(2, null);
                    int ret = insertStatement.executeUpdate();
                    if (XAResourceImpl.DEBUG_OUTPUT) {
                        System.out.println("putXAResources Inserted row with return: " + ret);
                    }
                }
            }
            catch (Exception e) {
                System.out.println("putXAResources, Exception thrown when inserting data: " + e);
                e.printStackTrace();
            }
            finally {
                try {
                    if (insertStatement != null) {
                        insertStatement.close();
                    }
                    if (con1 != null) {
                        con1.commit();
                        con1.close();
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }

        private static DataSource lookupDataSource() throws Exception {
            InitialContext ctx = new InitialContext();
            System.out.println("Context is: " + ctx.toString());
            DataSource ds = null;
            try {
                ds = (DataSource)ctx.lookup("java:comp/env/jdbc/tranlogDataSource");
            }
            catch (NamingException nex) {
                System.out.println("Try alternate lookup");
                ds = (DataSource)ctx.lookup("jdbc/tranlogDataSource");
            }
            if (XAResourceImpl.DEBUG_OUTPUT) {
                System.out.println("TEST UTIL VERSION, GOT DATASOURCE: " + ds);
            }
            if (XAResourceImpl.DEBUG_OUTPUT) {
                System.out.println("HAVE LOOKED UP DATASOURCE " + ds);
            }
            return ds;
        }
    }

    static class LastingStateKeeperImpl
    implements StateKeeper {
        LastingStateKeeperImpl() {
        }

        @Override
        public void dumpState(boolean quietly) {
            boolean bl = XAResourceImpl.dumped = !quietly;
            if (STORE_STATE_IN_DATABASE) {
                System.out.println("Dumping state to database");
                System.out.println("Dump State: " + XAResourceImpl._resources.values().size());
                dbStore.putXAResources();
            } else {
                XAResourceImpl.dumpState();
            }
        }

        @Override
        public int loadState() {
            int resourceCount = 0;
            resourceCount = STORE_STATE_IN_DATABASE ? dbStore.getXAResources() : XAResourceImpl.loadState();
            return resourceCount;
        }
    }
}

