/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.repository.generator;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.repository.common.enums.ResourceType;
import com.ibm.ws.repository.connections.RepositoryConnection;
import com.ibm.ws.repository.connections.SingleFileRepositoryConnection;
import com.ibm.ws.repository.parsers.EsaParser;
import com.ibm.ws.repository.parsers.PaxParser;
import com.ibm.ws.repository.parsers.ProductParser;
import com.ibm.ws.repository.parsers.ProductZipParser;
import com.ibm.ws.repository.parsers.SamplesParser;
import com.ibm.ws.repository.parsers.ToolParser;
import com.ibm.ws.repository.resources.writeable.RepositoryResourceWritable;
import com.ibm.ws.repository.strategies.writeable.AddThenDeleteStrategy;
import com.ibm.ws.repository.strategies.writeable.UploadStrategy;
import java.io.File;
import java.io.IOException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class SingleJsonRepositoryGenerator
extends Task {
    private File assetFile;
    private String assetFilePath;
    private File metadataFile;
    private String assetType;
    private ResourceType assetTypeEnumValue;
    private File jsonFile;
    static final long serialVersionUID = 6819440920366400064L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    /*
     * WARNING - void declaration
     */
    public void execute() throws BuildException {
        System.out.println("CreateJsonRepositoryFiles called with following parameters");
        System.out.println("- AssetFile      = " + this.getAssetFile().getAbsolutePath());
        String metadataFileAbsPath = this.getMetadataFile() == null ? "null" : this.getMetadataFile().getAbsolutePath();
        System.out.println("- MetadataFile   = " + metadataFileAbsPath);
        System.out.println("- AssetType      = " + this.getAssetType());
        try {
            this.assetTypeEnumValue = ResourceType.valueOf((String)this.assetType);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            void iae;
            FFDCFilter.processException((Throwable)illegalArgumentException, (String)"com.ibm.ws.repository.generator.SingleJsonRepositoryGenerator", (String)"54", (Object)((Object)this), (Object[])new Object[0]);
            iae.printStackTrace();
            throw new BuildException((Throwable)iae);
        }
        SingleFileRepositoryConnection mySingleFileRepo = null;
        if (this.jsonFile.exists()) {
            mySingleFileRepo = new SingleFileRepositoryConnection(this.jsonFile);
        } else {
            try {
                mySingleFileRepo = SingleFileRepositoryConnection.createEmptyRepository((File)this.jsonFile);
            }
            catch (IOException iOException) {
                void e;
                FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.repository.generator.SingleJsonRepositoryGenerator", (String)"65", (Object)((Object)this), (Object[])new Object[0]);
                e.printStackTrace();
            }
        }
        SamplesParser parser = null;
        try {
            switch (this.assetTypeEnumValue) {
                case PRODUCTSAMPLE: 
                case OPENSOURCE: {
                    parser = new SamplesParser();
                    break;
                }
                case CONFIGSNIPPET: {
                    break;
                }
                case ADMINSCRIPT: {
                    break;
                }
                case TOOL: {
                    parser = new ToolParser();
                    break;
                }
                case ADDON: 
                case INSTALL: {
                    if (this.isPax(this.assetFile)) {
                        parser = new PaxParser();
                        break;
                    }
                    if (this.isZip(this.assetFile)) {
                        parser = new ProductZipParser();
                        break;
                    }
                    parser = new ProductParser();
                    break;
                }
                case FEATURE: {
                    parser = new EsaParser();
                    break;
                }
                case IFIX: {
                    break;
                }
            }
            if (parser != null) {
                RepositoryResourceWritable resource = parser.parseFileToResource(this.assetFile, this.metadataFile, null);
                resource.updateGeneratedFields(true);
                resource.setRepositoryConnection((RepositoryConnection)mySingleFileRepo);
                resource.uploadToMassive((UploadStrategy)new AddThenDeleteStrategy());
            }
        }
        catch (Exception resource) {
            void e;
            FFDCFilter.processException((Throwable)resource, (String)"com.ibm.ws.repository.generator.SingleJsonRepositoryGenerator", (String)"126", (Object)((Object)this), (Object[])new Object[0]);
            e.printStackTrace();
            throw new BuildException((Throwable)e);
        }
    }

    private boolean isPax(File f) {
        return f.getName().toLowerCase().endsWith(".pax");
    }

    private boolean isZip(File f) {
        return f.getName().toLowerCase().endsWith(".zip");
    }

    public File getAssetFile() {
        return this.assetFile;
    }

    public void setAssetFile(File assetFile) {
        this.assetFile = assetFile;
    }

    public String getAssetFilePath() {
        return this.assetFilePath;
    }

    public void setAssetFilePath(String assetFilePath) {
        this.assetFilePath = assetFilePath;
    }

    public File getMetadataFile() {
        return this.metadataFile;
    }

    public void setMetadataFile(File metadataFile) {
        this.metadataFile = metadataFile.getName().equalsIgnoreCase("null") ? null : metadataFile;
    }

    public String getAssetType() {
        return this.assetType;
    }

    public void setAssetType(String assetType) {
        this.assetType = assetType;
    }

    public File getJsonFile() {
        return this.jsonFile;
    }

    public void setJsonFile(File jsonFile) {
        this.jsonFile = jsonFile;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.repository.generator.SingleJsonRepositoryGenerator", SingleJsonRepositoryGenerator.class, null, null);
    }
}

