/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.oauth20.jwt;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.SecurityService;
import com.ibm.ws.security.oauth20.api.OAuth20Provider;
import com.ibm.ws.security.oauth20.util.BoundedCommonCache;
import java.util.HashMap;
import java.util.Map;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class JwtGrantTypeHandlerConfig {
    private static final TraceComponent tc = Tr.register(JwtGrantTypeHandlerConfig.class, (String)"OpenIdConnect", (String)"com.ibm.ws.security.oauth20.jwt.resources.JwtServerMessages");
    OAuth20Provider _config = null;
    Map<String, Object> _customizedAttribs = new HashMap<String, Object>();
    private String _providerId = null;
    static HashMap<String, BoundedCommonCache<String>> _mapCaches = new HashMap();
    static final long serialVersionUID = 3525845675788248516L;

    public JwtGrantTypeHandlerConfig(String providerId, OAuth20Provider config) {
        this._providerId = providerId;
        this._config = config;
    }

    public String getProviderId() {
        return this._providerId;
    }

    public SecurityService getSecurityService() {
        return this._config.getSecurityService();
    }

    public long getJwtClockSkew() {
        long lJwtSkew = this._config.getJwtClockSkew();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("jwt skew seconds: " + lJwtSkew), (Object[])new Object[0]);
        }
        return lJwtSkew;
    }

    public long getJwtMaxJtiCacheSize() {
        long cacheSize = this._config.getJwtMaxJtiCacheSize();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("JwtMaxJtiCacheSiz: " + cacheSize), (Object[])new Object[0]);
        }
        return cacheSize;
    }

    public long getJwtTokenMaxLifetime() {
        long lLifetime = this._config.getJwtTokenMaxLifetime();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("JwtMaxLifetimeAllowed seconds: " + lLifetime), (Object[])new Object[0]);
        }
        return lLifetime;
    }

    public boolean isJwtIatRequired() {
        boolean iatRequired = this._config.getJwtIatRequired();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("isJwtIatRequired: " + iatRequired), (Object[])new Object[0]);
        }
        return iatRequired;
    }

    public BoundedCommonCache<String> getJtiCache() {
        long lMaxSize = this._config.getJwtMaxJtiCacheSize();
        BoundedCommonCache jtiCache = _mapCaches.get(this._providerId);
        if (jtiCache == null) {
            jtiCache = new BoundedCommonCache((int)lMaxSize);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("JwtMaxJtiCacheSize(89) created: " + lMaxSize), (Object[])new Object[0]);
            }
            _mapCaches.put(this._providerId, (BoundedCommonCache<String>)jtiCache);
        } else {
            long lOriginalSize = jtiCache.getCapacity();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("JwtMaxJtiCacheSize(95) original:" + lOriginalSize + " newSize:" + lMaxSize), (Object[])new Object[0]);
            }
            if (lOriginalSize != lMaxSize) {
                jtiCache.updateCapacity((int)lMaxSize);
            }
        }
        return jtiCache;
    }

    public boolean isAutoAuthorize() {
        return this._config.isAutoAuthorize();
    }

    public boolean isAutoAuthorizeClient(String clientId) {
        String[] clients;
        for (String client : clients = this._config.getAutoAuthorizeClients()) {
            if (!clientId.equals(client)) continue;
            return true;
        }
        return false;
    }
}

