/*
 * Decompiled with CFR 0.152.
 */
package jakarta.data.page;

import jakarta.data.page.PageRequestCursor;
import jakarta.data.page.Pagination;
import java.util.List;
import java.util.Optional;

public interface PageRequest {
    public static PageRequest afterCursor(Cursor cursor, long page, int size, boolean withTotal) {
        return new Pagination(page, size, Mode.CURSOR_NEXT, cursor, withTotal);
    }

    public static PageRequest beforeCursor(Cursor cursor, long page, int size, boolean withTotal) {
        return new Pagination(page, size, Mode.CURSOR_PREVIOUS, cursor, withTotal);
    }

    public static PageRequest ofPage(long page) {
        return new Pagination(page, 10, Mode.OFFSET, null, true);
    }

    public static PageRequest ofPage(long page, int size, boolean withTotal) {
        return new Pagination(page, size, Mode.OFFSET, null, withTotal);
    }

    public static PageRequest ofSize(int size) {
        return new Pagination(1L, size, Mode.OFFSET, null, true);
    }

    public PageRequest afterCursor(Cursor var1);

    public PageRequest beforeCursor(Cursor var1);

    public Optional<Cursor> cursor();

    public Mode mode();

    public long page();

    public PageRequest page(long var1);

    public boolean requestTotal();

    public int size();

    public PageRequest size(int var1);

    public PageRequest withoutTotal();

    public PageRequest withTotal();

    public static enum Mode {
        CURSOR_NEXT,
        CURSOR_PREVIOUS,
        OFFSET;

    }

    public static interface Cursor {
        public static Cursor forKey(Object ... componentsOfKey) {
            return new PageRequestCursor(componentsOfKey);
        }

        public List<?> elements();

        public Object get(int var1);

        public int size();
    }
}

