/*
 * Decompiled with CFR 0.152.
 */
package jakarta.data.expression;

import jakarta.data.constraint.AtLeast;
import jakarta.data.constraint.AtMost;
import jakarta.data.constraint.Between;
import jakarta.data.constraint.GreaterThan;
import jakarta.data.constraint.LessThan;
import jakarta.data.constraint.NotBetween;
import jakarta.data.expression.Expression;
import jakarta.data.restrict.BasicRestriction;
import jakarta.data.restrict.Restriction;

public interface ComparableExpression<T, V extends Comparable<?>>
extends Expression<T, V> {
    default public <U extends ComparableExpression<? super T, V>> Restriction<T> between(U minExpression, U maxExpression) {
        Between<U> constraint = Between.bounds(minExpression, maxExpression);
        return BasicRestriction.of(this, constraint);
    }

    default public Restriction<T> between(V min, V max) {
        Between<V> constraint = Between.bounds(min, max);
        return BasicRestriction.of(this, constraint);
    }

    default public Restriction<T> greaterThan(ComparableExpression<? super T, V> expression) {
        GreaterThan<ComparableExpression<? super T, V>> constraint = GreaterThan.bound(expression);
        return BasicRestriction.of(this, constraint);
    }

    default public Restriction<T> greaterThan(V value) {
        GreaterThan<V> constraint = GreaterThan.bound(value);
        return BasicRestriction.of(this, constraint);
    }

    default public Restriction<T> greaterThanEqual(ComparableExpression<? super T, V> expression) {
        AtLeast<ComparableExpression<? super T, V>> constraint = AtLeast.min(expression);
        return BasicRestriction.of(this, constraint);
    }

    default public Restriction<T> greaterThanEqual(V value) {
        AtLeast<V> constraint = AtLeast.min(value);
        return BasicRestriction.of(this, constraint);
    }

    default public Restriction<T> lessThan(ComparableExpression<? super T, V> expression) {
        LessThan<ComparableExpression<? super T, V>> constraint = LessThan.bound(expression);
        return BasicRestriction.of(this, constraint);
    }

    default public Restriction<T> lessThan(V value) {
        LessThan<V> constraint = LessThan.bound(value);
        return BasicRestriction.of(this, constraint);
    }

    default public Restriction<T> lessThanEqual(ComparableExpression<? super T, V> expression) {
        AtMost<ComparableExpression<? super T, V>> constraint = AtMost.max(expression);
        return BasicRestriction.of(this, constraint);
    }

    default public Restriction<T> lessThanEqual(V value) {
        AtMost<V> constraint = AtMost.max(value);
        return BasicRestriction.of(this, constraint);
    }

    default public <U extends ComparableExpression<? super T, V>> Restriction<T> notBetween(U minExpression, U maxExpression) {
        NotBetween constraint = NotBetween.bounds(minExpression, maxExpression);
        return BasicRestriction.of(this, constraint);
    }

    default public Restriction<T> notBetween(V min, V max) {
        NotBetween<V> constraint = NotBetween.bounds(min, max);
        return BasicRestriction.of(this, constraint);
    }
}

