/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.saml.sso20.internal;

import com.ibm.websphere.crypto.PasswordUtil;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.common.crypto.CryptoUtils;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.authentication.filter.AuthenticationFilter;
import com.ibm.ws.security.common.config.CommonConfigUtils;
import com.ibm.ws.security.filemonitor.FileBasedActionable;
import com.ibm.ws.security.saml.Constants;
import com.ibm.ws.security.saml.SsoConfig;
import com.ibm.ws.security.saml.SsoSamlService;
import com.ibm.ws.security.saml.error.SamlException;
import com.ibm.ws.security.saml.sso20.internal.PkixTrustEngineConfig;
import com.ibm.ws.security.saml.sso20.internal.utils.FileInfo;
import com.ibm.ws.security.saml.sso20.internal.utils.MsgCtxUtil;
import com.ibm.ws.security.saml.sso20.internal.utils.SamlUtil;
import com.ibm.ws.security.saml.sso20.metadata.AcsDOMMetadataProvider;
import com.ibm.wsspi.kernel.service.location.WsLocationAdmin;
import com.ibm.wsspi.kernel.service.utils.ConcurrentServiceReferenceMap;
import com.ibm.wsspi.kernel.service.utils.SerializableProtectedString;
import java.io.File;
import java.io.IOException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.osgi.framework.BundleContext;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.ComponentContext;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class SsoConfigImpl
extends PkixTrustEngineConfig
implements SsoConfig,
FileBasedActionable {
    public static final TraceComponent tc = Tr.register(SsoConfigImpl.class, (String)"SAML20", (String)"com.ibm.ws.security.saml.sso20.internal.resources.SamlSso20Messages");
    public static final String KEY_ID = "id";
    public static final Object KEY_PROVIDER_ID = "id";
    public static final String KEY_SERVICE_PID = "service.pid";
    public static final String CFG_KEY_AUTH_FILTER_REF = "authFilterRef";
    public static final String KEY_clockSkew = "clockSkew";
    public static final String KEY_authnRequestTime = "authnRequestTime";
    private String providerId = null;
    private Map<String, Object> props = null;
    private volatile ConfigurationAdmin configAdmin = null;
    private HashMap<String, String> filterIdMap = null;
    static final String KEY_wantAssertionsSigned = "wantAssertionsSigned";
    static final String KEY_includeX509InSPMetadata = "includeX509InSPMetadata";
    static final String KEY_signatureMethodAlgorithm = "signatureMethodAlgorithm";
    static final String KEY_authnRequestsSigned = "authnRequestsSigned";
    static final String KEY_forceAuthn = "forceAuthn";
    static final String KEY_isPassive = "isPassive";
    static final String KEY_allowCreate = "allowCreate";
    static final String KEY_authnContextClassRef = "authnContextClassRef";
    static final String KEY_authnContextComparisonType = "authnContextComparisonType";
    static final String KEY_nameIDFormat = "nameIDFormat";
    static final String KEY_customizeNameIDFormat = "customizeNameIDFormat";
    static final String KEY_idpMetadata = "idpMetadata";
    static final String KEY_keyStoreRef = "keyStoreRef";
    static final String KEY_keyAlias = "keyAlias";
    static final String KEY_keyPassword = "keyPassword";
    static final String KEY_loginPageURL = "loginPageURL";
    static final String KEY_errorPageURL = "errorPageURL";
    static final String KEY_tokenReplayTimeout = "tokenReplayTimeout";
    static final String KEY_sessionNotOnOrAfter = "sessionNotOnOrAfter";
    static final String KEY_userIdentifier = "userIdentifier";
    static final String KEY_groupIdentifier = "groupIdentifier";
    static final String KEY_userUniqueIdentifier = "userUniqueIdentifier";
    static final String KEY_realmIdentifier = "realmIdentifier";
    static final String KEY_includeTokenInSubject = "includeTokenInSubject";
    static final String KEY_mapToUserRegistry = "mapToUserRegistry";
    static final String KEY_disableInitialRequestCookie = "disableInitialRequestCookie";
    static final String KEY_disableLtpaCookie = "disableLtpaCookie";
    static final String KEY_spCookieName = "spCookieName";
    static final String KEY_realmName = "realmName";
    static final String KEY_headerName = "headerName";
    static final String KEY_audiences = "audiences";
    static final String KEY_spHostAndPort = "spHostAndPort";
    static final String KEY_targetPageUrl = "targetPageUrl";
    static final String KEY_reAuthnOnAssertionExpire = "reAuthnOnAssertionExpire";
    static final String KEY_reAuthnCushion = "reAuthnCushion";
    static final String KEY_servletRequestLogoutPerformsSamlLogout = "spLogout";
    static final String KEY_enabled = "enabled";
    static final String KEY_httpsRequired = "httpsRequired";
    static final String KEY_allowCustomCacheKey = "allowCustomCacheKey";
    static final String KEY_createSession = "createSession";
    static final String KEY_useRelayStateForTarget = "useRelayStateForTarget";
    public static final String KEY_postLogoutRedirectUrl = "postLogoutRedirectUrl";
    static final String KEY_cspHeader = "contentSecurityPolicy";
    static final String[] notInUseAttributes = new String[]{"headerName", "audiences"};
    static final String ignoreAttributes;
    boolean bInit = false;
    boolean enabled = true;
    ComponentContext cc = null;
    SsoSamlService parentSsoService = null;
    long clockSkewMilliSeconds = 300000L;
    String keyStoreRef = null;
    String keyAlias = null;
    String keyPassword = null;
    String signatureMethodAlgorithm = "SHA256";
    String userIdentifier = "NameID";
    String groupIdentifier = null;
    String userUniqueIdentifier = "NameID";
    String realmIdentifier = "issuer";
    boolean includeTokenInSubject = true;
    boolean httpsRequired = true;
    boolean mapUserIdentifierToUserRegistry = false;
    boolean setLtpaCookie = false;
    boolean wantAssertionsSigned = true;
    String realmName = null;
    String headerName = null;
    ArrayList<String> headerNames = null;
    String[] audiences = new String[]{"ANY"};
    long authnRequestTimeMilliSeconds = 600000L;
    boolean authnRequestsSigned = true;
    boolean includeX509InSPMetadata = true;
    boolean forceAuthn = false;
    boolean isPassive = false;
    Boolean allowCreate = null;
    String[] authnContextClassRefs = null;
    String authnContextComparisonType = null;
    String nameIDFormat = null;
    String idpMetadata = null;
    AcsDOMMetadataProvider idpMetadataProvider = null;
    String loginPageURL = null;
    String errorPageURL = null;
    long tokenReplayTimeout = 1800000L;
    long sessionNotOnOrAfter = 0x6DDD00L;
    boolean allowCustomCacheKey = true;
    Constants.MapToUserRegistry mapToUserRegistry = Constants.MapToUserRegistry.No;
    boolean disableInitialRequestCookie = false;
    boolean disableLtpaCookie = true;
    String spCookieName = null;
    String spHostAndPort = null;
    String targetPageUrl = null;
    boolean bIdpMetadataProviderHandled = false;
    boolean createSession = true;
    boolean reAuthnOnAssertionExpire = false;
    long reAuthnCushion = 0L;
    private String bundleLocation;
    boolean useRelayStateForTarget = true;
    String postLogoutRedirectUrl = null;
    private boolean servletRequestLogoutPerformsSamlLogout = false;
    String cspHeader = null;
    static HashMap<String, String> nameIDFormatMap;
    CommonConfigUtils configUtils = new CommonConfigUtils();
    static final long serialVersionUID = 1877447611310445697L;

    public SsoConfigImpl() {
    }

    @Override
    public Constants.SamlSsoVersion getSamlVersion() {
        return Constants.SamlSsoVersion.SAMLSSO20;
    }

    public SsoConfigImpl(ComponentContext cc, Map<String, Object> props, ConfigurationAdmin configAdmin, HashMap<String, String> filterIdMap, SsoSamlService parentSsoService) {
        this.parentSsoService = parentSsoService;
        this.cc = cc;
        this.bundleLocation = cc.getBundleContext().getBundle().getLocation();
        try {
            this.setConfig(props, configAdmin, filterIdMap);
        }
        catch (SamlException samlException) {
            FFDCFilter.processException((Throwable)samlException, (String)"com.ibm.ws.security.saml.sso20.internal.SsoConfigImpl", (String)"221", (Object)this, (Object[])new Object[]{cc, props, configAdmin, filterIdMap, parentSsoService});
        }
    }

    public void setConfig(Map<String, Object> props, ConfigurationAdmin configAdmin, HashMap<String, String> filterIdMap) throws SamlException {
        this.bInit = true;
        this.providerId = (String)props.get(KEY_PROVIDER_ID);
        this.props = props;
        this.filterIdMap = filterIdMap;
        this.setConfigAdmin(configAdmin);
        this.processProps(props);
        if (this.providerId == null || this.providerId.isEmpty()) {
            Tr.error((TraceComponent)tc, (String)"SAML20_SP_ID_ATTRIBUTE_EMPTY", (Object[])new Object[0]);
        }
    }

    private void processProps(Map<String, Object> props) throws SamlException {
        Tr.warning((TraceComponent)tc, (String)"SAML_CONFIG_IGNORE_ATTRIBUTES", (Object[])new Object[]{"false", ignoreAttributes, this.providerId});
        this.clockSkewMilliSeconds = (Long)props.get(KEY_clockSkew);
        this.authnRequestTimeMilliSeconds = (Long)props.get(KEY_authnRequestTime);
        this.httpsRequired = (Boolean)props.get(KEY_httpsRequired);
        this.allowCustomCacheKey = (Boolean)props.get(KEY_allowCustomCacheKey);
        this.wantAssertionsSigned = (Boolean)props.get(KEY_wantAssertionsSigned);
        this.signatureMethodAlgorithm = this.trim((String)props.get(KEY_signatureMethodAlgorithm));
        if (CryptoUtils.isAlgorithmInsecure((String)this.signatureMethodAlgorithm)) {
            CryptoUtils.logInsecureAlgorithm((String)KEY_signatureMethodAlgorithm, (String)this.signatureMethodAlgorithm);
        }
        this.authnRequestsSigned = (Boolean)props.get(KEY_authnRequestsSigned);
        this.includeX509InSPMetadata = (Boolean)props.get(KEY_includeX509InSPMetadata);
        this.forceAuthn = (Boolean)props.get(KEY_forceAuthn);
        this.isPassive = (Boolean)props.get(KEY_isPassive);
        this.allowCreate = (Boolean)props.get(KEY_allowCreate);
        this.authnContextClassRefs = this.trim((String[])props.get(KEY_authnContextClassRef));
        this.authnContextComparisonType = this.trim((String)props.get(KEY_authnContextComparisonType));
        this.nameIDFormat = this.processNameIDFormat(props, (String)props.get(KEY_nameIDFormat));
        this.idpMetadata = this.trim((String)props.get(KEY_idpMetadata));
        this.idpMetadataProvider = null;
        this.keyStoreRef = this.trim((String)props.get(KEY_keyStoreRef));
        this.keyAlias = this.trim((String)props.get(KEY_keyAlias));
        this.keyPassword = this.getPassword((SerializableProtectedString)props.get(KEY_keyPassword));
        this.loginPageURL = this.trim((String)props.get(KEY_loginPageURL));
        this.errorPageURL = this.trim((String)props.get(KEY_errorPageURL));
        this.tokenReplayTimeout = (Long)props.get(KEY_tokenReplayTimeout);
        this.sessionNotOnOrAfter = (Long)props.get(KEY_sessionNotOnOrAfter);
        this.userIdentifier = this.trim((String)props.get(KEY_userIdentifier));
        this.groupIdentifier = this.trim((String)props.get(KEY_groupIdentifier));
        this.userUniqueIdentifier = this.trim((String)props.get(KEY_userUniqueIdentifier));
        if (this.userUniqueIdentifier == null || this.userUniqueIdentifier.isEmpty()) {
            this.userUniqueIdentifier = this.userIdentifier;
        }
        this.realmIdentifier = this.trim((String)props.get(KEY_realmIdentifier));
        this.includeTokenInSubject = (Boolean)props.get(KEY_includeTokenInSubject);
        this.mapToUserRegistry = Constants.MapToUserRegistry.valueOf((String)props.get(KEY_mapToUserRegistry));
        this.disableInitialRequestCookie = (Boolean)props.get(KEY_disableInitialRequestCookie);
        this.disableLtpaCookie = (Boolean)props.get(KEY_disableLtpaCookie);
        this.spCookieName = this.trim((String)props.get(KEY_spCookieName));
        this.realmName = this.trim((String)props.get(KEY_realmName));
        this.spHostAndPort = this.trim((String)props.get(KEY_spHostAndPort));
        this.targetPageUrl = this.trim((String)props.get(KEY_targetPageUrl));
        this.enabled = (Boolean)props.get(KEY_enabled);
        if (props.get(KEY_createSession) != null) {
            this.createSession = (Boolean)props.get(KEY_createSession);
        }
        this.reAuthnOnAssertionExpire = (Boolean)props.get(KEY_reAuthnOnAssertionExpire);
        this.reAuthnCushion = (Long)props.get(KEY_reAuthnCushion);
        this.useRelayStateForTarget = (Boolean)props.get(KEY_useRelayStateForTarget);
        this.postLogoutRedirectUrl = this.configUtils.getConfigAttribute(props, KEY_postLogoutRedirectUrl);
        this.servletRequestLogoutPerformsSamlLogout = (Boolean)props.get(KEY_servletRequestLogoutPerformsSamlLogout);
        this.cspHeader = (String)props.get(KEY_cspHeader);
        this.processPkixTrustEngine(props);
    }

    /*
     * WARNING - void declaration
     */
    private void processPkixTrustEngine(Map<String, Object> props) throws SamlException {
        try {
            super.processPkixTrustEngine(props, this.configAdmin, this.bundleLocation);
        }
        catch (Exception exception) {
            void e;
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.saml.sso20.internal.SsoConfigImpl", (String)"311", (Object)this, (Object[])new Object[]{props});
            throw new SamlException((Exception)e);
        }
    }

    String processNameIDFormat(Map<String, Object> props, String shortNameIDFormat) {
        String result = null;
        if (shortNameIDFormat == null || shortNameIDFormat.isEmpty()) {
            return "urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress";
        }
        result = shortNameIDFormat.equals("customize") ? (String)props.get(KEY_customizeNameIDFormat) : nameIDFormatMap.get(shortNameIDFormat);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(this.providerId + "> NameIDFormat:" + result + " id:" + shortNameIDFormat), (Object[])new Object[0]);
        }
        return result;
    }

    @Override
    public void setConfigAdmin(ConfigurationAdmin configAdmin) {
        this.configAdmin = configAdmin;
        if (this.props != null && tc.isDebugEnabled()) {
            String authFilterRef = (String)this.props.get(CFG_KEY_AUTH_FILTER_REF);
            Tr.debug((TraceComponent)tc, (String)(this.providerId + "> saml AuthenticationFilter Ref:" + authFilterRef + " id:" + this.getAuthFilterId(authFilterRef)), (Object[])new Object[0]);
        }
    }

    @Override
    public String getProviderId() {
        return this.providerId;
    }

    @Override
    public AuthenticationFilter getAuthFilter(ConcurrentServiceReferenceMap<String, AuthenticationFilter> authFilterServiceRef) {
        String authFilterRef;
        if (this.props != null && (authFilterRef = (String)this.props.get(CFG_KEY_AUTH_FILTER_REF)) != null && !authFilterRef.isEmpty()) {
            AuthenticationFilter authnFilter;
            if (tc.isDebugEnabled()) {
                String id = this.getAuthFilterId(authFilterRef);
                Tr.debug((TraceComponent)tc, (String)(this.providerId + "> Ref:" + authFilterRef + " id:" + id), (Object[])new Object[0]);
            }
            if ((authnFilter = (AuthenticationFilter)authFilterServiceRef.getService((Object)authFilterRef)) == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("AuthnFilter Ref:" + authFilterRef + " points to no AuthnFilter, we accept all the requests"), (Object[])new Object[0]);
                }
                Tr.error((TraceComponent)tc, (String)"SAML20_AUTH_FILTER_NOT_EXISTING", (Object[])new Object[]{this.getAuthFilterId(authFilterRef), this.providerId});
            }
            return authnFilter;
        }
        return null;
    }

    @Override
    public String getAuthFilterId() {
        if (this.props != null) {
            String authFilterRef = (String)this.props.get(CFG_KEY_AUTH_FILTER_REF);
            return this.getAuthFilterId(authFilterRef);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public String getAuthFilterId(String authFilterRef) {
        if (authFilterRef == null || authFilterRef.isEmpty()) {
            return null;
        }
        String id = this.filterIdMap.get(authFilterRef);
        if (id != null) {
            return id;
        }
        Configuration config = null;
        try {
            if (this.configAdmin != null) {
                config = this.configAdmin.getConfiguration(authFilterRef, null);
            }
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.security.saml.sso20.internal.SsoConfigImpl", (String)"404", (Object)this, (Object[])new Object[]{authFilterRef});
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                void e;
                Tr.debug((TraceComponent)tc, (String)"Invalid authFilterRef configuration", (Object[])new Object[]{e.getMessage()});
            }
            return null;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"authFilterRef configuration", (Object[])new Object[]{config});
        }
        if (config == null) {
            return null;
        }
        Dictionary props = config.getProperties();
        if (props == null) {
            return null;
        }
        id = (String)props.get(KEY_ID);
        return id;
    }

    @Override
    public long getClockSkew() {
        return this.clockSkewMilliSeconds;
    }

    @Override
    public boolean isWantAssertionsSigned() {
        return this.wantAssertionsSigned;
    }

    @Override
    public boolean isAuthnRequestsSigned() {
        return this.authnRequestsSigned;
    }

    @Override
    public boolean isForceAuthn() {
        return this.forceAuthn;
    }

    @Override
    public boolean isPassive() {
        return this.isPassive;
    }

    @Override
    public String[] getAuthnContextClassRef() {
        return this.authnContextClassRefs == null ? null : (String[])this.authnContextClassRefs.clone();
    }

    @Override
    public String getNameIDFormat() {
        return this.nameIDFormat;
    }

    @Override
    public String getIdpMetadata() {
        return this.idpMetadata;
    }

    @Override
    public String getKeyStoreRef() {
        return this.keyStoreRef;
    }

    @Override
    public String getKeyAlias() {
        return this.keyAlias;
    }

    @Override
    @Sensitive
    public String getKeyPassword() {
        return this.keyPassword;
    }

    @Override
    public String getLoginPageURL() {
        return this.loginPageURL;
    }

    @Override
    public String getErrorPageURL() {
        return this.errorPageURL;
    }

    @Override
    public long getTokenReplayTimeout() {
        return this.tokenReplayTimeout;
    }

    @Override
    public long getSessionNotOnOrAfter() {
        return this.sessionNotOnOrAfter;
    }

    @Override
    public String getUserIdentifier() {
        return this.userIdentifier;
    }

    @Override
    public String getGroupIdentifier() {
        return this.groupIdentifier;
    }

    @Override
    public String getUserUniqueIdentifier() {
        return this.userUniqueIdentifier;
    }

    @Override
    public String getRealmIdentifier() {
        return this.realmIdentifier;
    }

    @Override
    public boolean isIncludeTokenInSubject() {
        return this.includeTokenInSubject;
    }

    @Override
    public Constants.MapToUserRegistry getMapToUserRegistry() {
        return this.mapToUserRegistry;
    }

    @Override
    public String toString() {
        String result = "notInitialized yet";
        if (this.bInit) {
            result = "\nproviderId:" + this.providerId + "\nwantAssertionsSigned:" + this.wantAssertionsSigned + "\nsignatureMethodAlgorithm:" + this.signatureMethodAlgorithm + "\nauthnRequestsSigned:" + this.authnRequestsSigned + "\nforceAuthn:" + this.forceAuthn + "\ncreateSession:" + this.createSession + "\nisPassive:" + this.isPassive + "\nallowCreate:" + this.allowCreate + "\nauthnContextComparisonType:" + this.authnContextComparisonType + "\nnameIDFormat:" + this.nameIDFormat + "\nidpMetadata:" + this.idpMetadata + "\nkeyStoreRef:" + this.keyStoreRef + "\nkeyAlias:" + this.keyAlias + "\nkeyPassword:" + (this.keyPassword == null ? "null" : "*****") + "\nloginPageURL:" + this.loginPageURL + "\nerrorPageURL:" + this.errorPageURL + "\ntokenReplayTimeout:" + this.tokenReplayTimeout + "\nuserIdentifier:" + this.userIdentifier + "\ngroupIdentifier:" + this.groupIdentifier + "\nuserUniqueIdentifier:" + this.userUniqueIdentifier + "\nrealmIdentifier:" + this.realmIdentifier + "\nincludeTokenInSubject:" + this.includeTokenInSubject + "\nmapToUserRegistry:" + (Object)((Object)this.mapToUserRegistry) + "\ndisableInitialRequestCookie:" + this.disableInitialRequestCookie + "\ndisableLtpaCookie:" + this.disableLtpaCookie + "\nspCookieName:" + this.spCookieName + "\nrealmName:" + this.realmName + "\nspHostAndPort:" + this.spHostAndPort + "\ntargetPageUrl:" + this.targetPageUrl + "\nuseRelayStateForTarget:" + this.useRelayStateForTarget + "\ntrustedIssuers:" + (this.trustedIssuers == null ? "null" : Integer.valueOf(this.trustedIssuers.length)) + "\nenabled:" + this.enabled + "\nincludeX509InSPMetadata:" + this.includeX509InSPMetadata + (!this.isPkixTrustEngineEnabled ? ";" : "\npkixTrustEngine enabled\nx509 cert list:" + this.pkixX509List.toString() + "\ncrl list:" + this.pkixCrlList.toString()) + "\npostLogoutRedirectUrl:" + this.postLogoutRedirectUrl + "\nservletRequestLogoutPerformsSamlLogout: " + this.servletRequestLogoutPerformsSamlLogout + "\ncspHeader: " + this.cspHeader;
        }
        return result;
    }

    @Override
    public String getSignatureMethodAlgorithm() {
        if ("SHA256".equalsIgnoreCase(this.signatureMethodAlgorithm)) {
            return "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256";
        }
        if ("SHA1".equalsIgnoreCase(this.signatureMethodAlgorithm)) {
            return "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
        }
        if ("SHA384".equalsIgnoreCase(this.signatureMethodAlgorithm)) {
            return "http://www.w3.org/2001/04/xmldsig-more#rsa-sha384";
        }
        if ("SHA512".equalsIgnoreCase(this.signatureMethodAlgorithm)) {
            return "http://www.w3.org/2001/04/xmldsig-more#rsa-sha512";
        }
        if ("ECDSAwithSHA256".equalsIgnoreCase(this.signatureMethodAlgorithm)) {
            return "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha256";
        }
        if ("ECDSAwithSHA384".equalsIgnoreCase(this.signatureMethodAlgorithm)) {
            return "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha384";
        }
        if ("ECDSAwithSHA512".equalsIgnoreCase(this.signatureMethodAlgorithm)) {
            return "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha512";
        }
        return "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256";
    }

    @Override
    public AcsDOMMetadataProvider getIdpMetadataProvider() {
        block3: {
            try {
                if (!this.bIdpMetadataProviderHandled) {
                    this.idpMetadataProvider = MsgCtxUtil.parseIdpMetadataProvider(this);
                    this.bIdpMetadataProviderHandled = true;
                }
            }
            catch (SamlException samlException) {
                FFDCFilter.processException((Throwable)samlException, (String)"com.ibm.ws.security.saml.sso20.internal.SsoConfigImpl", (String)"624", (Object)this, (Object[])new Object[0]);
                if (!tc.isDebugEnabled()) break block3;
                Tr.debug((TraceComponent)tc, (String)("Can not parse MetadataFile:" + this.idpMetadata), (Object[])new Object[0]);
            }
        }
        return this.idpMetadataProvider;
    }

    public void performFileBasedAction(Collection<File> files) {
        this.idpMetadataProvider = null;
        this.bIdpMetadataProviderHandled = false;
        Tr.info((TraceComponent)tc, (String)"SAML20_IDP_METADATA_FILE_CHANGED", (Object[])new Object[]{this.idpMetadata, this.providerId});
    }

    public BundleContext getBundleContext() {
        if (this.cc != null) {
            return this.cc.getBundleContext();
        }
        return null;
    }

    @Override
    public Boolean getAllowCreate() {
        return this.allowCreate;
    }

    @Override
    public String getAuthnContextComparisonType() {
        return this.authnContextComparisonType;
    }

    @Override
    public boolean isDisableLtpaCookie() {
        return this.disableLtpaCookie;
    }

    @Override
    public String getSpCookieName(WsLocationAdmin locationAdmin) {
        if (this.spCookieName == null || this.spCookieName.isEmpty()) {
            String cookieLongName = "";
            if (locationAdmin != null) {
                String usrLocation = locationAdmin.resolveString("${wlp.user.dir}").replace('\\', '/');
                String slash = usrLocation.endsWith("/") ? "" : "/";
                cookieLongName = FileInfo.getHostName() + "_" + usrLocation + slash + "servers/" + locationAdmin.getServerName() + "/" + this.providerId;
            } else {
                Tr.error((TraceComponent)tc, (String)"OSGI_SERVICE_ERROR", (Object[])new Object[]{"WsLocationAdmin"});
                cookieLongName = this.providerId;
            }
            this.spCookieName = "WASSamlSP_" + SamlUtil.hash(cookieLongName);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("cookieHashName: " + this.spCookieName + " cookieLongName: " + cookieLongName), (Object[])new Object[0]);
            }
        }
        return this.spCookieName;
    }

    @Override
    public List<String> getPkixX509CertificateList() {
        return this.pkixX509List;
    }

    @Override
    public List<String> getPkixCrlList() {
        return this.pkixCrlList;
    }

    @Override
    public Collection<X509Certificate> getPkixTrustAnchors() {
        ArrayList<X509Certificate> pkixTrustAnchors = new ArrayList<X509Certificate>();
        try {
            this.parentSsoService.searchTrustAnchors(pkixTrustAnchors, this.trustAnchorName);
            this.addX509Certs(pkixTrustAnchors);
        }
        catch (SamlException samlException) {
            FFDCFilter.processException((Throwable)samlException, (String)"com.ibm.ws.security.saml.sso20.internal.SsoConfigImpl", (String)"747", (Object)this, (Object[])new Object[0]);
        }
        return pkixTrustAnchors;
    }

    @Override
    public boolean isPkixTrustEngineEnabled() {
        return this.isPkixTrustEngineEnabled;
    }

    @Sensitive
    String getPassword(SerializableProtectedString keyPassword) {
        if (keyPassword == null || keyPassword.isEmpty()) {
            return null;
        }
        String encoded_string = new String(keyPassword.getChars());
        return PasswordUtil.passwordDecode((String)encoded_string);
    }

    @Override
    public long getAuthnRequestTime() {
        return this.authnRequestTimeMilliSeconds;
    }

    @Override
    public String[] getPkixTrustedIssuers() {
        return this.trustedIssuers == null ? null : (String[])this.trustedIssuers.clone();
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public String getRealmName() {
        return this.realmName;
    }

    @Override
    public String getSpHostAndPort() {
        return this.spHostAndPort;
    }

    @Override
    public boolean isHttpsRequired() {
        return this.httpsRequired;
    }

    @Override
    public boolean isAllowCustomCacheKey() {
        if (this.disableLtpaCookie) {
            return true;
        }
        return this.allowCustomCacheKey;
    }

    @Override
    public boolean createSession() {
        return this.createSession;
    }

    @Override
    public String getHeaderName() {
        return this.unexpectedCall("Saml,saml,SAML");
    }

    @Override
    public ArrayList<String> getHeaderNames() {
        ArrayList<String> defaultHeaderNames = new ArrayList<String>();
        defaultHeaderNames.add("Saml");
        defaultHeaderNames.add("saml");
        defaultHeaderNames.add("SAML");
        return this.unexpectedCall(defaultHeaderNames);
    }

    @Override
    public String[] getAudiences() {
        return this.unexpectedCall(new String[]{"ANY"});
    }

    @Override
    public boolean isReAuthnOnAssertionExpire() {
        return this.reAuthnOnAssertionExpire;
    }

    @Override
    public long getReAuthnCushion() {
        return this.reAuthnCushion;
    }

    @Override
    public String getTargetPageUrl() {
        return this.targetPageUrl;
    }

    @Override
    public boolean isIncludeX509InSPMetadata() {
        return this.includeX509InSPMetadata;
    }

    @Override
    public boolean getUseRelayStateForTarget() {
        return this.useRelayStateForTarget;
    }

    @Override
    public String getPostLogoutRedirectUrl() {
        return this.postLogoutRedirectUrl;
    }

    @Override
    public boolean isServletRequestLogoutPerformsSamlLogout() {
        return this.servletRequestLogoutPerformsSamlLogout;
    }

    @Override
    public boolean isDisableInitialRequestCookie() {
        return this.disableInitialRequestCookie;
    }

    public void performFileBasedAction(Collection<File> createdFiles, Collection<File> modifiedFiles, Collection<File> deletedFiles) {
    }

    @Override
    public String getCspHeader() {
        if (this.cspHeader != null && this.cspHeader.length() == 0) {
            return null;
        }
        return this.cspHeader;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        String tmpStr = notInUseAttributes[0];
        for (int iI = 1; iI < notInUseAttributes.length; ++iI) {
            tmpStr = tmpStr.concat(", ").concat(notInUseAttributes[iI]);
        }
        ignoreAttributes = tmpStr;
        nameIDFormatMap = new HashMap();
        nameIDFormatMap.put("unspecified", "urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified");
        nameIDFormatMap.put("email", "urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress");
        nameIDFormatMap.put("x509SubjectName", "urn:oasis:names:tc:SAML:1.1:nameid-format:X509SubjectName");
        nameIDFormatMap.put("windowsDomainQualifiedName", "urn:oasis:names:tc:SAML:1.1:nameid-format:WindowsDomainQualifiedName");
        nameIDFormatMap.put("kerberos", "urn:oasis:names:tc:SAML:2.0:nameid-format:kerberos");
        nameIDFormatMap.put("entity", "urn:oasis:names:tc:SAML:2.0:nameid-format:entity");
        nameIDFormatMap.put("persistent", "urn:oasis:names:tc:SAML:2.0:nameid-format:persistent");
        nameIDFormatMap.put("transient", "urn:oasis:names:tc:SAML:2.0:nameid-format:transient");
        nameIDFormatMap.put("encrypted", "urn:oasis:names:tc:SAML:2.0:nameid-format:encrypted");
    }
}

