/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.api.jmsra.impl;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.api.jmsra.impl.JmsJcaConnectionRequestInfo;
import com.ibm.ws.sib.api.jmsra.impl.JmsJcaManagedConnectionFactoryImpl;
import com.ibm.ws.sib.api.jmsra.impl.JmsJcaSessionImpl;
import com.ibm.ws.sib.api.jmsra.impl.JmsJcaUserDetails;
import com.ibm.ws.sib.ra.SibRaEngineComponent;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.ConsumerSession;
import com.ibm.wsspi.sib.core.SICoreConnection;
import com.ibm.wsspi.sib.core.SICoreConnectionListener;
import com.ibm.wsspi.sib.core.SITransaction;
import com.ibm.wsspi.sib.core.SIUncoordinatedTransaction;
import com.ibm.wsspi.sib.core.SIXAResource;
import com.ibm.wsspi.sib.core.exception.SIConnectionDroppedException;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;
import com.ibm.wsspi.sib.core.exception.SIConnectionUnavailableException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEvent;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.DissociatableManagedConnection;
import javax.resource.spi.LazyEnlistableConnectionManager;
import javax.resource.spi.LazyEnlistableManagedConnection;
import javax.resource.spi.LocalTransaction;
import javax.resource.spi.LocalTransactionException;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionMetaData;
import javax.resource.spi.ResourceAdapterInternalException;
import javax.security.auth.Subject;
import javax.transaction.xa.XAResource;

public class JmsJcaManagedConnection
implements ManagedConnection,
LazyEnlistableManagedConnection,
DissociatableManagedConnection {
    private final JmsJcaManagedConnectionFactoryImpl _managedConnectionFactory;
    protected final SICoreConnection _coreConnection;
    protected final JmsJcaConnectionListener _connectionListener;
    private final JmsJcaUserDetails _userDetails;
    private final Subject _subject;
    private final Set<JmsJcaSessionImpl> _sessions = Collections.synchronizedSet(new HashSet());
    private final List<ConnectionEventListener> _connectionListeners = new ArrayList<ConnectionEventListener>();
    private JmsJcaLocalTransaction _localTransaction;
    private SIXAResource _xaResource;
    private JmsJcaManagedConnectionMetaData _metaData;
    private boolean _validConnection = true;
    private PrintWriter _logWriter;
    private static TraceComponent TRACE = SibTr.register(JmsJcaManagedConnection.class, (String)"SIBJmsRa", (String)"com.ibm.ws.sib.api.jmsra.CWSJRMessages");
    private static TraceComponent LOCAL_TRANSACTION_TRACE = SibTr.register(JmsJcaLocalTransaction.class, (String)"SIBJmsRa", (String)"com.ibm.ws.sib.api.jmsra.CWSJRMessages");
    private static TraceComponent LISTENER_TRACE = SibTr.register(JmsJcaConnectionListener.class, (String)"SIBJmsRa", (String)"com.ibm.ws.sib.api.jmsra.CWSJRMessages");
    private static TraceNLS NLS = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.api.jmsra.CWSJRMessages");
    private static final String CLASS_NAME = JmsJcaManagedConnection.class.getName();

    JmsJcaManagedConnection(JmsJcaManagedConnectionFactoryImpl managedConnectionFactory, SICoreConnection coreConnection, JmsJcaUserDetails userDetails, Subject subject) throws SIConnectionDroppedException, SIConnectionUnavailableException {
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"JmsJcaManagedConnection", (Object)new Object[]{managedConnectionFactory, coreConnection, userDetails, JmsJcaManagedConnection.subjectToString(subject)});
        }
        this._managedConnectionFactory = managedConnectionFactory;
        this._coreConnection = coreConnection;
        this._userDetails = userDetails;
        this._subject = subject;
        this._connectionListener = new JmsJcaConnectionListener();
        this._coreConnection.addConnectionListener((SICoreConnectionListener)this._connectionListener);
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"JmsJcaManagedConnection");
        }
    }

    public final Object getConnection(Subject requestSubject, ConnectionRequestInfo requestInfo) throws ResourceException {
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"getConnection", (Object)new Object[]{JmsJcaManagedConnection.subjectToString(requestSubject), requestInfo});
        }
        JmsJcaUserDetails requestUserDetails = this._managedConnectionFactory.getUserDetails(requestSubject, requestInfo);
        if (this._userDetails != null) {
            if (!this._userDetails.equals(requestUserDetails)) {
                throw new ResourceException(NLS.getFormattedMessage("AUTHENTICATION_ERROR_CWSJR1103", new Object[]{"JmsJcaManagedConnection.getConnection", this._userDetails.getUserName(), requestUserDetails == null ? null : requestUserDetails.getUserName()}, null));
            }
        } else if (!this._subject.equals(requestSubject)) {
            throw new ResourceException(NLS.getFormattedMessage("AUTHENTICATION_ERROR_CWSJR1117", new Object[]{"JmsJcaManagedConnection.getConnection"}, null));
        }
        JmsJcaSessionImpl session = null;
        if (requestInfo != null && !(requestInfo instanceof JmsJcaConnectionRequestInfo)) {
            throw new ResourceAdapterInternalException(NLS.getFormattedMessage("EXCEPTION_RECEIVED_CWSJR1101", new Object[]{"getConnection", JmsJcaConnectionRequestInfo.class.getName(), requestInfo.getClass().getName()}, null));
        }
        session = new JmsJcaSessionImpl(this, (JmsJcaConnectionRequestInfo)requestInfo);
        this._sessions.add(session);
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"getConnection", (Object)session);
        }
        return session;
    }

    public final void destroy() throws ResourceException {
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"destroy");
        }
        for (JmsJcaSessionImpl object : this._sessions) {
            if (!(object instanceof JmsJcaSessionImpl)) continue;
            JmsJcaSessionImpl session = object;
            session.invalidate();
        }
        this._sessions.clear();
        try {
            this._coreConnection.removeConnectionListener((SICoreConnectionListener)this._connectionListener);
            this._coreConnection.close(true);
        }
        catch (SIConnectionLostException iterator) {
        }
        catch (SIConnectionDroppedException iterator) {
        }
        catch (SIException exception) {
            FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + "destroy"), (String)"1:408:1.91", (Object)this);
            throw new ResourceException(NLS.getFormattedMessage("EXCEPTION_RECEIVED_CWSJR1110", new Object[]{exception, "createManagedConnection"}, null), (Throwable)exception);
        }
        catch (SIErrorException exception) {
            FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + "destroy"), (String)"1:416:1.91", (Object)this);
            throw new ResourceException(NLS.getFormattedMessage("EXCEPTION_RECEIVED_CWSJR1110", new Object[]{exception, "createManagedConnection"}, null), (Throwable)exception);
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"destroy");
        }
    }

    public final void cleanup() throws ResourceException {
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"cleanup");
        }
        for (JmsJcaSessionImpl object : this._sessions) {
            if (!(object instanceof JmsJcaSessionImpl)) continue;
            object.invalidate();
        }
        this._sessions.clear();
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"cleanup");
        }
    }

    public final void associateConnection(Object object) throws ResourceException {
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"associateConnection", (Object)object);
        }
        if (!(object instanceof JmsJcaSessionImpl)) {
            throw new ResourceAdapterInternalException(NLS.getFormattedMessage("INVALID_SESSION_CWSJR1104", new Object[]{"associateConnection", JmsJcaSessionImpl.class.getName(), object == null ? "null" : object.getClass().getName()}, null));
        }
        JmsJcaSessionImpl session = (JmsJcaSessionImpl)object;
        session.associate(this);
        this._sessions.add(session);
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"associateConnection");
        }
    }

    final void disassociateSession(JmsJcaSessionImpl session) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"disassociateSession", (Object)session);
        }
        this._sessions.remove(session);
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"disassociateSession");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addConnectionEventListener(ConnectionEventListener listener) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"addConnectionEventListener", (Object)listener);
        }
        List<ConnectionEventListener> list = this._connectionListeners;
        synchronized (list) {
            this._connectionListeners.add(listener);
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"addConnectionEventListener");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeConnectionEventListener(ConnectionEventListener listener) {
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"removeConnectionEventListener", (Object)listener);
        }
        List<ConnectionEventListener> list = this._connectionListeners;
        synchronized (list) {
            this._connectionListeners.remove(listener);
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"removeConnectionEventListener");
        }
    }

    public final XAResource getXAResource() throws ResourceException {
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"getXAResource");
        }
        if (this._coreConnection == null) {
            throw new ResourceAdapterInternalException(NLS.getFormattedMessage("EXCEPTION_RECEIVED_CWSJR1106", new Object[]{"getXAResource"}, null));
        }
        if (this._xaResource == null) {
            try {
                this._xaResource = this._coreConnection.getSIXAResource();
            }
            catch (SIException exception) {
                FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + "getXAResource"), (String)"1:649:1.91", (Object)this);
                throw new ResourceException(NLS.getFormattedMessage("EXCEPTION_RECEIVED_CWSJR1111", new Object[]{exception, "getXAResource"}, null), (Throwable)exception);
            }
            catch (SIErrorException exception) {
                FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + "getXAResource"), (String)"1:658:1.91", (Object)this);
                throw new ResourceException(NLS.getFormattedMessage("EXCEPTION_RECEIVED_CWSJR1111", new Object[]{exception, "getXAResource"}, null), (Throwable)exception);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"getXAResource", (Object)this._xaResource);
        }
        return this._xaResource;
    }

    public final LocalTransaction getLocalTransaction() throws ResourceException {
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"getLocalTransaction");
        }
        if (this._coreConnection == null) {
            throw new ResourceAdapterInternalException(NLS.getFormattedMessage("EXCEPTION_RECEIVED_CWSJR1107", new Object[]{"getLocalTransaction"}, null));
        }
        if (this._localTransaction == null) {
            this._localTransaction = new JmsJcaLocalTransaction();
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"getLocalTransaction", (Object)this._localTransaction);
        }
        return this._localTransaction;
    }

    public final ManagedConnectionMetaData getMetaData() throws ResourceException {
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"getMetaData");
        }
        if (this._metaData == null) {
            this._metaData = new JmsJcaManagedConnectionMetaData();
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"getMetaData", (Object)this._metaData);
        }
        return this._metaData;
    }

    public final void setLogWriter(PrintWriter logWriter) throws ResourceException {
        this._logWriter = logWriter;
    }

    public final PrintWriter getLogWriter() throws ResourceException {
        if (this._logWriter == null) {
            return this._managedConnectionFactory.getLogWriter();
        }
        return this._logWriter;
    }

    public final void dissociateConnections() throws ResourceException {
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((TraceComponent)TRACE, (String)"dissociateConnections");
        }
        Iterator<JmsJcaSessionImpl> iterator = this._sessions.iterator();
        while (iterator.hasNext()) {
            JmsJcaSessionImpl object = iterator.next();
            if (!(object instanceof JmsJcaSessionImpl)) continue;
            object.dissociate();
            iterator.remove();
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"dissociateConnections");
        }
    }

    final SITransaction getCurrentTransaction(ConnectionManager connectionManager) throws ResourceException {
        SITransaction currentTransaction;
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"getCurrentTransaction", (Object)connectionManager);
        }
        if ((currentTransaction = this.getActiveTransaction()) == null && connectionManager instanceof LazyEnlistableConnectionManager) {
            if (TraceComponent.isAnyTracingEnabled() && TRACE.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)TRACE, (String)"Lazy enlisting on the connection manager");
            }
            try {
                ((LazyEnlistableConnectionManager)connectionManager).lazyEnlist((ManagedConnection)this);
            }
            catch (ResourceException exception) {
                FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + "getCurrentTransaction"), (String)"1:837:1.91", (Object)this);
                SibTr.error((TraceComponent)TRACE, (String)"EXCEPTION_RECEIVED_CWSJR1102", (Object)((Object)exception));
                throw exception;
            }
            currentTransaction = this.getActiveTransaction();
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"getCurrentTransaction", (Object)currentTransaction);
        }
        return currentTransaction;
    }

    protected SITransaction getActiveTransaction() {
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"getActiveTransaction");
        }
        SIXAResource activeTransaction = null;
        if (this._xaResource != null && this._xaResource.isEnlisted()) {
            if (TraceComponent.isAnyTracingEnabled() && TRACE.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)TRACE, (String)"Current transaction is an XA global transaction");
            }
            activeTransaction = this._xaResource;
        } else if (this._localTransaction != null && this._localTransaction.getLocalSITransaction() != null) {
            if (TraceComponent.isAnyTracingEnabled() && TRACE.isDebugEnabled()) {
                SibTr.debug((TraceComponent)TRACE, (String)"Current transaction is a container-managed local transaction");
            }
            activeTransaction = this._localTransaction.getLocalSITransaction();
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"getActiveTransaction", (Object)activeTransaction);
        }
        return activeTransaction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void localTransactionStarted() {
        ArrayList<ConnectionEventListener> copy;
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"localTransactionStarted");
        }
        ConnectionEvent event = new ConnectionEvent((ManagedConnection)this, 2);
        List<ConnectionEventListener> list = this._connectionListeners;
        synchronized (list) {
            copy = new ArrayList<ConnectionEventListener>(this._connectionListeners);
        }
        for (Object e : copy) {
            if (!(e instanceof ConnectionEventListener)) continue;
            ((ConnectionEventListener)e).localTransactionStarted(event);
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"localTransactionStarted");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void localTransactionCommitted() {
        ArrayList<ConnectionEventListener> copy;
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"localTransactionCommited");
        }
        ConnectionEvent event = new ConnectionEvent((ManagedConnection)this, 3);
        List<ConnectionEventListener> list = this._connectionListeners;
        synchronized (list) {
            copy = new ArrayList<ConnectionEventListener>(this._connectionListeners);
        }
        for (Object e : copy) {
            if (!(e instanceof ConnectionEventListener)) continue;
            ((ConnectionEventListener)e).localTransactionCommitted(event);
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"localTransactionCommitted");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void localTransactionRolledBack() {
        ArrayList<ConnectionEventListener> copy;
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"localTransactionRolledBack");
        }
        ConnectionEvent event = new ConnectionEvent((ManagedConnection)this, 4);
        List<ConnectionEventListener> list = this._connectionListeners;
        synchronized (list) {
            copy = new ArrayList<ConnectionEventListener>(this._connectionListeners);
        }
        for (Object e : copy) {
            if (!(e instanceof ConnectionEventListener)) continue;
            ((ConnectionEventListener)e).localTransactionRolledback(event);
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"localTransactionRolledBack");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void sessionClosed(JmsJcaSessionImpl session) {
        ArrayList<ConnectionEventListener> copy;
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"sessionClosed", (Object)session);
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)TRACE, (String)("Sending connection closed events to the " + this._connectionListeners.size() + " listeners"));
        }
        ConnectionEvent event = new ConnectionEvent((ManagedConnection)this, 1);
        event.setConnectionHandle((Object)session);
        List<ConnectionEventListener> list = this._connectionListeners;
        synchronized (list) {
            copy = new ArrayList<ConnectionEventListener>(this._connectionListeners);
        }
        for (Object e : copy) {
            if (!(e instanceof ConnectionEventListener)) continue;
            ((ConnectionEventListener)e).connectionClosed(event);
        }
        this._sessions.remove(session);
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"sessionClosed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void connectionErrorOccurred(Exception exception, boolean callJCAListener) {
        String methodName = "connectionErrorOccurred";
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"connectionErrorOccurred", (Object)new Object[]{exception, callJCAListener});
        }
        if (!SibRaEngineComponent.isServerStopping()) {
            ArrayList<ConnectionEventListener> copy;
            ConnectionEvent event = new ConnectionEvent((ManagedConnection)this, 5, exception);
            List<ConnectionEventListener> list = this._connectionListeners;
            synchronized (list) {
                copy = new ArrayList<ConnectionEventListener>(this._connectionListeners);
            }
            if (callJCAListener) {
                for (Object e : copy) {
                    if (!(e instanceof ConnectionEventListener)) continue;
                    ((ConnectionEventListener)e).connectionErrorOccurred(event);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"connectionErrorOccurred");
        }
    }

    final boolean match(Subject subject, SICoreConnection coreConnection) {
        boolean subjectsMatch = this._subject == null ? subject == null : this._subject.equals(subject);
        boolean coreConnectionsMatch = coreConnection == null || coreConnection.isEquivalentTo(this._coreConnection);
        return subjectsMatch && coreConnectionsMatch && this.isValid();
    }

    final boolean match(JmsJcaUserDetails userDetails, SICoreConnection coreConnection) {
        boolean usersMatch = this._userDetails == null ? userDetails == null : this._userDetails.equals(userDetails);
        boolean coreConnectionsMatch = coreConnection == null || coreConnection.isEquivalentTo(this._coreConnection);
        return usersMatch && coreConnectionsMatch && this.isValid();
    }

    final SICoreConnection getCoreConnection() {
        return this._coreConnection;
    }

    public final String toString() {
        StringBuffer sb = new StringBuffer("[");
        sb.append(this.getClass().getName());
        sb.append("@");
        sb.append(Integer.toHexString(System.identityHashCode(this)));
        sb.append(" ");
        this.toStringFields(sb);
        sb.append("]");
        return sb.toString();
    }

    protected void toStringFields(StringBuffer buffer) {
        buffer.append("<managedConnectionFactory=");
        buffer.append(this._managedConnectionFactory);
        buffer.append("> <coreConnection=");
        buffer.append(this._coreConnection);
        buffer.append("> <localTransaction=");
        buffer.append(this._localTransaction);
        buffer.append("> <xaResource=");
        buffer.append(this._xaResource);
        buffer.append("> <metaData=");
        buffer.append(this._metaData);
        buffer.append("> <userDetails=");
        buffer.append(this._userDetails);
        buffer.append("> <subject=");
        buffer.append(JmsJcaManagedConnection.subjectToString(this._subject));
        buffer.append("> <logWriter=");
        buffer.append(this._logWriter);
        buffer.append("> <sessions=");
        buffer.append(this._sessions);
        buffer.append("> <connectionListeners=[");
        for (int i = 0; i < this._connectionListeners.size(); ++i) {
            ConnectionEventListener o = this._connectionListeners.get(i);
            if (i > 0) {
                buffer.append(",");
            }
            buffer.append(o.getClass().getName() + "@" + o.hashCode());
        }
        buffer.append("]>");
    }

    public static String subjectToString(Subject subject) {
        String result;
        if (subject == null) {
            result = "null";
        } else {
            StringBuffer buffer = new StringBuffer("[");
            buffer.append(subject.getClass().getName());
            buffer.append("@");
            buffer.append(Integer.toHexString(System.identityHashCode(subject)));
            buffer.append(" <principals=");
            buffer.append(subject.getPrincipals());
            buffer.append(">]");
            result = buffer.toString();
        }
        return result;
    }

    public boolean isValid() {
        return this._validConnection;
    }

    private final class JmsJcaConnectionListener
    implements SICoreConnectionListener {
        private JmsJcaConnectionListener() {
        }

        public void asynchronousException(ConsumerSession consumer, Throwable exception) {
            if (TraceComponent.isAnyTracingEnabled() && LISTENER_TRACE.isEntryEnabled()) {
                String methodName = "asynchronousException";
                SibTr.entry((Object)this, (TraceComponent)LISTENER_TRACE, (String)"asynchronousException", (Object)new Object[]{consumer, exception});
                SibTr.exit((Object)this, (TraceComponent)LISTENER_TRACE, (String)"asynchronousException");
            }
        }

        public void meQuiescing(SICoreConnection connection) {
            String methodName = "meQuiescing";
            if (TraceComponent.isAnyTracingEnabled() && LISTENER_TRACE.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)LISTENER_TRACE, (String)"meQuiescing", (Object)connection);
            }
            JmsJcaManagedConnection.this._validConnection = false;
            if (TraceComponent.isAnyTracingEnabled() && LISTENER_TRACE.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)LISTENER_TRACE, (String)"meQuiescing");
            }
        }

        public void commsFailure(SICoreConnection connection, SIConnectionLostException exception) {
            String methodName = "commsFailure";
            if (TraceComponent.isAnyTracingEnabled() && LISTENER_TRACE.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)LISTENER_TRACE, (String)"commsFailure", (Object)new Object[]{connection, exception});
            }
            JmsJcaManagedConnection.this.connectionErrorOccurred((Exception)((Object)exception), false);
            JmsJcaManagedConnection.this._validConnection = false;
            if (TraceComponent.isAnyTracingEnabled() && LISTENER_TRACE.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)LISTENER_TRACE, (String)"commsFailure");
            }
        }

        public void meTerminated(SICoreConnection connection) {
            String methodName = "meTerminated";
            if (TraceComponent.isAnyTracingEnabled() && LISTENER_TRACE.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)LISTENER_TRACE, (String)"meTerminated", (Object)connection);
            }
            JmsJcaManagedConnection.this.connectionErrorOccurred(null, false);
            JmsJcaManagedConnection.this._validConnection = false;
            if (TraceComponent.isAnyTracingEnabled() && LISTENER_TRACE.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)LISTENER_TRACE, (String)"meTerminated");
            }
        }
    }

    private final class JmsJcaLocalTransaction
    implements LocalTransaction {
        private SIUncoordinatedTransaction localSITransaction;

        private JmsJcaLocalTransaction() {
        }

        public void begin() throws LocalTransactionException {
            if (TraceComponent.isAnyTracingEnabled() && LOCAL_TRANSACTION_TRACE.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)LOCAL_TRANSACTION_TRACE, (String)"begin");
            }
            if (this.localSITransaction == null) {
                try {
                    this.localSITransaction = JmsJcaManagedConnection.this._coreConnection.createUncoordinatedTransaction();
                }
                catch (SIException exception) {
                    FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + ".JmsJcaLocalTransaction.begin"), (String)"1:1293:1.91", (Object)this);
                    throw new LocalTransactionException(NLS.getFormattedMessage("EXCEPTION_RECEIVED_CWSJR1112", new Object[]{exception, "begin"}, null), (Throwable)exception);
                }
                catch (SIErrorException exception) {
                    FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + ".JmsJcaLocalTransaction.begin"), (String)"1:1304:1.91", (Object)this);
                    throw new LocalTransactionException(NLS.getFormattedMessage("EXCEPTION_RECEIVED_CWSJR1112", new Object[]{exception, "begin"}, null), (Throwable)exception);
                }
            } else {
                throw new LocalTransactionException(NLS.getFormattedMessage("INVALID_SESSION_CWSJR1105", null, null));
            }
            if (TraceComponent.isAnyTracingEnabled() && LOCAL_TRANSACTION_TRACE.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)LOCAL_TRANSACTION_TRACE, (String)"begin");
            }
        }

        public void commit() throws LocalTransactionException {
            if (TraceComponent.isAnyTracingEnabled() && LOCAL_TRANSACTION_TRACE.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)LOCAL_TRANSACTION_TRACE, (String)"commit");
            }
            if (this.localSITransaction != null) {
                try {
                    this.localSITransaction.commit();
                }
                catch (SIException exception) {
                    FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + "JmsJcaLocalTransaction.commit"), (String)"1:1352:1.91", (Object)this);
                    throw new LocalTransactionException(NLS.getFormattedMessage("EXCEPTION_RECEIVED_CWSJR1113", new Object[]{exception, "commit"}, null), (Throwable)exception);
                }
                catch (SIErrorException exception) {
                    FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + "JmsJcaLocalTransaction.commit"), (String)"1:1363:1.91", (Object)this);
                    throw new LocalTransactionException(NLS.getFormattedMessage("EXCEPTION_RECEIVED_CWSJR1113", new Object[]{exception, "commit"}, null), (Throwable)exception);
                }
                finally {
                    this.localSITransaction = null;
                }
            } else {
                for (Object object : JmsJcaManagedConnection.this._sessions) {
                    if (!(object instanceof JmsJcaSessionImpl)) continue;
                    JmsJcaSessionImpl session = (JmsJcaSessionImpl)object;
                    try {
                        session.commitUnresolvedLocalTransaction();
                    }
                    catch (SIException exception) {
                        FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + "JmsJcaLocalTransaction.commit"), (String)"1:1399:1.91", (Object)this);
                        throw new LocalTransactionException(NLS.getFormattedMessage("EXCEPTION_RECEIVED_CWSJR1114", new Object[]{exception, "commit"}, null), (Throwable)exception);
                    }
                    catch (SIErrorException exception) {
                        FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + "JmsJcaLocalTransaction.commit"), (String)"1:1412:1.91", (Object)this);
                        throw new LocalTransactionException(NLS.getFormattedMessage("EXCEPTION_RECEIVED_CWSJR1114", new Object[]{exception, "commit"}, null), (Throwable)exception);
                    }
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && LOCAL_TRANSACTION_TRACE.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)LOCAL_TRANSACTION_TRACE, (String)"commit");
            }
        }

        public void rollback() throws LocalTransactionException {
            if (TraceComponent.isAnyTracingEnabled() && LOCAL_TRANSACTION_TRACE.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)LOCAL_TRANSACTION_TRACE, (String)"rollback");
            }
            if (this.localSITransaction != null) {
                try {
                    this.localSITransaction.rollback();
                }
                catch (SIException exception) {
                    FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + "JmsJcaLocalTransaction.rollback"), (String)"1:1460:1.91", (Object)this);
                }
                catch (SIErrorException exception) {
                    FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + "JmsJcaLocalTransaction.rollback"), (String)"1:1469:1.91", (Object)this);
                }
                finally {
                    this.localSITransaction = null;
                }
            } else {
                for (Object object : JmsJcaManagedConnection.this._sessions) {
                    if (!(object instanceof JmsJcaSessionImpl)) continue;
                    JmsJcaSessionImpl session = (JmsJcaSessionImpl)object;
                    try {
                        session.rollbackUnresolvedLocalTransaction();
                    }
                    catch (SIException exception) {
                        FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + "JmsJcaLocalTransaction.rollback"), (String)"1:1499:1.91", (Object)this);
                    }
                    catch (SIErrorException exception) {
                        FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + "JmsJcaLocalTransaction.rollback"), (String)"1:1508:1.91", (Object)this);
                    }
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && LOCAL_TRANSACTION_TRACE.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)LOCAL_TRANSACTION_TRACE, (String)"rollback");
            }
        }

        SITransaction getLocalSITransaction() {
            return this.localSITransaction;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer("[");
            sb.append(this.getClass().getName());
            sb.append("@");
            sb.append(Integer.toHexString(System.identityHashCode(this)));
            sb.append(" <localSITransaction=");
            sb.append(this.localSITransaction);
            sb.append(">]");
            return sb.toString();
        }
    }

    private final class JmsJcaManagedConnectionMetaData
    implements ManagedConnectionMetaData {
        private JmsJcaManagedConnectionMetaData() {
        }

        public String getEISProductName() throws ResourceException {
            return "WebSphere JMS";
        }

        public String getEISProductVersion() throws ResourceException {
            return "1.0";
        }

        public int getMaxConnections() throws ResourceException {
            return 0;
        }

        public String getUserName() throws ResourceException {
            String userName = null;
            if (JmsJcaManagedConnection.this._userDetails != null) {
                userName = JmsJcaManagedConnection.this._userDetails.getUserName();
            }
            return userName;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer("[");
            sb.append(this.getClass().getName());
            sb.append("@");
            sb.append(Integer.toHexString(System.identityHashCode(this)));
            sb.append("]");
            return sb.toString();
        }
    }
}

