/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.timedexit.internal;

import com.ibm.ws.ffdc.FFDCFilter;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;

public class TimedExitThread
extends Thread {
    private volatile long timeoutMillis = TimeUnit.MILLISECONDS.convert(120L, TimeUnit.MINUTES);
    private volatile boolean keepgoing = true;
    private final Object flag = new Object(){};

    public void setTimeout(long timeoutMillis) {
        this.timeoutMillis = timeoutMillis;
    }

    public TimedExitThread() {
        super.setName("TimedExitThread");
        this.setDaemon(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        boolean generateFFDC = true;
        int tries = 0;
        while (tries < 2) {
            block41: {
                long startTimeMillis = System.currentTimeMillis();
                long startTimeNanos = System.nanoTime();
                long endTimeNanos = -1L;
                long timeoutMillis = -1L;
                Object object = this.flag;
                // MONITORENTER : object
                while (this.keepgoing) {
                    timeoutMillis = this.timeoutMillis;
                    endTimeNanos = System.nanoTime();
                    long durationNanos = endTimeNanos - startTimeNanos;
                    long durationMillis = TimeUnit.MILLISECONDS.convert(durationNanos, TimeUnit.NANOSECONDS);
                    if (durationMillis >= timeoutMillis) break;
                    long waitMillis = timeoutMillis - durationMillis;
                    try {
                        this.flag.wait(waitMillis);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                // MONITOREXIT : object
                if (this.keepgoing) {
                    boolean canBeGentle;
                    block40: {
                        block39: {
                            canBeGentle = false;
                            long endTime = System.currentTimeMillis();
                            System.out.println("+-----------------------------------------------------------------------+");
                            System.out.println("| This Liberty server has been " + (tries == 0 ? "running" : "exiting") + " for too long");
                            System.out.println("| (Started at epoch time of " + startTimeMillis + " and nano time of " + startTimeNanos + ")");
                            System.out.println("| (Timed exit time (of " + timeoutMillis + " ms) exceeded at epoch time of " + endTime + " and nano time of " + endTimeNanos + ")");
                            try {
                                Class<?> JavacoreClass = Class.forName("com.ibm.jvm.Dump", true, null);
                                Method javaDump = JavacoreClass.getMethod("JavaDump", new Class[0]);
                                Method heapDump = JavacoreClass.getMethod("HeapDump", new Class[0]);
                                javaDump.invoke(null, new Object[0]);
                                heapDump.invoke(null, new Object[0]);
                            }
                            catch (ClassNotFoundException JavacoreClass) {
                            }
                            catch (SecurityException e) {
                                e.printStackTrace();
                            }
                            catch (NoSuchMethodException e) {
                                e.printStackTrace();
                            }
                            catch (IllegalArgumentException e) {
                                e.printStackTrace();
                            }
                            catch (IllegalAccessException e) {
                                e.printStackTrace();
                            }
                            catch (InvocationTargetException e) {
                                e.printStackTrace();
                            }
                            ThreadMXBean mbean = ManagementFactory.getThreadMXBean();
                            if (!mbean.isObjectMonitorUsageSupported()) break block39;
                            long[] deadlockedThreads = mbean.findDeadlockedThreads();
                            if (deadlockedThreads != null && deadlockedThreads.length != 0) {
                                ThreadInfo[] infos = mbean.getThreadInfo(deadlockedThreads, true, true);
                                System.out.println("| DEADLOCK DETECTED BY THE JVM, thread details:");
                                for (ThreadInfo info : infos) {
                                    System.out.println(info);
                                    if (info != null) {
                                        System.out.println("Waiting for " + info.getLockName() + " (held by thread ID " + info.getLockOwnerName() + "(id=" + info.getLockOwnerId() + ")");
                                        System.out.println("Monitors held by this thread: " + Arrays.toString(info.getLockedMonitors()));
                                        System.out.println("Synchronizers held by this thread: " + Arrays.toString(info.getLockedSynchronizers()));
                                    }
                                    System.out.println(".............................................................");
                                }
                                break block39;
                            }
                            if (tries >= 1) break block39;
                            canBeGentle = true;
                        }
                        try {
                            if (generateFFDC) {
                                FFDCFilter.processException((Throwable)new TimedExitException(), (String)TimedExitThread.class.getName(), (String)"run");
                                generateFFDC = false;
                            }
                            if (canBeGentle) {
                                canBeGentle = false;
                                System.out.println("| To attempt the timed exit, System.exit will be called");
                                System.out.println("+-----------------------------------------------------------------------+");
                                canBeGentle = true;
                            } else {
                                System.out.println("| To attempt the timed exit, Runtime.halt will be called");
                                System.out.println("+-----------------------------------------------------------------------+");
                                System.out.flush();
                            }
                            if (!canBeGentle) break block40;
                        }
                        catch (Throwable throwable) {
                            if (canBeGentle) {
                                try {
                                    new Thread(this.getName() + " System.exit"){

                                        @Override
                                        public void run() {
                                            System.exit(1);
                                        }
                                    }.start();
                                    break block41;
                                }
                                catch (Throwable t) {
                                    t.printStackTrace();
                                    System.err.flush();
                                }
                            }
                            Runtime.getRuntime().halt(1);
                            throw throwable;
                        }
                        try {
                            new /* invalid duplicate definition of identical inner class */.start();
                            break block41;
                        }
                        catch (Throwable t) {
                            t.printStackTrace();
                            System.err.flush();
                        }
                    }
                    Runtime.getRuntime().halt(1);
                    break block41;
                    catch (Throwable throwable) {
                        block42: {
                            if (generateFFDC) {
                                FFDCFilter.processException((Throwable)new TimedExitException(), (String)TimedExitThread.class.getName(), (String)"run");
                                generateFFDC = false;
                            }
                            if (canBeGentle) {
                                canBeGentle = false;
                                System.out.println("| To attempt the timed exit, System.exit will be called");
                                System.out.println("+-----------------------------------------------------------------------+");
                                canBeGentle = true;
                            } else {
                                System.out.println("| To attempt the timed exit, Runtime.halt will be called");
                                System.out.println("+-----------------------------------------------------------------------+");
                                System.out.flush();
                            }
                            if (!canBeGentle) break block42;
                            try {
                                new /* invalid duplicate definition of identical inner class */.start();
                            }
                            catch (Throwable t) {
                                t.printStackTrace();
                                System.err.flush();
                            }
                        }
                        Runtime.getRuntime().halt(1);
                        throw throwable;
                        catch (Throwable throwable2) {
                            if (canBeGentle) {
                                try {
                                    new /* invalid duplicate definition of identical inner class */.start();
                                    break block41;
                                }
                                catch (Throwable t) {
                                    t.printStackTrace();
                                    System.err.flush();
                                }
                            }
                            Runtime.getRuntime().halt(1);
                            throw throwable2;
                        }
                    }
                }
            }
            ++tries;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelCountdown() {
        this.keepgoing = false;
        Object object = this.flag;
        synchronized (object) {
            this.flag.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        boolean testTimeout = true;
        boolean testDeadlock = false;
        boolean testShutdown = true;
        long timeout = 1000L;
        final Object lock1 = new Object();
        final Object lock2 = new Object();
        Thread thread1 = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = lock1;
                synchronized (object) {
                    System.out.println("Thread1 has lock1");
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException ie) {
                        ie.printStackTrace();
                    }
                    Object object2 = lock2;
                    synchronized (object2) {
                        System.out.println("Thread1 has both locks");
                    }
                }
            }
        };
        Thread thread2 = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = lock2;
                synchronized (object) {
                    System.out.println("Thread2 has lock2");
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException ie) {
                        ie.printStackTrace();
                    }
                    Object object2 = lock1;
                    synchronized (object2) {
                        System.out.println("Thread2 has both locks");
                    }
                }
            }
        };
        Thread shutdownThread = new Thread(){

            @Override
            public void run() {
                System.out.println("Shutdown hook sleeping");
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException ie) {
                    ie.printStackTrace();
                }
                finally {
                    System.out.println("Shutdown hook finished");
                }
            }
        };
        TimedExitThread tet = new TimedExitThread();
        tet.setTimeout(1000L);
        Runtime.getRuntime().addShutdownHook(shutdownThread);
        tet.start();
        System.out.println("main() sleeping");
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException ie) {
            ie.printStackTrace();
        }
        finally {
            System.out.println("main() finished");
        }
    }

    private static class TimedExitException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public TimedExitException() {
            super("Server was forced to shutdown by timed exit.");
        }
    }
}

