/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.timedexit.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.timedexit.internal.RequiredTimedExitFeatureStoppedException;
import com.ibm.ws.timedexit.internal.TimedExitThread;
import com.ibm.wsspi.kernel.service.utils.FrameworkState;
import io.openliberty.checkpoint.spi.CheckpointHook;
import io.openliberty.checkpoint.spi.CheckpointPhase;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public class TimedExitComponent
implements BundleActivator {
    private final TimedExitThread mash = new TimedExitThread();
    private static TraceComponent tc = Tr.register(TimedExitComponent.class, (String)"timedexit", (String)"com.ibm.ws.timedexit.internal.resources.TimedExitMessages");

    public void start(BundleContext context) {
        try {
            String timeoutProperty;
            Tr.audit((TraceComponent)tc, (String)"TE9900.timedexit.enabled", (Object[])new Object[0]);
            if (CheckpointPhase.getPhase() != CheckpointPhase.INACTIVE) {
                context.registerService(CheckpointHook.class, (Object)new CheckpointHook(){

                    public void restore() {
                        Tr.audit((TraceComponent)tc, (String)"TE9900.timedexit.enabled", (Object[])new Object[0]);
                    }
                }, null);
            }
            if ((timeoutProperty = System.getProperty("com.ibm.ws.timedexit.timetolive")) != null) {
                long timeout = Long.parseLong(timeoutProperty);
                this.mash.setTimeout(timeout);
            }
        }
        catch (SecurityException se) {
            se.printStackTrace();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.mash.start();
    }

    public void stop(BundleContext context) {
        if (!FrameworkState.isStopping()) {
            RequiredTimedExitFeatureStoppedException ex = new RequiredTimedExitFeatureStoppedException("The timedexit-1.0 feature is being stopped before the server is stopping.  It must be enabled during ALL FAT bucket runs; make sure that fatTestPorts.xml is included in the server.xml.");
            FFDCFilter.processException((Throwable)ex, (String)this.getClass().getName(), (String)"stop");
        }
    }
}

