/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.comms.client;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.comms.client.ClientLinkLevelState;
import com.ibm.ws.sib.comms.client.ConnectionProxy;
import com.ibm.ws.sib.comms.client.ConsumerSessionProxy;
import com.ibm.ws.sib.comms.client.Proxy;
import com.ibm.ws.sib.jfapchannel.Conversation;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.HashSet;

public abstract class Transaction
extends Proxy {
    private static final TraceComponent tc = SibTr.register(Transaction.class, (String)"SIBCommunications", (String)"com.ibm.ws.sib.comms.CWSICMessages");
    private static final String CLASS_NAME = Transaction.class.getName();
    protected short lowestPriority = (short)11;
    private int localTranasctionId = 0;
    private final boolean strictRedeliveryOrdering;
    private final HashSet associatedConsumers;
    private final AssociatedConsumersLock associatedConsumersLock;

    public Transaction(Conversation con, ConnectionProxy cp) {
        super(con, cp);
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"<init>", (Object)new Object[]{con, cp});
        }
        ClientLinkLevelState linkState = (ClientLinkLevelState)con.getLinkLevelAttachment();
        this.localTranasctionId = linkState.getNextTransactionId();
        this.strictRedeliveryOrdering = cp.getStrictRedeliveryOrdering();
        if (this.strictRedeliveryOrdering) {
            this.associatedConsumers = new HashSet();
            this.associatedConsumersLock = new AssociatedConsumersLock();
        } else {
            this.associatedConsumers = null;
            this.associatedConsumersLock = null;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"<init>");
        }
    }

    public int getTransactionId() {
        return this.localTranasctionId;
    }

    public short getLowestMessagePriority() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getLowestMessagePriority");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getLowestMessagePriority", (Object)("" + this.lowestPriority));
        }
        return this.lowestPriority;
    }

    public void updateLowestMessagePriority(short messagePriority) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"updateLowestMessagePriority", (Object)new Object[]{"" + messagePriority});
        }
        if (messagePriority < this.lowestPriority) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Updating lowest priority");
            }
            this.lowestPriority = messagePriority;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"updateLowestMessagePriority");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void associateConsumer(ConsumerSessionProxy consumer) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"associateConsumer", (Object)new Object[]{consumer, this.strictRedeliveryOrdering});
        }
        if (this.strictRedeliveryOrdering && consumer != null) {
            AssociatedConsumersLock associatedConsumersLock = this.associatedConsumersLock;
            synchronized (associatedConsumersLock) {
                this.associatedConsumers.add(consumer);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"associateConsumer");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void informConsumersOfRollback() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"informConsumersOfRollback", (Object)new Object[]{this.strictRedeliveryOrdering});
        }
        if (this.strictRedeliveryOrdering) {
            ConsumerSessionProxy[] consumersToNotify;
            AssociatedConsumersLock associatedConsumersLock = this.associatedConsumersLock;
            synchronized (associatedConsumersLock) {
                consumersToNotify = new ConsumerSessionProxy[this.associatedConsumers.size()];
                consumersToNotify = this.associatedConsumers.toArray(consumersToNotify);
            }
            for (int i = 0; i < consumersToNotify.length; ++i) {
                try {
                    consumersToNotify[i].rollbackOccurred();
                    continue;
                }
                catch (SIException e) {
                    FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".informConsumersOfRollback"), (String)"5-007-0001", (Object)this);
                    if (tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)("Encountered error informing consumer of rollback: " + consumersToNotify[i]));
                    }
                    if (!tc.isEventEnabled()) continue;
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"informConsumersOfRollback");
        }
    }

    public abstract boolean isValid();

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#)SIB/ws/code/sib.comms.client.impl/src/com/ibm/ws/sib/comms/client/Transaction.java, SIB.comms, WASX.SIB, uu1215.01 1.22");
        }
    }

    private static final class AssociatedConsumersLock {
        private AssociatedConsumersLock() {
        }
    }
}

