/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.concurrent.internal.processor;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.injectionengine.ComponentNameSpaceConfiguration;
import com.ibm.wsspi.injectionengine.InjectionBinding;
import com.ibm.wsspi.injectionengine.InjectionConfigurationException;
import com.ibm.wsspi.injectionengine.InjectionException;
import com.ibm.wsspi.injectionengine.JNDIEnvironmentRefType;
import jakarta.enterprise.concurrent.ContextService;
import jakarta.enterprise.concurrent.ContextServiceDefinition;
import java.lang.reflect.Member;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ContextServiceDefinitionBinding
extends InjectionBinding<ContextServiceDefinition> {
    private static final TraceComponent tc = Tr.register(ContextServiceDefinitionBinding.class, (String)"concurrent", (String)"io.openliberty.concurrent.internal.resources.CWWKCMessages");
    private static final String KEY_CLEARED = "cleared";
    private static final String KEY_DESCRIPTION = "description";
    private static final String KEY_PROPAGATED = "propagated";
    private static final String KEY_UNCHANGED = "unchanged";
    private static final String KEY_QUALIFIERS = "qualifiers";
    private static final String[] DEFAULT_CLEARED = new String[]{"Transaction"};
    private static final String[] DEFAULT_PROPAGATED = new String[]{"Remaining"};
    private static final String[] DEFAULT_UNCHANGED = new String[0];
    private static final String[] DEFAULT_QUALIFIERS = new String[0];
    private final int eeVersion;
    private String[] cleared;
    private boolean XMLcleared;
    private String description;
    private boolean XMLDescription;
    private String[] propagated;
    private boolean XMLpropagated;
    private String[] unchanged;
    private boolean XMLunchanged;
    private String[] qualifiers;
    private boolean XMLqualifers;
    private Map<String, String> properties;
    private final Set<String> XMLProperties = new HashSet<String>();
    static final long serialVersionUID = 7302312721803249459L;

    public ContextServiceDefinitionBinding(String jndiName, ComponentNameSpaceConfiguration nameSpaceConfig, int eeVersion) {
        super(null, nameSpaceConfig);
        this.setJndiName(jndiName);
        this.eeVersion = eeVersion;
    }

    public Class<?> getAnnotationType() {
        return ContextServiceDefinition.class;
    }

    protected JNDIEnvironmentRefType getJNDIEnvironmentRefType() {
        return JNDIEnvironmentRefType.ContextService;
    }

    @ManualTrace
    public void merge(ContextServiceDefinition annotation, Class<?> instanceClass, Member member) throws InjectionException {
        boolean trace;
        boolean bl = trace = TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled();
        if (trace) {
            Tr.entry((Object)((Object)this), (TraceComponent)tc, (String)"merge", (Object[])new Object[]{ContextServiceDefinitionBinding.toString(annotation, this.eeVersion), instanceClass, member, (this.XMLcleared ? "   (xml)" : "        ") + "cleared: " + ContextServiceDefinitionBinding.toString(this.cleared) + " << " + ContextServiceDefinitionBinding.toString(annotation.cleared()), (this.XMLpropagated ? "(xml)" : "     ") + "propagated: " + ContextServiceDefinitionBinding.toString(this.propagated) + " << " + ContextServiceDefinitionBinding.toString(annotation.propagated()), (this.XMLunchanged ? " (xml)" : "      ") + "unchanged: " + ContextServiceDefinitionBinding.toString(this.unchanged) + " << " + ContextServiceDefinitionBinding.toString(annotation.unchanged()), (this.XMLqualifers ? " (xml)" : "     ") + "qualifiers: " + ContextServiceDefinitionBinding.toString(this.qualifiers) + " << " + (this.eeVersion >= 11 ? ContextServiceDefinitionBinding.toString(annotation.qualifiers()) : "Unspecified")});
        }
        if (member != null) {
            throw new IllegalArgumentException(member.toString());
        }
        this.cleared = (String[])this.mergeAnnotationValue(this.cleared == DEFAULT_CLEARED ? null : this.cleared, this.XMLcleared, annotation.cleared(), KEY_CLEARED, DEFAULT_CLEARED);
        this.description = (String)this.mergeAnnotationValue(this.description, this.XMLDescription, "", KEY_DESCRIPTION, "");
        this.propagated = (String[])this.mergeAnnotationValue(this.propagated == DEFAULT_PROPAGATED ? null : this.propagated, this.XMLpropagated, annotation.propagated(), KEY_PROPAGATED, DEFAULT_PROPAGATED);
        this.unchanged = (String[])this.mergeAnnotationValue(this.unchanged, this.XMLunchanged, annotation.unchanged(), KEY_UNCHANGED, DEFAULT_UNCHANGED);
        if (this.eeVersion >= 11) {
            this.qualifiers = (String[])this.mergeAnnotationValue(this.qualifiers, this.XMLqualifers, ContextServiceDefinitionBinding.toQualifierStringArray(annotation.qualifiers()), KEY_QUALIFIERS, DEFAULT_QUALIFIERS);
        }
        this.properties = this.mergeAnnotationProperties(this.properties, this.XMLProperties, new String[0]);
        if (trace) {
            Tr.exit((Object)((Object)this), (TraceComponent)tc, (String)"merge", (Object)new String[]{(this.XMLcleared ? "   (xml)" : "        ") + "cleared= " + ContextServiceDefinitionBinding.toString(this.cleared), (this.XMLpropagated ? "(xml)" : "     ") + "propagated= " + ContextServiceDefinitionBinding.toString(this.propagated), (this.XMLunchanged ? " (xml)" : "      ") + "unchanged= " + ContextServiceDefinitionBinding.toString(this.unchanged), (this.XMLqualifers ? " (xml)" : "     ") + "qualifiers= " + ContextServiceDefinitionBinding.toString(this.qualifiers)});
        }
    }

    @ManualTrace
    void mergeXML(com.ibm.ws.javaee.dd.common.ContextService csd) throws InjectionConfigurationException {
        String[] qualifierValues;
        String[] unchangedValues;
        String[] propagatedValues;
        boolean trace;
        boolean bl = trace = TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled();
        if (trace) {
            Tr.entry((Object)((Object)this), (TraceComponent)tc, (String)"mergeXML", (Object[])new Object[]{csd, csd.getName(), (this.XMLcleared ? "   (xml)" : "        ") + "cleared: " + ContextServiceDefinitionBinding.toString(this.cleared) + " << " + ContextServiceDefinitionBinding.toString(csd.getCleared()), (this.XMLpropagated ? "(xml)" : "     ") + "propagated: " + ContextServiceDefinitionBinding.toString(this.propagated) + " << " + ContextServiceDefinitionBinding.toString(csd.getPropagated()), (this.XMLunchanged ? " (xml)" : "      ") + "unchanged: " + ContextServiceDefinitionBinding.toString(this.unchanged) + " << " + ContextServiceDefinitionBinding.toString(csd.getUnchanged()), (this.XMLqualifers ? " (xml)" : "     ") + "qualifiers: " + ContextServiceDefinitionBinding.toString(this.qualifiers) + " << " + ContextServiceDefinitionBinding.toString(csd.getQualifiers())});
        }
        List descriptionList = csd.getDescriptions();
        String[] clearedValues = csd.getCleared();
        if (clearedValues == null || clearedValues.length == 0) {
            if (this.cleared == null) {
                this.cleared = DEFAULT_CLEARED;
            }
        } else {
            this.cleared = (String[])this.mergeXMLValue(this.cleared, clearedValues, KEY_CLEARED, KEY_CLEARED, null);
            this.XMLcleared = true;
        }
        if (this.description != null) {
            this.description = (String)this.mergeXMLValue(this.description, descriptionList.toString(), KEY_DESCRIPTION, KEY_DESCRIPTION, null);
            this.XMLDescription = true;
        }
        if ((propagatedValues = csd.getPropagated()) == null || propagatedValues.length == 0) {
            if (this.propagated == null) {
                this.propagated = DEFAULT_PROPAGATED;
            }
        } else {
            this.propagated = (String[])this.mergeXMLValue(this.propagated, propagatedValues, KEY_PROPAGATED, KEY_PROPAGATED, null);
            this.XMLpropagated = true;
        }
        if ((unchangedValues = csd.getUnchanged()) != null && unchangedValues.length > 0) {
            this.unchanged = (String[])this.mergeXMLValue(this.unchanged, unchangedValues, KEY_UNCHANGED, KEY_UNCHANGED, null);
            this.XMLunchanged |= true;
        }
        if ((qualifierValues = csd.getQualifiers()) == null || qualifierValues.length == 0) {
            if (this.qualifiers == null) {
                this.qualifiers = DEFAULT_QUALIFIERS;
            }
        } else if (qualifierValues.length == 1 && qualifierValues[0].isEmpty()) {
            this.qualifiers = DEFAULT_QUALIFIERS;
            this.XMLqualifers = true;
        } else {
            this.qualifiers = (String[])this.mergeXMLValue(this.qualifiers, qualifierValues, "qualifier", KEY_QUALIFIERS, null);
            this.XMLqualifers = true;
        }
        List csdProps = csd.getProperties();
        this.properties = this.mergeXMLProperties(this.properties, this.XMLProperties, csdProps);
        if (trace) {
            Tr.exit((Object)((Object)this), (TraceComponent)tc, (String)"mergeXML", (Object)new String[]{(this.XMLcleared ? "   (xml)" : "        ") + "cleared= " + ContextServiceDefinitionBinding.toString(this.cleared), (this.XMLpropagated ? "(xml)" : "     ") + "propagated= " + ContextServiceDefinitionBinding.toString(this.propagated), (this.XMLunchanged ? " (xml)" : "      ") + "unchanged= " + ContextServiceDefinitionBinding.toString(this.unchanged), (this.XMLqualifers ? " (xml)" : "     ") + "qualifiers= " + ContextServiceDefinitionBinding.toString(this.qualifiers)});
        }
    }

    public void mergeSaved(InjectionBinding<ContextServiceDefinition> injectionBinding) throws InjectionException {
        ContextServiceDefinitionBinding contextServiceBinding = (ContextServiceDefinitionBinding)injectionBinding;
        this.mergeSavedValue(this.cleared, contextServiceBinding.cleared, KEY_CLEARED);
        this.mergeSavedValue(this.description, contextServiceBinding.description, KEY_DESCRIPTION);
        this.mergeSavedValue(this.propagated, contextServiceBinding.propagated, KEY_PROPAGATED);
        this.mergeSavedValue(this.unchanged, contextServiceBinding.unchanged, KEY_UNCHANGED);
        this.mergeSavedValue(this.qualifiers, contextServiceBinding.qualifiers, "qualifier");
        this.mergeSavedValue(this.properties, contextServiceBinding.properties, "properties");
    }

    void resolve() throws InjectionException {
        HashMap<String, String> props = new HashMap<String, String>();
        if (this.properties != null) {
            props.putAll(this.properties);
        }
        ContextServiceDefinitionBinding.addOrRemoveProperty(props, (Object)KEY_CLEARED, (Object)this.cleared);
        ContextServiceDefinitionBinding.addOrRemoveProperty(props, (Object)KEY_DESCRIPTION, (Object)this.description);
        ContextServiceDefinitionBinding.addOrRemoveProperty(props, (Object)KEY_PROPAGATED, (Object)this.propagated);
        ContextServiceDefinitionBinding.addOrRemoveProperty(props, (Object)KEY_UNCHANGED, (Object)this.unchanged);
        ContextServiceDefinitionBinding.addOrRemoveProperty(props, (Object)KEY_QUALIFIERS, (Object)this.qualifiers);
        this.setObjects(null, this.createDefinitionReference(null, ContextService.class.getName(), props));
    }

    @Trivial
    static final String toString(ContextServiceDefinition anno, int eeVersion) {
        StringBuilder b = new StringBuilder();
        b.append("ContextServiceDefinition@").append(Integer.toHexString(anno.hashCode())).append("#EE").append(eeVersion).append("(name=").append(anno.name()).append(", cleared=").append(Arrays.toString(anno.cleared())).append(", propagated=").append(Arrays.toString(anno.propagated())).append(", unchanged=").append(Arrays.toString(anno.unchanged()));
        if (eeVersion >= 11) {
            b.append(", qualifiers=").append(Arrays.toString(anno.qualifiers()));
        }
        b.append(")");
        return b.toString();
    }

    @Trivial
    private static final <T> String toString(T[] list) {
        if (list == null || list.length == 0) {
            return "Unspecified";
        }
        boolean none = true;
        for (int i = 0; none && i < list.length; none &= list[i] == null || list[i].toString().isEmpty(), ++i) {
        }
        return none ? "None" : Arrays.toString(list);
    }

    @Trivial
    private static final String[] toQualifierStringArray(Class<?>[] classList) {
        String[] qualifierNames = new String[classList.length];
        for (int i = 0; i < classList.length; ++i) {
            qualifierNames[i] = classList[i].getCanonicalName();
        }
        return qualifierNames;
    }
}

