/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.orb.csi;

import java.io.UnsupportedEncodingException;
import java.util.logging.Logger;
import org.omg.CORBA.Any;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.ORB;
import org.omg.CORBA.OctetSeqHelper;
import org.omg.CORBA.UserException;
import org.omg.CSI.AuthorizationElement;
import org.omg.CSI.SASContextBody;
import org.omg.CSI.SASContextBodyHelper;
import org.omg.CSIIOP.CompoundSecMechList;
import org.omg.CSIIOP.CompoundSecMechListHelper;
import org.omg.CSIIOP.CompoundSecMechanismsHelper;
import org.omg.GSSUP.InitialContextToken;
import org.omg.GSSUP.InitialContextTokenHelper;
import org.omg.IOP.Codec;
import org.omg.IOP.CodecPackage.FormatMismatch;
import org.omg.IOP.CodecPackage.InvalidTypeForEncoding;
import org.omg.IOP.CodecPackage.TypeMismatch;
import org.omg.IOP.ServiceContext;
import org.omg.IOP.TaggedComponent;

public abstract class CSIInterceptorBase
extends LocalObject {
    private static final Logger log = Logger.getLogger(CSIInterceptorBase.class.getName());
    static final AuthorizationElement[] EMPTY_AUTH_ELEMENT = new AuthorizationElement[0];
    static final byte[] EMPTY_BARR = new byte[0];
    ORB orb;
    protected final Codec codec;
    static final byte[] GSSUP_OID = new byte[]{6, 6, 103, -127, 2, 1, 1, 1};

    CSIInterceptorBase(Codec codec) {
        this.codec = codec;
    }

    protected final ORB getOrb() {
        if (this.orb == null) {
            this.orb = ORB.init();
        }
        return this.orb;
    }

    SASContextBody decodeSASContextBody(ServiceContext sasSC) {
        Any any;
        try {
            any = this.codec.decode_value(sasSC.context_data, SASContextBodyHelper.type());
        }
        catch (FormatMismatch ex) {
            throw (INTERNAL)new INTERNAL(ex.getMessage()).initCause((Throwable)ex);
        }
        catch (TypeMismatch ex) {
            throw (INTERNAL)new INTERNAL(ex.getMessage()).initCause((Throwable)ex);
        }
        return SASContextBodyHelper.extract((Any)any);
    }

    CompoundSecMechList decodeCompoundSecMechList(TaggedComponent seccomp) throws FormatMismatch, TypeMismatch {
        Any any = this.codec.decode_value(seccomp.component_data, CompoundSecMechanismsHelper.type());
        return CompoundSecMechListHelper.extract((Any)any);
    }

    byte[] utf8encode(String text) {
        if (text == null) {
            return EMPTY_BARR;
        }
        try {
            return text.getBytes("UTF8");
        }
        catch (UnsupportedEncodingException ex) {
            throw (INTERNAL)new INTERNAL(ex.getMessage()).initCause((Throwable)ex);
        }
    }

    String utf8decode(byte[] data) {
        try {
            return new String(data, "UTF8");
        }
        catch (UnsupportedEncodingException ex) {
            throw (INTERNAL)new INTERNAL(ex.getMessage()).initCause((Throwable)ex);
        }
    }

    byte[] encapsulateByteArray(byte[] data) {
        Any a = this.getOrb().create_any();
        OctetSeqHelper.insert((Any)a, (byte[])data);
        try {
            return this.codec.encode_value(a);
        }
        catch (InvalidTypeForEncoding e) {
            MARSHAL me = new MARSHAL("cannot encode security descriptor", 0, CompletionStatus.COMPLETED_NO);
            me.initCause((Throwable)e);
            throw me;
        }
    }

    byte[] encodeGSSUPToken(InitialContextToken gssupToken) {
        byte[] data;
        Any a = this.getOrb().create_any();
        InitialContextTokenHelper.insert((Any)a, (InitialContextToken)gssupToken);
        try {
            data = this.codec.encode_value(a);
        }
        catch (InvalidTypeForEncoding e) {
            MARSHAL me = new MARSHAL("cannot encode security descriptor", 0, CompletionStatus.COMPLETED_NO);
            me.initCause((Throwable)e);
            throw me;
        }
        int len = data.length + GSSUP_OID.length;
        if (len < 128) {
            byte[] result = new byte[len + 2];
            result[0] = 96;
            result[1] = (byte)len;
            System.arraycopy(GSSUP_OID, 0, result, 2, GSSUP_OID.length);
            System.arraycopy(data, 0, result, 10, data.length);
            return result;
        }
        if (len < 16384) {
            byte[] result = new byte[len + 3];
            result[0] = 96;
            result[1] = (byte)((byte)(len >> 7) | 0xFFFFFF80);
            result[2] = (byte)(len & 0x7F);
            System.arraycopy(GSSUP_OID, 0, result, 3, GSSUP_OID.length);
            System.arraycopy(data, 0, result, 11, data.length);
            return result;
        }
        if (len < 0x200000) {
            byte[] result = new byte[len + 4];
            result[0] = 96;
            result[2] = (byte)(0xFFFFFF80 | (byte)(0x7F & len >> 14));
            result[1] = (byte)(0xFFFFFF80 | (byte)(0x7F & len >> 7));
            result[3] = (byte)(len & 0x7F);
            System.arraycopy(GSSUP_OID, 0, result, 4, GSSUP_OID.length);
            System.arraycopy(data, 0, result, 12, data.length);
            return result;
        }
        throw new INTERNAL("user/password too long");
    }

    InitialContextToken decodeGSSUPToken(byte[] data) {
        byte b;
        if (data[0] != 96) {
            throw new MARSHAL("Invalid Token");
        }
        int idx = 1;
        int len = 0;
        do {
            len <<= 7;
            b = data[idx++];
            len |= b & 0x7F;
        } while ((b & 0x80) == 128);
        if (len + idx != data.length) {
            throw new MARSHAL("Bad Token Size");
        }
        for (int i = 0; i < GSSUP_OID.length; ++i) {
            if (data[idx + i] == GSSUP_OID[i]) continue;
            throw new NO_PERMISSION("Not GSSUP_OID");
        }
        byte[] token = new byte[data.length - (idx += GSSUP_OID.length)];
        System.arraycopy(data, idx, token, 0, data.length - idx);
        try {
            Any a = this.codec.decode_value(data, InitialContextTokenHelper.type());
            return InitialContextTokenHelper.extract((Any)a);
        }
        catch (UserException e) {
            MARSHAL me = new MARSHAL("cannot decode local security descriptor", 0, CompletionStatus.COMPLETED_NO);
            me.initCause((Throwable)e);
            throw me;
        }
    }

    ServiceContext encodeSASContextBody(SASContextBody sasBody) {
        byte[] data;
        Any a = this.getOrb().create_any();
        SASContextBodyHelper.insert((Any)a, (SASContextBody)sasBody);
        try {
            data = this.codec.encode_value(a);
        }
        catch (UserException ex) {
            MARSHAL me = new MARSHAL("cannot encode local security descriptor", 0, CompletionStatus.COMPLETED_NO);
            me.initCause((Throwable)ex);
            throw me;
        }
        return new ServiceContext(15, data);
    }

    byte[] encodeGSSExportedName(String value) {
        byte[] name_data = this.utf8encode(value);
        int len = 8 + name_data.length + GSSUP_OID.length;
        byte[] result = new byte[len];
        result[0] = 4;
        result[1] = 1;
        result[2] = 0;
        result[3] = (byte)GSSUP_OID.length;
        for (int i = 0; i < GSSUP_OID.length; ++i) {
            result[4 + i] = GSSUP_OID[i];
        }
        int name_len = name_data.length;
        int idx = 4 + GSSUP_OID.length;
        result[idx + 0] = (byte)(name_len >> 24 & 0xFF);
        result[idx + 1] = (byte)(name_len >> 16 & 0xFF);
        result[idx + 2] = (byte)(name_len >> 8 & 0xFF);
        result[idx + 3] = (byte)(name_len & 0xFF);
        for (int i = 0; i < name_len; ++i) {
            result[idx + 4 + i] = name_data[i];
        }
        return result;
    }

    String decodeGSSExportedName(byte[] data) {
        if (data.length < 8 + GSSUP_OID.length) {
            log.fine("exported name too short len=" + data.length);
            return null;
        }
        if (data[0] != 4 || data[1] != 1 || data[2] != 0 || data[3] != GSSUP_OID.length) {
            log.fine("wrong name header");
            return null;
        }
        for (int i = 0; i < GSSUP_OID.length; ++i) {
            if (data[4 + i] == GSSUP_OID[i]) continue;
            log.fine("wrong name OID @ " + i);
            return null;
        }
        int idx = 4 + GSSUP_OID.length;
        int len = data[idx + 0] << 24 & 0xFF000000 | data[idx + 1] << 16 & 0xFF0000 | data[idx + 2] << 8 & 0xFF00 | data[idx + 3] << 0 & 0xFF;
        try {
            return new String(data, idx + 4, data.length - (idx + 4), "UTF8");
        }
        catch (UnsupportedEncodingException ex) {
            throw (INTERNAL)new INTERNAL(ex.getMessage()).initCause((Throwable)ex);
        }
    }

    static class CallStatus {
        boolean isLocal;
        CallStatus prev;
        static ThreadLocal status = new ThreadLocal();

        CallStatus(boolean l, CallStatus p) {
            this.isLocal = l;
            this.prev = p;
        }

        static void pushIsLocal(boolean isLocal) {
            CallStatus cs = new CallStatus(isLocal, (CallStatus)status.get());
            status.set(cs);
        }

        static boolean peekIsLocal() {
            CallStatus cs = (CallStatus)status.get();
            if (cs == null) {
                return false;
            }
            return cs.isLocal;
        }

        static boolean popIsLocal() {
            CallStatus cs = (CallStatus)status.get();
            if (cs == null) {
                return false;
            }
            status.set(cs.prev);
            return cs.isLocal;
        }
    }
}

