/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.orb.OB;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

public final class Net {
    private static final String LOOPBACK_NAME = "127.0.0.1";

    public static boolean CompareHosts(final String host1, final String host2, final boolean matchLoopback) {
        if (host1.equals(host2) || matchLoopback && host2.equals(LOOPBACK_NAME)) {
            return true;
        }
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Boolean>(){

                @Override
                public Boolean run() throws UnknownHostException {
                    InetAddress addr2;
                    InetAddress addr1 = InetAddress.getByName(host1);
                    return addr1.equals(addr2 = InetAddress.getByName(host2)) || matchLoopback && addr2.equals(InetAddress.getByName(Net.LOOPBACK_NAME));
                }
            });
        }
        catch (PrivilegedActionException e) {
            try {
                throw e.getException();
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (UnknownHostException uhe) {
                return false;
            }
            catch (Exception e2) {
                throw new RuntimeException("Unexpected exception", e2);
            }
        }
    }

    public static boolean CompareHosts(String host1, String host2) {
        return Net.CompareHosts(host1, host2, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getCanonicalHostname(boolean numeric) {
        String host;
        try {
            host = !numeric ? InetAddress.getLocalHost().getHostName() : InetAddress.getLocalHost().getHostAddress();
            if (host.equals(LOOPBACK_NAME)) return host;
            if (!host.equals("localhost")) return host;
        }
        catch (UnknownHostException ex) {
            if (!numeric) return "localhost";
            return LOOPBACK_NAME;
        }
        return host;
    }
}

