/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.rmi.impl;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import javax.rmi.CORBA.PortableRemoteObjectDelegate;
import javax.rmi.CORBA.Stub;
import javax.rmi.CORBA.Tie;
import javax.rmi.CORBA.Util;
import org.apache.yoko.logging.VerboseLogging;
import org.apache.yoko.rmi.impl.MethodDescriptor;
import org.apache.yoko.rmi.impl.RMIRemoteStub;
import org.apache.yoko.rmi.impl.RMIServant;
import org.apache.yoko.rmi.impl.RMIState;
import org.apache.yoko.rmi.impl.RMIStub;
import org.apache.yoko.rmi.impl.RemoteInterfaceDescriptor;
import org.apache.yoko.rmi.util.ClientUtil;
import org.apache.yoko.rmi.util.stub.MethodRef;
import org.apache.yoko.rmi.util.stub.StubClass;
import org.apache.yoko.util.Exceptions;
import org.apache.yoko.util.PrivilegedActions;
import org.omg.CORBA.BAD_INV_ORDER;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.Object;
import org.omg.CORBA.portable.Delegate;
import org.omg.CORBA.portable.IDLEntity;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAPackage.ServantAlreadyActive;
import org.omg.PortableServer.POAPackage.ServantNotActive;
import org.omg.PortableServer.POAPackage.WrongPolicy;
import org.omg.PortableServer.Servant;

public class PortableRemoteObjectImpl
implements PortableRemoteObjectDelegate {
    static final Logger LOGGER = Logger.getLogger(PortableRemoteObjectImpl.class.getName());

    public void connect(Remote target, Remote source) throws RemoteException {
        ObjectImpl obj;
        source = this.toStub(source);
        if (target instanceof ObjectImpl) {
            obj = (ObjectImpl)target;
        } else {
            try {
                this.exportObject(target);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            try {
                obj = (ObjectImpl)this.toStub(target);
            }
            catch (NoSuchObjectException ex) {
                throw (RemoteException)Exceptions.as(RemoteException::new, (Throwable)ex, (java.lang.Object)"cannot convert to stub!");
            }
        }
        try {
            ((Stub)source).connect(obj._orb());
        }
        catch (BAD_OPERATION bad_operation) {
            throw (RemoteException)Exceptions.as(RemoteException::new, (Throwable)bad_operation, (java.lang.Object)bad_operation.getMessage());
        }
    }

    private java.lang.Object narrowRMI(ObjectImpl narrowFrom, Class<?> narrowTo) {
        Delegate delegate;
        Stub stub;
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(String.format("RMI narrowing %s => %s", narrowFrom.getClass().getName(), narrowTo.getName()));
        }
        RMIState state = RMIState.current();
        try {
            stub = PortableRemoteObjectImpl.createStub(state, narrowTo);
        }
        catch (NoClassDefFoundError ex) {
            throw (ClassCastException)Exceptions.as(ClassCastException::new, (Throwable)ex, (java.lang.Object)narrowTo.getName());
        }
        try {
            delegate = narrowFrom._get_delegate();
        }
        catch (BAD_OPERATION ex) {
            delegate = null;
        }
        stub._set_delegate(delegate);
        return stub;
    }

    private java.lang.Object narrowIDL(ObjectImpl narrowFrom, Class<?> narrowTo) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(String.format("IDL narrowing %s => %s", narrowFrom.getClass().getName(), narrowTo.getName()));
        }
        ClassLoader idlClassLoader = (ClassLoader)AccessController.doPrivileged(PrivilegedActions.getClassLoader(narrowTo));
        String helperClassName = narrowTo.getName() + "Helper";
        try {
            Class helperClass = Util.loadClass((String)helperClassName, null, (ClassLoader)idlClassLoader);
            Method helperNarrow = (Method)AccessController.doPrivileged(PrivilegedActions.getMethod((Class)helperClass, (String)"narrow", (Class[])new Class[]{Object.class}));
            return helperNarrow.invoke(null, narrowFrom);
        }
        catch (Exception e) {
            throw (ClassCastException)Exceptions.as(ClassCastException::new, (Throwable)e, (java.lang.Object)narrowTo.getName());
        }
    }

    public java.lang.Object narrow(java.lang.Object narrowFrom, Class narrowTo) throws ClassCastException {
        if (narrowFrom == null) {
            return null;
        }
        if (narrowTo.isInstance(narrowFrom)) {
            return narrowFrom;
        }
        String fromClassName = narrowFrom.getClass().getName();
        String toClassName = narrowTo.getName();
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.finer(String.format("narrow %s => %s", fromClassName, toClassName));
        }
        if (!(narrowFrom instanceof ObjectImpl)) {
            throw new ClassCastException(String.format("object to narrow (runtime type %s) is not an instance of %s", fromClassName, ObjectImpl.class.getName()));
        }
        if (!narrowTo.isInterface()) {
            throw new ClassCastException(String.format("%s is not an interface", toClassName));
        }
        boolean isRemote = Remote.class.isAssignableFrom(narrowTo);
        boolean isIDLEntity = IDLEntity.class.isAssignableFrom(narrowTo);
        if (isRemote && isIDLEntity) {
            throw new ClassCastException(String.format("%s invalidly extends both %s and %s", toClassName, Remote.class.getName(), IDLEntity.class.getName()));
        }
        if (isRemote) {
            return this.narrowRMI((ObjectImpl)narrowFrom, narrowTo);
        }
        if (isIDLEntity) {
            return this.narrowIDL((ObjectImpl)narrowFrom, narrowTo);
        }
        throw new ClassCastException(String.format("%s extends neither %s nor %s", toClassName, Remote.class.getName(), IDLEntity.class.getName()));
    }

    static Remote narrow1(RMIState state, ObjectImpl object, Class<?> narrowTo) throws ClassCastException {
        Delegate delegate;
        Stub stub;
        try {
            stub = PortableRemoteObjectImpl.createStub(state, narrowTo);
        }
        catch (NoClassDefFoundError ex) {
            throw (ClassCastException)Exceptions.as(ClassCastException::new, (Throwable)ex, (java.lang.Object)narrowTo.getName());
        }
        try {
            delegate = object._get_delegate();
        }
        catch (BAD_OPERATION ex) {
            delegate = null;
        }
        stub._set_delegate(delegate);
        return (Remote)stub;
    }

    private static Stub createStub(RMIState state, Class<?> type) {
        Stub stub;
        if (Remote.class == type) {
            return new RMIRemoteStub();
        }
        if (ClientUtil.isRunningAsClientContainer() && (stub = state.getStaticStub(null, type)) != null) {
            return stub;
        }
        return PortableRemoteObjectImpl.createRMIStub(state, type);
    }

    static Stub createRMIStub(RMIState state, Class<?> type) {
        if (!type.isInterface()) {
            throw new RuntimeException("non-interfaces not supported");
        }
        LOGGER.fine("Creating RMI stub for class " + type.getName());
        Constructor<? extends Stub> cons = PortableRemoteObjectImpl.getRMIStubClassConstructor(state, type);
        try {
            return cons.newInstance(new java.lang.Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException ex) {
            throw new RuntimeException("internal problem: cannot instantiate stub", ex);
        }
    }

    static Constructor<? extends Stub> getRMIStubClassConstructor(RMIState state, Class<?> type) {
        Class stubClass;
        LOGGER.fine("Requesting stub constructor of class " + type.getName());
        Constructor<java.lang.Object> cons = state.stub_map.get(type);
        if (cons != null) {
            LOGGER.fine("Returning cached constructor of class " + cons.getDeclaringClass().getName());
            return cons;
        }
        ClassLoader loader = (ClassLoader)AccessController.doPrivileged(PrivilegedActions.getClassLoader(type));
        ClassLoader contextLoader = (ClassLoader)AccessController.doPrivileged(PrivilegedActions.GET_CONTEXT_CLASS_LOADER);
        LOGGER.finer("TYPE ----> " + type);
        LOGGER.finer("LOADER --> " + loader);
        LOGGER.finer("CONTEXT -> " + contextLoader);
        RemoteInterfaceDescriptor desc = state.repo.getRemoteInterface(type);
        MethodDescriptor[] descriptors = desc.getMethods();
        Stream<Method> methodStream = Arrays.stream(descriptors).map(MethodDescriptor::getReflectedMethod).peek(m -> LOGGER.finer("Method ----> " + m));
        MethodRef[] methods = (MethodRef[])Stream.concat(methodStream, Stream.of(StubWriteReplaceMethodHolder.STUB_WRITE_REPLACE_METHOD)).map(MethodRef::new).toArray(MethodRef[]::new);
        try {
            stubClass = StubClass.make(type, descriptors, methods, loader);
        }
        catch (NoClassDefFoundError ex) {
            try {
                stubClass = StubClass.make(type, descriptors, methods, contextLoader);
            }
            catch (NoClassDefFoundError e) {
                e.addSuppressed(ex);
                throw e;
            }
        }
        if (stubClass != null) {
            try {
                cons = stubClass.getConstructor(new Class[0]);
                state.stub_map.put(type, cons);
            }
            catch (NoSuchMethodException e) {
                LOGGER.log(Level.FINER, "constructed stub has no default constructor", e);
            }
        }
        return cons;
    }

    public Remote toStub(Remote value) throws NoSuchObjectException {
        if (value instanceof Stub) {
            return value;
        }
        Tie tie = Util.getTie((Remote)value);
        if (tie == null) {
            throw new NoSuchObjectException("object not exported");
        }
        RMIServant servant = (RMIServant)tie;
        try {
            POA poa = servant.getRMIState().getPOA();
            Object ref = poa.servant_to_reference((Servant)servant);
            return (Remote)this.narrow(ref, servant.getJavaClass());
        }
        catch (ServantNotActive | WrongPolicy ex) {
            throw new RuntimeException("internal error: " + ex.getMessage(), ex);
        }
    }

    public void exportObject(Remote obj) throws RemoteException {
        RMIState state = RMIState.current();
        try {
            state.checkShutDown();
        }
        catch (BAD_INV_ORDER ex) {
            throw new RemoteException("RMIState is deactivated", ex);
        }
        Tie tie = Util.getTie((Remote)obj);
        if (tie != null) {
            throw new RemoteException("object already exported");
        }
        RMIServant servant = new RMIServant(state);
        Util.registerTarget((Tie)servant, (Remote)obj);
        LOGGER.finer("exporting instance of " + obj.getClass().getName() + " in " + state.getName());
        try {
            servant._id = state.getPOA().activate_object((Servant)servant);
        }
        catch (ServantAlreadyActive | WrongPolicy ex) {
            throw new RemoteException("internal error: " + ex.getMessage(), ex);
        }
    }

    public void unexportObject(Remote obj) throws NoSuchObjectException {
        Util.unexportObject((Remote)obj);
    }

    static enum StubWriteReplaceMethodHolder {

        static final Method STUB_WRITE_REPLACE_METHOD;

        static {
            try {
                STUB_WRITE_REPLACE_METHOD = (Method)AccessController.doPrivileged(PrivilegedActions.getDeclaredMethod(RMIStub.class, (String)"writeReplace", (Class[])new Class[0]));
            }
            catch (PrivilegedActionException ex) {
                throw (Error)VerboseLogging.wrapped((Logger)LOGGER, (Throwable)ex, (String)("cannot initialize: \n" + ex.getMessage()), e -> new Error((Throwable)e));
            }
        }
    }
}

