/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.stack.transport.netty;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.websphere.channelfw.EndPointInfo;
import com.ibm.websphere.channelfw.EndPointMgr;
import com.ibm.ws.sip.stack.transport.ActiveConfiguration;
import com.ibm.ws.sip.stack.transport.GenericChainBase;
import com.ibm.ws.sip.stack.transport.GenericEndpointImpl;
import com.ibm.ws.sip.stack.transport.netty.GenericChain;
import com.ibm.ws.sip.stack.transport.netty.SipMessageBufferStreamDecoder;
import com.ibm.ws.sip.stack.transport.netty.SipStreamHandler;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslHandler;
import io.openliberty.netty.internal.ChannelInitializerWrapper;
import io.openliberty.netty.internal.NettyFramework;
import io.openliberty.netty.internal.exception.NettyException;
import jain.protocol.ip.sip.ListeningPoint;
import java.util.HashMap;
import java.util.Map;

public class GenericTCPChain
extends GenericChain {
    private static final LogMgr c_logger = Log.get(GenericTCPChain.class);
    private final boolean isTLS;
    private String tcpName;
    private String tlsName;
    SslContext context;

    public GenericTCPChain(GenericEndpointImpl owner, boolean isTls) {
        super(owner);
        this.isTLS = isTls;
    }

    @Override
    public void init(String endpointId, Object componentId, NettyFramework nfBundle, String name) {
        String commmonName;
        String root = "TCP" + (this.isTLS ? "-ssl" : "");
        this.tcpName = commmonName = root + "_" + name + "_" + endpointId;
        this.tlsName = "TLS-" + commmonName;
        super.init(endpointId, componentId, nfBundle, name);
    }

    @Override
    protected ActiveConfiguration createActiveConfiguration() {
        Map<String, Object> map;
        this.getOwner();
        Map<String, Object> tcpOptions = GenericEndpointImpl.getTcpOptions();
        if (this.isTLS) {
            this.getOwner();
            map = GenericEndpointImpl.getSslOptions();
        } else {
            map = null;
        }
        Map<String, Object> sslOptions = map;
        Map<String, Object> endpointOptions = this.getOwner().getEndpointOptions();
        return new ActiveConfiguration(this.isTLS, tcpOptions, sslOptions, endpointOptions, this);
    }

    @Override
    protected void rebuildTheChannel(ActiveConfiguration oldConfig, ActiveConfiguration newConfig) {
    }

    @Override
    public String getName() {
        return this.tcpName;
    }

    @Override
    public void setupEventProps(Map<String, Object> eventProps) {
        eventProps.put("isTls", this.isTLS);
    }

    @Override
    public GenericChainBase.Type getType() {
        return this.isTLS ? GenericChainBase.Type.TLS : GenericChainBase.Type.TCP;
    }

    @Override
    public String getTransport() {
        return this.isTLS ? "tls" : "tcp";
    }

    @Override
    public synchronized void update() {
        block3: {
            super.update();
            if (this.currentConfig.validConfiguration) {
                EndPointMgr em = this.nettyBundle.getEndpointManager();
                EndPointInfo ep = em.getEndPoint(this.getEndpointName());
                ep = em.defineEndPoint(this.getEndpointName(), this.currentConfig.configHost, this.currentConfig.configPort);
                ListeningPoint lp = this.sipInboundChannelFactory.initChannel(this);
                try {
                    HashMap<String, Object> options = new HashMap<String, Object>();
                    options.putAll(this.getCurrentConfig().tcpOptions);
                    options.put("ExternalName", this.getName());
                    this.serverBootstrap = this.nettyBundle.createTCPBootstrapInbound(options);
                    this.serverBootstrap.childHandler((ChannelHandler)new SipTCPInitializer(this.serverBootstrap.getBaseInitializer()));
                    this.nettyBundle.startInbound(this.serverBootstrap, ep.getHost(), ep.getPort(), future -> {
                        if (future.isSuccess()) {
                            if (c_logger.isTraceDebugEnabled()) {
                                c_logger.traceDebug("SIP " + (this.isTLS ? "TLS" : "TCP") + " endpoint start success");
                            }
                        } else if (c_logger.isTraceDebugEnabled()) {
                            c_logger.traceDebug("SIP " + (this.isTLS ? "TLS" : "TCP") + " endpoint start failure: " + future.cause());
                        }
                    });
                }
                catch (NettyException e2) {
                    if (!c_logger.isTraceDebugEnabled()) break block3;
                    c_logger.traceDebug("Exception creating " + (this.isTLS ? "TLS" : "TCP") + " bootstrap: " + (Object)((Object)e2));
                }
            }
        }
    }

    private class SipTCPInitializer
    extends ChannelInitializerWrapper {
        final ChannelInitializerWrapper parent;

        public SipTCPInitializer(ChannelInitializerWrapper parent) {
            this.parent = parent;
        }

        protected void initChannel(Channel ch) throws Exception {
            this.parent.init(ch);
            ChannelPipeline pipeline = ch.pipeline();
            if (GenericTCPChain.this.isTLS) {
                EndPointInfo ep = GenericTCPChain.this.nettyBundle.getEndpointManager().getEndPoint(GenericTCPChain.this.getEndpointName());
                SslHandler handler = GenericEndpointImpl.getTlsProvider().getInboundSSLContext(GenericTCPChain.this.currentConfig.sslOptions, ep.getHost(), Integer.toString(ep.getPort()), ch);
                pipeline.addFirst("ssl", (ChannelHandler)handler);
            }
            pipeline.addLast("decoder", (ChannelHandler)new SipMessageBufferStreamDecoder());
            pipeline.addLast("handler", (ChannelHandler)new SipStreamHandler());
        }
    }
}

