/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.stack.transaction.transport.connections;

import com.ibm.ws.jain.protocol.ip.sip.message.MessageImpl;
import com.ibm.ws.sip.parser.util.CharsBuffer;
import com.ibm.ws.sip.parser.util.CharsBuffersPool;
import com.ibm.ws.sip.parser.util.ObjectPool;
import jain.protocol.ip.sip.SipException;
import jain.protocol.ip.sip.message.Message;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class SipMessageByteBuffer {
    public static final int BUF_SIZE = 4096;
    private byte[] m_bytes = new byte[4096];
    private int m_markedBytesNumber = 0;
    private int m_position = 0;
    private static ObjectPool s_bufferPool = new ObjectPool(SipMessageByteBuffer.class);

    public static SipMessageByteBuffer fromPool() {
        SipMessageByteBuffer buf = (SipMessageByteBuffer)s_bufferPool.get();
        return buf;
    }

    public static SipMessageByteBuffer fromNetwork(byte[] bytes, int length, String peerHost, int peerPort) {
        SipMessageByteBuffer buf = SipMessageByteBuffer.fromPool();
        buf.put(bytes, 0, length);
        return buf;
    }

    public static SipMessageByteBuffer fromMessage(Message msg, MessageImpl.HeaderForm headerForm) throws SipException {
        if (!(msg instanceof MessageImpl)) {
            throw new SipException("attempt to serialize message from a different JAIN implementation");
        }
        MessageImpl msgImpl = (MessageImpl)msg;
        SipMessageByteBuffer buf = SipMessageByteBuffer.fromPool();
        if (buf.m_markedBytesNumber != 0) {
            throw new SipException("attempt to use pre-allocated byte buffer");
        }
        byte[] bodyPart = msg.getBodyAsBytes();
        CharsBuffer headerPartBuffer = CharsBuffersPool.getBuffer();
        msgImpl.writeHeadersToBuffer(headerPartBuffer, headerForm, true);
        byte[] headerPart = headerPartBuffer.getBytes();
        int headerPartLength = headerPartBuffer.getBytesSize();
        buf.put(headerPart, 0, headerPartLength);
        if (bodyPart != null) {
            buf.put(bodyPart, 0, bodyPart.length);
        }
        CharsBuffersPool.putBufferBack(headerPartBuffer);
        return buf;
    }

    public static SipMessageByteBuffer fromStream(ObjectInput in) throws IOException {
        SipMessageByteBuffer buf = SipMessageByteBuffer.fromPool();
        int length = in.readInt();
        buf.ensureCapacity(length);
        byte[] dest = buf.getBytes();
        in.readFully(dest, 0, length);
        buf.m_markedBytesNumber = length;
        return buf;
    }

    public void toStream(ObjectOutput out) throws IOException {
        out.writeInt(this.m_markedBytesNumber);
        out.write(this.m_bytes, 0, this.m_markedBytesNumber);
        out.flush();
        this.m_position = this.m_markedBytesNumber;
    }

    public byte[] getBytes() {
        return this.m_bytes;
    }

    public int getMarkedBytesNumber() {
        return this.m_markedBytesNumber;
    }

    public void reset() {
        this.init();
        s_bufferPool.putBack(this);
    }

    public void init() {
        this.m_markedBytesNumber = 0;
        this.m_position = 0;
    }

    public void rewind() {
        this.rewind(0);
    }

    public void rewind(int position) {
        this.m_position = position;
    }

    public int getReadPos() {
        return this.m_position;
    }

    public int getRemaining() {
        return this.m_markedBytesNumber - this.m_position;
    }

    public byte lookahead(int distance) {
        int pos = this.m_position + distance - 1;
        return this.m_bytes[pos];
    }

    public boolean hasMore() {
        return this.m_position < this.m_markedBytesNumber;
    }

    public boolean hasMore(int count) {
        return this.m_position + count <= this.m_markedBytesNumber;
    }

    public byte get() {
        if (this.m_position >= this.m_markedBytesNumber) {
            throw new IndexOutOfBoundsException();
        }
        return this.m_bytes[this.m_position++];
    }

    public void copyTo(byte[] dest, int offset, int length) {
        if (this.m_position + length > this.m_markedBytesNumber) {
            throw new IndexOutOfBoundsException();
        }
        System.arraycopy(this.m_bytes, this.m_position, dest, offset, length);
        this.m_position += length;
    }

    public void put(byte b) {
        this.ensureCapacity(1);
        this.m_bytes[this.m_markedBytesNumber++] = b;
    }

    public void put(byte[] src, int offset, int length) {
        this.ensureCapacity(length);
        System.arraycopy(src, offset, this.m_bytes, this.m_markedBytesNumber, length);
        this.m_markedBytesNumber += length;
    }

    public void ensureCapacity(int length) {
        if (this.m_markedBytesNumber + length > this.m_bytes.length) {
            int newSize = this.m_markedBytesNumber + length;
            int bits = 0;
            while (newSize > 0) {
                newSize /= 2;
                ++bits;
            }
            newSize = 1 << bits;
            byte[] newBuf = new byte[newSize];
            System.arraycopy(this.m_bytes, 0, newBuf, 0, this.m_markedBytesNumber);
            this.m_bytes = newBuf;
        }
    }

    public void setContentSize(int size) {
        this.m_markedBytesNumber = size;
    }
}

