/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.security.auth;

import com.ibm.ws.common.crypto.CryptoUtils;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class ThreadLocalStorage {
    private static ThreadLocal _msgDigest = new ThreadLocal();

    private static MessageDigest createMsgDigest() {
        MessageDigest digester = null;
        try {
            digester = CryptoUtils.isFips140_3Enabled() ? MessageDigest.getInstance("SHA256") : MessageDigest.getInstance("MD5");
            _msgDigest.set(digester);
        }
        catch (NoSuchAlgorithmException e2) {
            e2.printStackTrace();
        }
        return digester;
    }

    public static MessageDigest getMessageDigest() {
        MessageDigest digester = (MessageDigest)_msgDigest.get();
        if (digester == null) {
            digester = ThreadLocalStorage.createMsgDigest();
        }
        return digester;
    }
}

