/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jain.protocol.ip.sip.address;

import com.ibm.ws.jain.protocol.ip.sip.address.NameAddressImpl;
import com.ibm.ws.jain.protocol.ip.sip.address.SipURLImpl;
import com.ibm.ws.jain.protocol.ip.sip.header.ParametersImpl;
import com.ibm.ws.sip.parser.URIParser;
import jain.protocol.ip.sip.SipException;
import jain.protocol.ip.sip.SipParseException;
import jain.protocol.ip.sip.address.AddressFactory;
import jain.protocol.ip.sip.address.NameAddress;
import jain.protocol.ip.sip.address.SipURL;
import jain.protocol.ip.sip.address.URI;
import java.net.InetAddress;
import java.util.Hashtable;
import java.util.Map;

public class AddressFactoryImpl
implements AddressFactory {
    public static int s_sipurl_cache_init_size = 1000;
    public static int s_sipurl_cache_max_size = 3000;
    private static float SIPRL_CACHE_LOAD_FACTOR = 0.75f;
    private static Map m_sipurlLRUCache = null;
    private final ThreadLocal<URIParser> m_uriParser = new ThreadLocal<URIParser>(){

        @Override
        protected URIParser initialValue() {
            return new URIParser();
        }
    };

    public static SipURL createSipURL(String schema, String username, String passwd, String hostname, int hostport, ParametersImpl optionalParams, ParametersImpl optionalHeaders, String userType, String transport) throws SipParseException {
        SipURLImpl impl = new SipURLImpl();
        if (schema != null) {
            impl.setScheme(schema);
        }
        if (username != null) {
            impl.setUserName(username);
        }
        if (passwd != null) {
            try {
                impl.setUserPassword(passwd);
            }
            catch (SipException e2) {
                throw new SipParseException(e2.getMessage());
            }
        }
        if (hostname != null) {
            impl.setHost(hostname);
        }
        if (hostport > 0) {
            impl.setPort(hostport);
        }
        if (optionalParams != null) {
            impl.setParameters(optionalParams);
        }
        if (optionalHeaders != null) {
            impl.setHeaders(optionalHeaders);
        }
        if (userType != null) {
            impl.setUserType(userType);
        }
        if (transport != null) {
            impl.setTransport(transport);
        }
        return impl;
    }

    @Override
    public SipURL createSipURL(InetAddress host) throws IllegalArgumentException, SipParseException {
        if (host == null) {
            throw new IllegalArgumentException("Address Factory: Null host");
        }
        return this.createSipURL(host.getHostName());
    }

    @Override
    public SipURL createSipURL(String host) throws IllegalArgumentException, SipParseException {
        if (host == null) {
            throw new IllegalArgumentException("Address Factory: Null host");
        }
        SipURLImpl impl = new SipURLImpl();
        impl.setHost(host);
        return impl;
    }

    @Override
    public SipURL createSipURL(String user, InetAddress host) throws IllegalArgumentException, SipParseException {
        if (user == null) {
            throw new IllegalArgumentException("Address Factory: null user");
        }
        if (host == null) {
            throw new IllegalArgumentException("Address Factory: Null host");
        }
        return this.createSipURL(user, host.getHostName());
    }

    @Override
    public SipURL createSipURL(String user, String host) throws IllegalArgumentException, SipParseException {
        if (user == null) {
            throw new IllegalArgumentException("Address Factory: null user");
        }
        if (host == null) {
            throw new IllegalArgumentException("Address Factory: Null host");
        }
        SipURLImpl url = new SipURLImpl();
        url.setHost(host);
        url.setUserName(user);
        return url;
    }

    @Override
    public NameAddress createNameAddress(URI address) throws IllegalArgumentException {
        if (address == null) {
            throw new IllegalArgumentException("AddressFactory: null address");
        }
        NameAddressImpl nameAddress = new NameAddressImpl();
        nameAddress.setAddress(address);
        return nameAddress;
    }

    @Override
    public NameAddress createNameAddress(String displayName, URI address) throws IllegalArgumentException, SipParseException {
        if (address == null) {
            throw new IllegalArgumentException("AddressFactory: Null address");
        }
        if (displayName == null) {
            throw new IllegalArgumentException("AddressFactory: Null display name");
        }
        NameAddressImpl nameAddress = new NameAddressImpl();
        nameAddress.setAddress(address);
        nameAddress.setDisplayName(displayName);
        return nameAddress;
    }

    @Override
    public URI createURI(String scheme, String schemeData) throws IllegalArgumentException, SipParseException {
        if (scheme == null) {
            throw new IllegalArgumentException("AddressFactory: Null scheme");
        }
        if (schemeData == null) {
            throw new IllegalArgumentException("AddressFactory: Null schemeData");
        }
        URIParser uriParser = this.getParser();
        URI uri = uriParser.parse(scheme, schemeData);
        return uri;
    }

    private URIParser getParser() {
        URIParser uriParser = this.m_uriParser.get();
        return uriParser;
    }

    private static Map GetCache() {
        if (m_sipurlLRUCache == null) {
            m_sipurlLRUCache = new Hashtable(s_sipurl_cache_init_size, SIPRL_CACHE_LOAD_FACTOR);
        }
        return m_sipurlLRUCache;
    }

    private static void UpdateCache(Object key, Object value) {
        if (AddressFactoryImpl.GetCache().size() > s_sipurl_cache_max_size) {
            m_sipurlLRUCache = null;
        }
        AddressFactoryImpl.GetCache().put(key, value);
    }
}

