/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.openapi.impl.parser;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.microprofile.openapi.impl.parser.ObjectMapperFactory;
import com.ibm.ws.microprofile.openapi.impl.parser.OpenAPIResolver;
import com.ibm.ws.microprofile.openapi.impl.parser.core.extensions.SwaggerParserExtension;
import com.ibm.ws.microprofile.openapi.impl.parser.core.models.AuthorizationValue;
import com.ibm.ws.microprofile.openapi.impl.parser.core.models.ParseOptions;
import com.ibm.ws.microprofile.openapi.impl.parser.core.models.SwaggerParseResult;
import com.ibm.ws.microprofile.openapi.impl.parser.util.ClasspathHelper;
import com.ibm.ws.microprofile.openapi.impl.parser.util.InlineModelResolver;
import com.ibm.ws.microprofile.openapi.impl.parser.util.OpenAPIDeserializer;
import com.ibm.ws.microprofile.openapi.impl.parser.util.RemoteUrl;
import com.ibm.ws.microprofile.openapi.impl.parser.util.ResolverFully;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.File;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import javax.net.ssl.SSLHandshakeException;
import org.apache.commons.io.FileUtils;
import org.eclipse.microprofile.openapi.models.OpenAPI;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class OpenAPIV3Parser
implements SwaggerParserExtension {
    private static ObjectMapper JSON_MAPPER;
    private static ObjectMapper YAML_MAPPER;
    static final long serialVersionUID = 5090623444583750531L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    /*
     * WARNING - void declaration
     */
    @Override
    public SwaggerParseResult readLocation(String url, List<AuthorizationValue> auth, ParseOptions options) {
        SwaggerParseResult result = new SwaggerParseResult();
        try {
            result = this.readWithInfo(url, auth);
            if (result.getOpenAPI() != null) {
                String version = result.getOpenAPI().getOpenapi();
                if (auth == null) {
                    auth = new ArrayList<AuthorizationValue>();
                }
                if (version != null && version.startsWith("3.0") && options != null) {
                    OpenAPIResolver resolver = new OpenAPIResolver(result.getOpenAPI(), auth, null);
                    if (options.isResolve()) {
                        result.setOpenAPI(resolver.resolve());
                    }
                    if (options.isResolveFully()) {
                        result.setOpenAPI(resolver.resolve());
                        new ResolverFully(options.isResolveCombinators()).resolveFully(result.getOpenAPI());
                    } else if (options.isFlatten()) {
                        InlineModelResolver inlineResolver = new InlineModelResolver();
                        inlineResolver.flatten(result.getOpenAPI());
                    }
                }
            }
        }
        catch (Exception version) {
            void e;
            FFDCFilter.processException((Throwable)version, (String)"com.ibm.ws.microprofile.openapi.impl.parser.OpenAPIV3Parser", (String)"83", (Object)this, (Object[])new Object[]{url, auth, options});
            result.setMessages(Arrays.asList(e.getMessage()));
        }
        return result;
    }

    public OpenAPI read(String location) {
        ParseOptions options = new ParseOptions();
        options.setResolve(true);
        return this.read(location, null, options);
    }

    public OpenAPI read(String location, List<AuthorizationValue> auths, ParseOptions resolve) {
        if (location == null) {
            return null;
        }
        location = location.replaceAll("\\\\", "/");
        List<SwaggerParserExtension> parserExtensions = this.getExtensions();
        for (SwaggerParserExtension extension : parserExtensions) {
            OpenAPI output = extension.readLocation(location, auths, resolve).getOpenAPI();
            if (output == null) continue;
            return output;
        }
        return null;
    }

    public SwaggerParseResult readWithInfo(JsonNode node) {
        OpenAPIDeserializer ser = new OpenAPIDeserializer();
        return ser.deserialize(node, null);
    }

    private ObjectMapper getRightMapper(String data) {
        ObjectMapper mapper = data.trim().startsWith("{") ? JSON_MAPPER : YAML_MAPPER;
        return mapper;
    }

    public SwaggerParseResult readWithInfo(String location, List<AuthorizationValue> auths) {
        try {
            String data;
            location = location.replaceAll("\\\\", "/");
            if (location.toLowerCase().startsWith("http")) {
                data = RemoteUrl.urlToString(location, auths);
            } else {
                String fileScheme = "file:";
                Path path = location.toLowerCase().startsWith("file:") ? Paths.get(URI.create(location)) : Paths.get(location, new String[0]);
                data = Files.exists(path, new LinkOption[0]) ? FileUtils.readFileToString((File)path.toFile(), (Charset)StandardCharsets.UTF_8) : ClasspathHelper.loadFileFromClasspath(location);
            }
            ObjectMapper mapper = this.getRightMapper(data);
            JsonNode rootNode = mapper.readTree(data);
            return this.readWithInfo(rootNode);
        }
        catch (SSLHandshakeException mapper) {
            FFDCFilter.processException((Throwable)mapper, (String)"com.ibm.ws.microprofile.openapi.impl.parser.OpenAPIV3Parser", (String)"153", (Object)this, (Object[])new Object[]{location, auths});
            SwaggerParseResult output = new SwaggerParseResult();
            output.setMessages(Arrays.asList("unable to read location `" + location + "` due to a SSL configuration error.  It is possible that the server SSL certificate is invalid, self-signed, or has an untrusted Certificate Authority."));
            return output;
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.microprofile.openapi.impl.parser.OpenAPIV3Parser", (String)"159", (Object)this, (Object[])new Object[]{location, auths});
            SwaggerParseResult output = new SwaggerParseResult();
            output.setMessages(Arrays.asList("unable to read location `" + location + "`"));
            return output;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public SwaggerParseResult readContents(String swaggerAsString, OpenAPI startingModel, List<AuthorizationValue> auth, ParseOptions options) {
        SwaggerParseResult result = new SwaggerParseResult();
        if (swaggerAsString != null && !"".equals(swaggerAsString.trim())) {
            ObjectMapper mapper = this.getRightMapper(swaggerAsString);
            if (auth == null) {
                auth = new ArrayList<AuthorizationValue>();
            }
            if (options != null) {
                if (options.isResolve()) {
                    try {
                        OpenAPIDeserializer deserializer = new OpenAPIDeserializer();
                        JsonNode rootNode = mapper.readTree(swaggerAsString.getBytes());
                        result = deserializer.deserialize(rootNode, startingModel);
                        OpenAPIResolver resolver = new OpenAPIResolver(result.getOpenAPI(), auth, null);
                        result.setOpenAPI(resolver.resolve());
                    }
                    catch (Exception deserializer) {
                        void e;
                        FFDCFilter.processException((Throwable)deserializer, (String)"com.ibm.ws.microprofile.openapi.impl.parser.OpenAPIV3Parser", (String)"184", (Object)this, (Object[])new Object[]{swaggerAsString, startingModel, auth, options});
                        result.setMessages(Arrays.asList(e.getMessage()));
                    }
                } else {
                    try {
                        JsonNode rootNode = mapper.readTree(swaggerAsString.getBytes());
                        result = new OpenAPIDeserializer().deserialize(rootNode, startingModel);
                    }
                    catch (Exception rootNode) {
                        void e;
                        FFDCFilter.processException((Throwable)rootNode, (String)"com.ibm.ws.microprofile.openapi.impl.parser.OpenAPIV3Parser", (String)"192", (Object)this, (Object[])new Object[]{swaggerAsString, startingModel, auth, options});
                        result.setMessages(Arrays.asList(e.getMessage()));
                    }
                }
                if (options.isResolveFully()) {
                    result.setOpenAPI(new OpenAPIResolver(result.getOpenAPI(), auth, null).resolve());
                    new ResolverFully(options.isResolveCombinators()).resolveFully(result.getOpenAPI());
                }
                if (options.isFlatten()) {
                    new InlineModelResolver().flatten(result.getOpenAPI());
                }
            } else {
                try {
                    JsonNode rootNode = mapper.readTree(swaggerAsString.getBytes());
                    result = new OpenAPIDeserializer().deserialize(rootNode, startingModel);
                }
                catch (Exception rootNode) {
                    void e;
                    FFDCFilter.processException((Throwable)rootNode, (String)"com.ibm.ws.microprofile.openapi.impl.parser.OpenAPIV3Parser", (String)"209", (Object)this, (Object[])new Object[]{swaggerAsString, startingModel, auth, options});
                    result.setMessages(Arrays.asList(e.getMessage()));
                }
            }
        } else {
            result.setMessages(Arrays.asList("No swagger supplied"));
        }
        return result;
    }

    protected List<SwaggerParserExtension> getExtensions() {
        ArrayList<SwaggerParserExtension> extensions = new ArrayList<SwaggerParserExtension>();
        ServiceLoader<SwaggerParserExtension> loader = ServiceLoader.load(SwaggerParserExtension.class);
        Iterator<SwaggerParserExtension> itr = loader.iterator();
        while (itr.hasNext()) {
            extensions.add(itr.next());
        }
        extensions.add(0, new OpenAPIV3Parser());
        return extensions;
    }

    protected List<AuthorizationValue> transform(List<AuthorizationValue> input) {
        if (input == null) {
            return null;
        }
        ArrayList<AuthorizationValue> output = new ArrayList<AuthorizationValue>();
        for (AuthorizationValue value : input) {
            AuthorizationValue v = new AuthorizationValue();
            v.setKeyName(value.getKeyName());
            v.setValue(value.getValue());
            v.setType(value.getType());
            output.add(v);
        }
        return output;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.microprofile.openapi.impl.parser.OpenAPIV3Parser", OpenAPIV3Parser.class, (String)"MPOPENAPI", (String)"io.openliberty.microprofile.openapi.internal.resources.OpenAPI");
        JSON_MAPPER = ObjectMapperFactory.createJson();
        YAML_MAPPER = ObjectMapperFactory.createYaml();
    }
}

