/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.utils.am;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ejs.util.am.Alarm;
import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.processor.impl.MessageProcessor;
import com.ibm.ws.sib.processor.impl.interfaces.StoppableThread;
import com.ibm.ws.sib.processor.utils.StoppableThreadCache;
import com.ibm.ws.sib.processor.utils.am.GroupAlarmListener;
import com.ibm.ws.sib.processor.utils.am.MPAlarmImpl;
import com.ibm.ws.sib.processor.utils.am.MPAlarmThread;
import com.ibm.ws.sib.processor.utils.linkedlist.LinkedList;
import com.ibm.ws.sib.utils.SIBUuid12;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.ws.util.ObjectPool;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

public class MPAlarmManager
implements StoppableThread {
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceComponent tc = SibTr.register(MPAlarmManager.class, (String)"SIBUtils", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private boolean _cancelAll = false;
    private long _nextAlarm = Long.MAX_VALUE;
    private MPAlarmThread _alarmThread;
    private LinkedList _pendingAlarms;
    private LinkedList _firedAlarms;
    private Object _firedAlarmsLock = new Object();
    private Object _pendingAlarmsLock = new Object();
    private ObjectPool _alarmPool;
    private int _percentLateDefault = 50;
    private long _batchAlarmTime = -1L;
    private HashMap<SIBUuid12, AlarmListener> _groupListeners;
    private String _meName = null;
    private long index = 0L;

    public MPAlarmManager(MessageProcessor mp, int percentLateDefault, int alarmPoolSize) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"MPAlarmManager", (Object)new Object[]{mp, percentLateDefault, alarmPoolSize});
        }
        this.index = 0L;
        this._pendingAlarms = new LinkedList();
        this._firedAlarms = new LinkedList();
        this._percentLateDefault = percentLateDefault;
        this._alarmPool = new ObjectPool("MPAlarmPool", alarmPoolSize);
        this._groupListeners = new HashMap();
        this._alarmThread = new MPAlarmThread(this);
        this._meName = mp.getMessagingEngineName();
        try {
            mp.startNewSystemThread(this._alarmThread);
        }
        catch (InterruptedException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.utils.am.MPAlarmManager", (String)"1:207:1.28", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)e);
        }
        mp.getStoppableThreadCache().registerThread(this);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"MPAlarmManager", (Object)this);
        }
    }

    public int getPercentLateDefault() {
        return this._percentLateDefault;
    }

    public Alarm create(long delta, AlarmListener listener) {
        return this.create(delta, this._percentLateDefault, listener, null);
    }

    public Alarm create(long delta, AlarmListener listener, Object context) {
        return this.create(delta, this._percentLateDefault, listener, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Alarm create(long delta, int percentLate, AlarmListener listener, Object context) throws SIErrorException {
        long time;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"create", (Object)new Object[]{this, delta, percentLate, listener, context});
        }
        if ((time = System.currentTimeMillis() + delta) < 0L) {
            SIErrorException e = new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.utils.am.MPAlarmManager", "1:269:1.28"}, null));
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.utils.am.MPAlarmManager.create", (String)"1:274:1.28", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0001", (Object)new Object[]{"com.ibm.ws.sib.processor.utils.am.MPAlarmManager", "1:280:1.28"});
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"MPAlarmManager", (Object)((Object)e));
            }
            throw e;
        }
        long latest = time + delta / 100L * (long)percentLate;
        MPAlarmImpl alarm = (MPAlarmImpl)this._alarmPool.remove();
        if (alarm == null) {
            alarm = new MPAlarmImpl(time, latest, listener, context, this.index++);
        } else {
            alarm.reset(time, latest, listener, context, this.index++);
        }
        Object object = this._pendingAlarmsLock;
        synchronized (object) {
            MPAlarmImpl insertPoint = (MPAlarmImpl)this._pendingAlarms.getLast();
            if (insertPoint == null) {
                this._pendingAlarms.put(alarm);
            } else {
                if (insertPoint.time() > time) {
                    while ((insertPoint = insertPoint.previous()) != null && insertPoint.time() > time) {
                    }
                }
                if (insertPoint == null) {
                    this._pendingAlarms.insertAtTop(alarm);
                } else {
                    this._pendingAlarms.insertAfter(alarm, insertPoint);
                }
            }
            if (this._nextAlarm == Long.MAX_VALUE || time < this._nextAlarm) {
                this._nextAlarm = time;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                long now = System.currentTimeMillis();
                SibTr.debug((TraceComponent)tc, (String)("now " + now + "Alarm Start : " + listener + " - " + (time - now) + " (" + (latest - now) + ")"));
                SibTr.debug((TraceComponent)tc, (String)("" + this._pendingAlarms));
            }
        }
        this._alarmThread.requestNextWakeup(this._nextAlarm);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"create", (Object)alarm);
        }
        return alarm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void cancelAll() {
        MPAlarmImpl next;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"cancelAll", (Object)this);
        }
        this._cancelAll = true;
        LinkedList oldPendingList = null;
        LinkedList oldFiredList = null;
        Object object = this._firedAlarmsLock;
        synchronized (object) {
            Object object2 = this._pendingAlarmsLock;
            synchronized (object2) {
                oldPendingList = this._pendingAlarms;
                this._pendingAlarms = new LinkedList();
                oldFiredList = this._firedAlarms;
                this._firedAlarms = new LinkedList();
                this._nextAlarm = Long.MAX_VALUE;
                this._cancelAll = false;
            }
        }
        MPAlarmImpl alarm = (MPAlarmImpl)oldPendingList.getFirst();
        while (alarm != null) {
            next = alarm.next();
            alarm.cancel();
            oldPendingList.remove(alarm);
            this._alarmPool.add((Object)alarm);
            alarm = next;
        }
        alarm = (MPAlarmImpl)oldFiredList.getFirst();
        while (alarm != null) {
            next = alarm.next();
            alarm.cancel();
            oldFiredList.remove(alarm);
            this._alarmPool.add((Object)alarm);
            alarm = next;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"cancelAll");
        }
    }

    @Override
    public void stopThread(StoppableThreadCache threadCache) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"stopThread");
        }
        this.cancelAll();
        this._alarmThread.finishAlarmThread();
        threadCache.deregisterThread(this);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"stopThread");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireInternalAlarm() {
        long now = System.currentTimeMillis();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"fireInternalAlarm", (Object)new Object[]{this, now});
        }
        Object object = this._firedAlarmsLock;
        synchronized (object) {
            MPAlarmImpl alarm;
            Object object2 = this._pendingAlarmsLock;
            synchronized (object2) {
                alarm = (MPAlarmImpl)this._pendingAlarms.getFirst();
                while (!(this._cancelAll || alarm == null || alarm.time() > now && alarm.time() > this._batchAlarmTime)) {
                    this._pendingAlarms.remove(alarm);
                    this._firedAlarms.put(alarm);
                    if (this._batchAlarmTime == -1L || alarm.latest() < this._batchAlarmTime) {
                        this._batchAlarmTime = alarm.latest();
                    }
                    alarm = (MPAlarmImpl)this._pendingAlarms.getFirst();
                }
                alarm = (MPAlarmImpl)this._firedAlarms.getLast();
                if (alarm != null && alarm.time() < this._batchAlarmTime) {
                    this._batchAlarmTime = alarm.time();
                }
            }
            if (now >= this._batchAlarmTime) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("Pending " + this._pendingAlarms));
                    SibTr.debug((TraceComponent)tc, (String)("Firing " + this._firedAlarms));
                }
                MPAlarmImpl alarm2 = (MPAlarmImpl)this._firedAlarms.getFirst();
                while (!this._cancelAll && alarm2 != null) {
                    this._firedAlarms.remove(alarm2);
                    AlarmListener alarmListener = alarm2.listener();
                    boolean alarmHasGroupListener = alarm2.hasGroupListener();
                    Object alarmContext = alarm2.context();
                    boolean alarmIsActive = alarm2.active();
                    if (alarmIsActive && alarmListener != null) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            SibTr.debug((TraceComponent)tc, (String)("Alarm Fire : " + alarm2));
                        }
                        if (!alarmHasGroupListener) {
                            try {
                                alarmListener.alarm(alarmContext);
                            }
                            catch (Throwable e) {
                                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.utils.am.MPAlarmManager.fireInternalAlarm", (String)"1:560:1.28", (Object[])new Object[]{this, alarmListener, alarmContext});
                                SibTr.exception((TraceComponent)tc, (Throwable)e);
                            }
                        } else if (!this._groupListeners.containsKey(((GroupAlarmListener)alarmListener).getGroupUuid())) {
                            this._groupListeners.put(((GroupAlarmListener)alarmListener).getGroupUuid(), alarmListener);
                            ((GroupAlarmListener)alarmListener).beginGroupAlarm(alarmContext);
                        } else {
                            ((GroupAlarmListener)alarmListener).addContext(alarmContext);
                        }
                        this._alarmPool.add((Object)alarm2);
                    }
                    alarm2 = (MPAlarmImpl)this._firedAlarms.getFirst();
                }
                if (this._groupListeners.size() > 0) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)("GroupListeners size is: " + this._groupListeners.size()));
                    }
                    Set<SIBUuid12> groupNames = this._groupListeners.keySet();
                    Iterator<SIBUuid12> itr = groupNames.iterator();
                    while (itr.hasNext()) {
                        GroupAlarmListener listener = (GroupAlarmListener)this._groupListeners.get(itr.next());
                        try {
                            listener.alarm(null);
                        }
                        catch (Throwable e) {
                            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.utils.am.MPAlarmManager.fireInternalAlarm", (String)"1:613:1.28", (Object[])new Object[]{this, listener});
                            SibTr.exception((TraceComponent)tc, (Throwable)e);
                        }
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)"Finished calling group alarms");
                    }
                    this._groupListeners.clear();
                }
                this._batchAlarmTime = -1L;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"About to get _pendingAlarmsLock");
            }
            object2 = this._pendingAlarmsLock;
            synchronized (object2) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"Got _pendingAlarmsLock");
                }
                this._nextAlarm = this._batchAlarmTime > -1L ? this._batchAlarmTime : ((alarm = (MPAlarmImpl)this._pendingAlarms.getFirst()) == null ? Long.MAX_VALUE : alarm.time());
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"fireInternalAlarm", (Object)this._nextAlarm);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getNextWakeup() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getNextWakeup");
        }
        Object object = this._pendingAlarmsLock;
        synchronized (object) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getNextWakeup", (Object)this._nextAlarm);
            }
            return this._nextAlarm;
        }
    }

    public String toString() {
        return super.toString() + " " + this._meName;
    }
}

