/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.impl;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.Reliability;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.websphere.sib.exception.SINotPossibleInCurrentConfigurationException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.sib.msgstore.LockingCursor;
import com.ibm.ws.sib.msgstore.MessageStoreException;
import com.ibm.ws.sib.processor.impl.AbstractConsumerKey;
import com.ibm.ws.sib.processor.impl.LocalQPConsumerKey;
import com.ibm.ws.sib.processor.impl.interfaces.ConsumableKey;
import com.ibm.ws.sib.processor.impl.interfaces.DispatchableConsumerPoint;
import com.ibm.ws.sib.processor.impl.interfaces.JSConsumerManager;
import com.ibm.ws.sib.processor.impl.interfaces.SIMPMessage;
import com.ibm.ws.sib.utils.SIBUuid12;
import com.ibm.ws.sib.utils.SIBUuid8;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.SelectionCriteria;
import java.util.HashMap;
import java.util.Iterator;

public class GatheringConsumerKey
extends AbstractConsumerKey {
    private static final TraceComponent tc = SibTr.register(GatheringConsumerKey.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    HashMap<SIBUuid8, ConsumableKey> consumerKeys;
    private JSConsumerManager dispatcher;
    private DispatchableConsumerPoint consumerPoint;
    private SIBUuid12 connectionUuid;
    private boolean forwardScanning;
    private SIBUuid8 lastDMERequestedUuid;
    boolean closed = false;
    boolean ready = false;
    private long outstandingRequestExpiryTime = -1L;
    private Reliability unrecoverable;

    public GatheringConsumerKey(DispatchableConsumerPoint consumerPoint, JSConsumerManager dispatcher, HashMap<SIBUuid8, ConsumableKey> consumerKeys, SelectionCriteria criteria, SIBUuid12 connectionUuid, boolean forwardScanning) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"GatheringConsumerKey", (Object)new Object[]{consumerPoint, dispatcher, consumerKeys, criteria, connectionUuid, forwardScanning});
        }
        this.dispatcher = dispatcher;
        this.consumerPoint = consumerPoint;
        this.connectionUuid = connectionUuid;
        this.forwardScanning = forwardScanning;
        this.consumerKeys = consumerKeys;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"GatheringConsumerKey", (Object)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void detach() throws SIResourceException, SINotPossibleInCurrentConfigurationException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"detach");
        }
        Iterator it = null;
        GatheringConsumerKey gatheringConsumerKey = this;
        synchronized (gatheringConsumerKey) {
            it = ((HashMap)this.consumerKeys.clone()).values().iterator();
        }
        while (it.hasNext()) {
            ((ConsumableKey)it.next()).detach();
        }
        this.dispatcher.detachConsumerPoint(this);
        if (this.keyGroup != null) {
            this.keyGroup.removeMember(this);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"detach");
        }
    }

    @Override
    public synchronized void start() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"start");
        }
        Iterator<ConsumableKey> it = this.consumerKeys.values().iterator();
        while (it.hasNext()) {
            it.next().start();
        }
        if (this.keyGroup != null) {
            this.keyGroup.startMember();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"start");
        }
    }

    @Override
    public DispatchableConsumerPoint getConsumerPoint() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getConsumerPoint");
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getConsumerPoint", (Object)this.consumerPoint);
        }
        return this.consumerPoint;
    }

    @Override
    public synchronized LockingCursor getGetCursor(SIMPMessage msg) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getGetCursor", (Object)msg);
        }
        SIBUuid8 meUuid = msg.getLocalisingMEUuid();
        LockingCursor getCursor = this.consumerKeys.get(meUuid).getGetCursor(msg);
        if (this.keyGroup != null) {
            getCursor = this.keyGroup.getGetCursor(msg);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getGetCursor", (Object)getCursor);
        }
        return getCursor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void notReady() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"notReady");
        }
        Object object = this.dispatcher.getDestination().getReadyConsumerPointLock();
        synchronized (object) {
            Iterator<ConsumableKey> it = this.consumerKeys.values().iterator();
            while (it.hasNext()) {
                it.next().notReady();
            }
            if (this.keyGroup != null) {
                this.keyGroup.notReady();
            }
            this.ready = false;
            this.outstandingRequestExpiryTime = -1L;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"notReady");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void ready(Reliability unrecoverable) throws SINotPossibleInCurrentConfigurationException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"ready", (Object)unrecoverable);
        }
        Object object = this.dispatcher.getDestination().getReadyConsumerPointLock();
        synchronized (object) {
            Iterator<ConsumableKey> it = this.consumerKeys.values().iterator();
            while (it.hasNext()) {
                it.next().ready(unrecoverable);
            }
            if (this.keyGroup != null) {
                this.keyGroup.ready(null);
            }
            this.ready = true;
            this.unrecoverable = unrecoverable;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"ready");
        }
    }

    @Override
    public synchronized void stop() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"stop");
        }
        Iterator<ConsumableKey> it = this.consumerKeys.values().iterator();
        while (it.hasNext()) {
            it.next().stop();
        }
        if (this.keyGroup != null) {
            this.keyGroup.stopMember();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"stop");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long waiting(long timeout, boolean modifyTimeout) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"waiting", (Object)new Object[]{timeout, modifyTimeout});
        }
        long rc = timeout;
        Iterator it = null;
        GatheringConsumerKey gatheringConsumerKey = this;
        synchronized (gatheringConsumerKey) {
            it = ((HashMap)this.consumerKeys.clone()).values().iterator();
            if (timeout == 0L) {
                this.outstandingRequestExpiryTime = timeout;
            } else if (timeout != -1L) {
                long expiryTime = System.currentTimeMillis() + timeout;
                if (this.outstandingRequestExpiryTime != 0L && this.outstandingRequestExpiryTime < expiryTime) {
                    this.outstandingRequestExpiryTime = expiryTime;
                }
            }
        }
        while (it.hasNext()) {
            long to;
            LocalQPConsumerKey key = (LocalQPConsumerKey)it.next();
            if (!key.isRefillAllowed() || (to = key.waiting(timeout, modifyTimeout)) <= rc) continue;
            rc = to;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"waiting", (Object)rc);
        }
        return rc;
    }

    @Override
    public boolean isKeyReady() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isKeyReady");
        }
        boolean returnValue = false;
        returnValue = this.keyGroup == null ? this.ready : this.keyGroup.isKeyReady();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"isKeyReady", (Object)returnValue);
        }
        return returnValue;
    }

    @Override
    public synchronized void markNotReady() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"markNotReady");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"markNotReady");
        }
    }

    @Override
    public boolean getForwardScanning() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getForwardScanning");
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getForwardScanning", (Object)this.forwardScanning);
        }
        return this.forwardScanning;
    }

    @Override
    public SIBUuid12 getConnectionUuid() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getConnectionUuid");
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getConnectionUuid", (Object)this.connectionUuid);
        }
        return this.connectionUuid;
    }

    @Override
    public JSConsumerManager getConsumerManager() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getConsumerPoint");
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getConsumerPoint", (Object)this.dispatcher);
        }
        return this.dispatcher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SIMPMessage getMessageLocked() throws MessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getMessageLocked");
        }
        SIMPMessage msg = null;
        SIBUuid8 currentUuid = null;
        GatheringConsumerKey gatheringConsumerKey = this;
        synchronized (gatheringConsumerKey) {
            Iterator<SIBUuid8> it = this.consumerKeys.keySet().iterator();
            int localQPWeighting = this.dispatcher.getMessageProcessor().getCustomProperties().get_gathering_local_weighting();
            if (Math.random() < (double)localQPWeighting / 100.0) {
                currentUuid = this.dispatcher.getMessageProcessor().getMessagingEngineUuid();
                msg = (SIMPMessage)((LocalQPConsumerKey)this.consumerKeys.get(currentUuid)).getDefaultGetCursor().next();
            }
            if (msg == null) {
                boolean startedSearch = false;
                int iterations = 0;
                int searchCount = 0;
                int numberOfKeys = this.consumerKeys.keySet().size();
                while (iterations < numberOfKeys) {
                    if (it.hasNext()) {
                        currentUuid = it.next();
                    } else {
                        it = this.consumerKeys.keySet().iterator();
                        currentUuid = it.next();
                    }
                    ++searchCount;
                    if (startedSearch) {
                        ++iterations;
                        LocalQPConsumerKey key = (LocalQPConsumerKey)this.consumerKeys.get(currentUuid);
                        msg = (SIMPMessage)key.getDefaultGetCursor().next();
                        if (msg != null) {
                            this.lastDMERequestedUuid = currentUuid;
                            break;
                        }
                        key.initiateRefill();
                    }
                    if (this.lastDMERequestedUuid != null && searchCount != numberOfKeys && (startedSearch || !currentUuid.equals((Object)this.lastDMERequestedUuid))) continue;
                    startedSearch = true;
                }
            }
        }
        if (msg != null) {
            msg.setLocalisingME(currentUuid);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getMessageLocked", (Object)new Object[]{msg, currentUuid});
        }
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean close(int closedReason, SIBUuid8 qpoint) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"close", (Object)new Object[]{closedReason, qpoint});
        }
        ConsumableKey ck = null;
        GatheringConsumerKey gatheringConsumerKey = this;
        synchronized (gatheringConsumerKey) {
            ck = this.consumerKeys.remove(qpoint);
            this.closed = this.consumerKeys.isEmpty();
            if (this.closed) {
                this.closedReason = closedReason;
            }
        }
        if (ck != null) {
            ck.close(closedReason, null);
            this.consumerPoint.lock();
            try {
                ck.stop();
                ck.notReady();
            }
            finally {
                this.consumerPoint.unlock();
            }
            try {
                ck.detach();
            }
            catch (SIException sIException) {
                // empty catch block
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"close", (Object)this.closed);
        }
        return this.closed;
    }

    @Override
    public boolean isSpecific() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reattachConsumer(SIBUuid8 uuid, ConsumableKey ck) throws SINotPossibleInCurrentConfigurationException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"reattachConsumer", (Object)new Object[]{uuid, ck});
        }
        long timeout = -1L;
        GatheringConsumerKey gatheringConsumerKey = this;
        synchronized (gatheringConsumerKey) {
            if (!this.closed) {
                if (this.isKeyReady()) {
                    Object object = this.dispatcher.getDestination().getReadyConsumerPointLock();
                    synchronized (object) {
                        ck.ready(this.unrecoverable);
                    }
                }
                this.consumerKeys.put(uuid, ck);
                if (this.outstandingRequestExpiryTime != -1L && (timeout = this.outstandingRequestExpiryTime) != 0L) {
                    timeout = this.outstandingRequestExpiryTime - System.currentTimeMillis();
                }
            }
        }
        if (timeout == 0L || timeout > 0L) {
            ((LocalQPConsumerKey)ck).initiateRefill();
            ck.waiting(timeout, true);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"reattachConsumer");
        }
    }

    public synchronized boolean isAttached(SIBUuid8 uuid) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"isAttached", (Object)uuid);
        }
        boolean isAttached = false;
        if (this.consumerKeys.keySet().contains(uuid)) {
            isAttached = true;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"isAttached", (Object)isAttached);
        }
        return isAttached;
    }
}

