/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.admin.internal;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.messaging.mbean.MessagingEngineMBean;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.security.audit.context.AuditManager;
import com.ibm.websphere.sib.exception.SINotSupportedException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.messaging.lifecycle.Singleton;
import com.ibm.ws.messaging.security.RuntimeSecurityService;
import com.ibm.ws.sib.admin.AliasDestination;
import com.ibm.ws.sib.admin.BaseDestination;
import com.ibm.ws.sib.admin.BaseDestinationDefinition;
import com.ibm.ws.sib.admin.DestinationDefinition;
import com.ibm.ws.sib.admin.JsBus;
import com.ibm.ws.sib.admin.JsMEConfig;
import com.ibm.ws.sib.admin.JsMain;
import com.ibm.ws.sib.admin.JsMessagingEngine;
import com.ibm.ws.sib.admin.JsProcessComponent;
import com.ibm.ws.sib.admin.LWMConfig;
import com.ibm.ws.sib.admin.SIBDestination;
import com.ibm.ws.sib.admin.SIBExceptionBusNotFound;
import com.ibm.ws.sib.admin.internal.BaseMessagingEngineImpl;
import com.ibm.ws.sib.admin.internal.JsBusImpl;
import com.ibm.ws.sib.admin.internal.JsDestinationCache;
import com.ibm.ws.sib.admin.internal.JsMessagingEngineImpl;
import com.ibm.ws.sib.admin.internal.SIBLocalizationPointImpl;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicReference;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;

@Component(service={JsMainImpl.class, JsMain.class, Singleton.class}, configurationPolicy=ConfigurationPolicy.IGNORE, property={"type=com.ibm.ws.sib.admin.internal.JsMain", "service.vendor=IBM"})
public final class JsMainImpl
implements JsMain,
Singleton {
    private static final String CLASS_NAME = "com.ibm.ws.sib.admin.internal.JsMainImpl";
    private static final TraceComponent tc = SibTr.register(JsMainImpl.class, (String)"SIBAdmin", (String)"com.ibm.ws.sib.admin.internal.CWSIDMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.admin.internal.CWSIDText");
    private JsMEConfig meConfig = null;
    JsBusImpl bus = null;
    ArrayList services;
    BundleContext bContext;
    ServiceRegistration<?> mbeanServiceReg;
    private final RuntimeSecurityService runtimeSecurityService;
    private boolean _serverStarted = false;
    private boolean _serverStopping = false;
    private final AtomicReference<JsMessagingEngineImpl> messagingEngineRef = new AtomicReference();

    public final RuntimeSecurityService getRuntimeSecurityService() {
        return this.runtimeSecurityService;
    }

    @Activate
    public JsMainImpl(BundleContext bContext, @Reference RuntimeSecurityService runtimeSecurityService) throws IllegalStateException {
        String methodName = "<init>";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)methodName, (Object)new Object[]{this, bContext, runtimeSecurityService, this.services});
        }
        this.bContext = bContext;
        this.runtimeSecurityService = runtimeSecurityService;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)methodName);
        }
    }

    public void initialize(JsMEConfig config) throws Exception {
        String methodName = "initialize";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)methodName, (Object)"");
        }
        this.meConfig = config;
        this.bus = new JsBusImpl(this.meConfig, this, this.meConfig.getSIBus().getName());
        JsMessagingEngineImpl engineImpl = new JsMessagingEngineImpl(this, this.bus, this.meConfig);
        this.messagingEngineRef.set(engineImpl);
        try {
            engineImpl.initialize(null);
            engineImpl.setConfig(engineImpl);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)methodName, (String)"1:656:1.108", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)e);
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_ERROR_SIAS0003", (Object)e);
            SibTr.error((TraceComponent)tc, (String)"ME_ERROR_REPORTED_SIAS0029", (Object)engineImpl.getName());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)methodName, (Object)engineImpl);
        }
    }

    public void start() throws Exception {
        String methodName = "start";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)methodName);
        }
        Optional.ofNullable(this.messagingEngineRef.get()).ifPresent(me -> {
            try {
                me.startConditional();
                Hashtable<String, String> properties = new Hashtable<String, String>();
                ((Dictionary)properties).put("service.vendor", "IBM");
                ((Dictionary)properties).put("jmx.objectname", "WebSphere:feature=wasJmsServer,type=MessagingEngine,name=" + me._name);
                this.mbeanServiceReg = this.bContext.registerService(MessagingEngineMBean.class.getName(), me, properties);
            }
            catch (Exception w) {
                FFDCFilter.processException((Throwable)w, (String)methodName, (String)"1:725:1.108", (Object)this);
                SibTr.exception((Object)this, (TraceComponent)tc, (Exception)w);
                SibTr.error((TraceComponent)tc, (String)"INTERNAL_ERROR_SIAS0003", (Object)w);
            }
        });
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)methodName);
        }
    }

    public void serverStarted() {
        String methodName = "serverStarted";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)methodName);
        }
        this._serverStarted = true;
        Optional.ofNullable(this.messagingEngineRef.get()).ifPresent(me -> {
            try {
                me.serverStarted();
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)methodName, (String)"1:772:1.108", (Object)this);
                SibTr.exception((Object)this, (TraceComponent)tc, (Exception)e);
                SibTr.error((TraceComponent)tc, (String)"INTERNAL_ERROR_SIAS0003", (Object)e);
                SibTr.error((TraceComponent)tc, (String)"ME_ERROR_REPORTED_SIAS0029", (Object)me.getName());
            }
        });
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)methodName);
        }
    }

    public void serverStopping() {
        String methodName = "serverStopping";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)methodName);
        }
        this._serverStopping = true;
        this._serverStarted = false;
        Optional.ofNullable(this.messagingEngineRef.get()).ifPresent(me -> {
            try {
                me.serverStopping();
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)methodName, (String)"1:810:1.108", (Object)this);
                SibTr.exception((Object)this, (TraceComponent)tc, (Exception)e);
                SibTr.error((TraceComponent)tc, (String)"INTERNAL_ERROR_SIAS0003", (Object)e);
            }
        });
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)methodName);
        }
    }

    public void stop() {
        String methodName = "stop";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)methodName);
        }
        Optional.ofNullable(this.messagingEngineRef.get()).ifPresent(me -> {
            try {
                me.stopConditional(0);
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)methodName, (String)"1:854:1.108", (Object)this);
                SibTr.exception((Object)this, (TraceComponent)tc, (Exception)e);
                SibTr.error((TraceComponent)tc, (String)"INTERNAL_ERROR_SIAS0003", (Object)e);
            }
        });
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)methodName);
        }
    }

    public void destroy() throws Exception {
        String methodName = "destroy";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)methodName);
        }
        Optional.ofNullable(this.messagingEngineRef.getAndSet(null)).ifPresent(me -> {
            try {
                me.destroy();
                this.mbeanServiceReg.unregister();
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)methodName, (String)"1:910:1.108", (Object[])new Object[]{this, me});
                SibTr.exception((Object)this, (TraceComponent)tc, (Exception)e);
                SibTr.error((TraceComponent)tc, (String)"INTERNAL_ERROR_SIAS0003", (Object)e);
            }
        });
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)methodName);
        }
    }

    private JsBusImpl getBusProxy(JsMEConfig me) {
        String methodName = "getBusProxy(ConfigObject)";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)methodName, (Object)"ME Name");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)methodName);
        }
        return this.bus;
    }

    private JsBusImpl getBusProxy(String name) throws SIBExceptionBusNotFound {
        String methodName = "getBusProxy(String)";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)methodName, (Object)name);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)methodName);
        }
        return this.bus;
    }

    public JsBus getBus(String busName) throws SIBExceptionBusNotFound {
        String methodName = "getBus(String)";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)methodName, (Object)busName);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)methodName);
        }
        return this.bus;
    }

    public JsBus getDefinedBus(String busName) throws SIBExceptionBusNotFound {
        String methodName = "getDefinedBus";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)methodName, (Object)busName);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)methodName);
        }
        return this.bus;
    }

    public JsMessagingEngine getMessagingEngine(String busName, String engine) {
        String methodName = "getMessagingEngine";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)methodName, (Object)new Object[]{busName, engine});
        }
        AuditManager auditManager = new AuditManager();
        auditManager.setJMSBusName(busName);
        auditManager.setJMSMessagingEngine(engine);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)methodName);
        }
        return this.messagingEngineRef.get();
    }

    public Enumeration listMessagingEngines() {
        String methodName = "listMessagingEngines";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)methodName, (Object)this);
        }
        Vector v = new Vector();
        Optional.ofNullable(this.messagingEngineRef.get()).ifPresent(v::add);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)methodName);
        }
        return v.elements();
    }

    public Enumeration listMessagingEngines(String busName) {
        String methodName = "listMessagingEngines";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)methodName, (Object)busName);
        }
        Vector v = new Vector();
        Optional.ofNullable(this.messagingEngineRef.get()).filter(me -> Objects.equals(me.getBusName(), busName)).ifPresent(v::add);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)methodName);
        }
        return v.elements();
    }

    public Set getMessagingEngineSet(String busName) {
        String methodName = "getMessagingEngineSet";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)methodName, (Object)busName);
        }
        HashSet<String> retSet = new HashSet<String>();
        if (this.meConfig != null) {
            String meName = this.meConfig.getMessagingEngine().getName();
            BaseMessagingEngineImpl engineImpl = this.messagingEngineRef.get();
            retSet.add(engineImpl.getUuid().toString());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Integer i = new Integer(retSet.size());
            SibTr.exit((TraceComponent)tc, (String)methodName, (Object)i.toString());
        }
        return retSet;
    }

    public String getLibertyMEUuid() {
        JsMessagingEngineImpl engineImpl = this.messagingEngineRef.get();
        return engineImpl.getUuid();
    }

    public void startMessagingEngine(String busName, String name) throws Exception {
        BaseMessagingEngineImpl me;
        String methodName = "com.ibm.ws.sib.admin.internal.JsMainImpl.startMessagingEngine(String, String)";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)methodName, (Object)new Object[]{busName, name});
        }
        if ((me = (BaseMessagingEngineImpl)this.getMessagingEngine(busName, name)) == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("Unable to locate engine <bus=" + busName + " name=" + name + ">"));
            }
            throw new Exception("The messaging engine <bus=" + busName + " name=" + name + "> does not exist");
        }
        me.startConditional();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)methodName);
        }
    }

    public void stopMessagingEngine(String busName, String name) throws Exception {
        String methodName = "com.ibm.ws.sib.admin.internal.JsMainImpl.stopMessagingEngine(String, String)";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)methodName, (Object)new Object[]{busName, name});
        }
        this.stopMessagingEngine(busName, name, 0);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)methodName);
        }
    }

    public void stopMessagingEngine(String busName, String name, String mode) throws Exception {
        String methodName = "com.ibm.ws.sib.admin.internal.JsMainImpl.stopMessagingEngine(String, String, String)";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)methodName, (Object)new Object[]{busName, name, mode});
        }
        int iMode = Integer.parseInt(mode);
        this.stopMessagingEngine(busName, name, iMode);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)methodName);
        }
    }

    private void stopMessagingEngine(String busName, String name, int mode) throws Exception {
        BaseMessagingEngineImpl me;
        String methodName = "com.ibm.ws.sib.admin.internal.JsMainImpl.stopMessagingEngine(String, String, int)";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)methodName, (Object)new Object[]{busName, name, Integer.toString(mode)});
        }
        if ((me = (BaseMessagingEngineImpl)this.getMessagingEngine(busName, name)) == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("Unable to locate engine <bus=" + busName + " name=" + name + ">"));
            }
            throw new Exception("The messaging engine <bus=" + busName + " name=" + name + "> does not exist");
        }
        me.stopConditional(mode);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)methodName);
        }
    }

    public JsProcessComponent getProcessComponent(String className) {
        String methodName = "getProcessComponent(String)";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)methodName, (Object)className);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)methodName);
        }
        return null;
    }

    public boolean isServerStarted() {
        String methodName = "isServerStarted()";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)methodName, (Object)this);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)methodName, (Object)new Boolean(this._serverStarted));
        }
        return this._serverStarted;
    }

    public boolean isServerStopping() {
        String methodName = "isServerStopping()";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)methodName, (Object)this);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)methodName, (Object)new Boolean(this._serverStopping));
        }
        return this._serverStopping;
    }

    public boolean isServerInRecoveryMode() {
        String methodName = "isServerInRecoveryMode()";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)methodName, (Object)this);
        }
        boolean ret = false;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)methodName, (Object)new Boolean(ret));
        }
        return ret;
    }

    public Object getService(Class c) {
        String methodName = "getService";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)methodName);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)methodName);
        }
        return null;
    }

    public List<String> listDefinedBuses() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"listDefinedBuses", (Object)this);
        }
        List<String> buses = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"listDefinedBuses", buses);
        }
        return buses;
    }

    public void alterDestinationLocalization(BaseDestination config) throws Exception {
        SibTr.entry((TraceComponent)tc, (String)"alterDestinationLocalization : ", (Object)config);
        String meName = this.meConfig.getMessagingEngine().getName();
        BaseMessagingEngineImpl engine = this.messagingEngineRef.get();
        SIBLocalizationPointImpl lpConfig = new SIBLocalizationPointImpl();
        lpConfig.setIdentifier(config.getName() + "@" + meName);
        if (!config.isAlias()) {
            SIBDestination d = (SIBDestination)config;
            lpConfig.setHighMsgThreshold(d.getHighMessageThreshold());
            engine.alterLocalizationPoint(config, (LWMConfig)lpConfig);
        } else {
            AliasDestination aliasDest = (AliasDestination)config;
            engine.alterLocalizationPoint((BaseDestination)aliasDest, (LWMConfig)lpConfig);
        }
        SibTr.exit((TraceComponent)tc, (String)"alterDestinationLocalization : ", (Object)config);
    }

    public void createDestinationLocalization(BaseDestination config) throws Exception {
        SibTr.entry((TraceComponent)tc, (String)"createDestinationLocalization", (Object)this);
        try {
            String meName = this.meConfig.getMessagingEngine().getName();
            JsDestinationCache dCache = this.bus.getDestinationCache();
            BaseDestinationDefinition dd = dCache.addNewDestinationToCache(config);
            if (!config.isAlias()) {
                BaseMessagingEngineImpl engine = this.messagingEngineRef.get();
                SIBLocalizationPointImpl lpConfig = new SIBLocalizationPointImpl();
                lpConfig.setIdentifier(config.getName() + "@" + meName);
                SIBDestination d = (SIBDestination)config;
                lpConfig.setHighMsgThreshold(d.getHighMessageThreshold());
                engine.addLocalizationPoint((LWMConfig)lpConfig, (DestinationDefinition)dd);
                ArrayList<BaseDestinationDefinition> list = new ArrayList<BaseDestinationDefinition>();
                list.add(dd);
                this.bus.getDestinationCache().populateUuidCache(list);
            }
        }
        catch (Exception e) {
            SibTr.exception((TraceComponent)tc, (Exception)e);
        }
        SibTr.exit((TraceComponent)tc, (String)"createDestinationLocalization for destination: ", (Object)config.getName());
    }

    public void deleteDestinationLocalization(BaseDestination config) throws Exception {
        SibTr.entry((TraceComponent)tc, (String)"deleteDestinationLocalization ", (Object)config.getName());
        try {
            JsMessagingEngineImpl me = this.messagingEngineRef.get();
            me.deleteLocalizationPoint(this.bus, (LWMConfig)config);
            JsDestinationCache cache = this.bus.getDestinationCache();
            cache.deleteDestination(this.bus.getName(), config.getName());
        }
        catch (Exception e) {
            SibTr.exception((TraceComponent)tc, (Exception)e);
        }
        SibTr.exit((TraceComponent)tc, (String)"deleteDestinationLocalization ", (Object)config.getName());
    }

    public void reloadEngine(long highMessageThreshold) throws Exception {
        throw new SINotSupportedException();
    }

    class ComponentList {
        private final String _className;
        private final JsProcessComponent _componentRef;

        ComponentList(String className, JsProcessComponent c) {
            this._className = className;
            this._componentRef = c;
        }

        String getClassName() {
            return this._className;
        }

        JsProcessComponent getRef() {
            return this._componentRef;
        }
    }
}

