/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.oauth20.plugins;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.oauth.core.api.config.OAuthComponentConfiguration;
import com.ibm.oauth.core.api.error.OidcServerException;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.oauth20.api.OidcOAuth20ClientProvider;
import com.ibm.ws.security.oauth20.plugins.OidcBaseClient;
import com.ibm.ws.security.oauth20.plugins.OidcBaseClientValidator;
import com.ibm.ws.security.oauth20.util.ClientUtils;
import com.ibm.ws.security.oauth20.util.ConfigUtils;
import com.ibm.ws.security.oauth20.web.RegistrationEndpointServices;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/ejs/ras/TraceComponent;")
@InjectedFFDC
public class OidcBaseClientProvider
implements OidcOAuth20ClientProvider {
    private static TraceComponent tc = Tr.register(OidcBaseClientProvider.class, (String)"OAuth20Provider", (String)"com.ibm.ws.security.oauth20.resources.ProviderMsgs");
    private final Logger logger;
    private static final String ERROR_DESCRIPTION_UNIMPLEMENTED = "This method is unimplemented for non-database client stores.";
    protected static HashMap<String, OidcBaseClient> clientMap = new HashMap();
    protected String providerID;
    protected boolean hasRewrites;
    protected static final List<OidcBaseClient> clientsList = new ArrayList<OidcBaseClient>();
    private final String[] providerRewrites;
    static final long serialVersionUID = -164829631558941548L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    public OidcBaseClientProvider(String providerId, String[] providerRewrites) {
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"<init>", (Object)new Object[]{providerId, providerRewrites});
        }
        this.logger = Logger.getLogger(OidcBaseClientProvider.class.getName());
        this.providerID = providerId;
        String[] stringArray = this.providerRewrites = providerRewrites != null ? (String[])providerRewrites.clone() : null;
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"<init>", (Object)this);
        }
    }

    @Override
    @ManualTrace
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    public void initialize() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"initialize");
        }
        this.hasRewrites = ClientUtils.initRewrites(this.providerID, this.providerRewrites);
        this.loadClients();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"initialize");
        }
    }

    @Override
    @ManualTrace
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    public void init(OAuthComponentConfiguration config) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"init");
        }
        this.providerID = config.getUniqueId();
        this.hasRewrites = ClientUtils.initRewrites(config);
        this.loadClients();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"init");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    private void loadClients() {
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"loadClients", (Object)new Object[0]);
        }
        try {
            ArrayList<OidcBaseClient> clientsList = new ArrayList<OidcBaseClient>();
            clientsList.addAll(ConfigUtils.getClients());
            HashMap<String, OidcBaseClient> hashMap = clientMap;
            synchronized (hashMap) {
                for (OidcBaseClient client : clientsList) {
                    String key = this.getKey(client.getClientId(), client.getComponentId());
                    clientMap.put(key, client);
                }
            }
        }
        catch (Exception clientsList) {
            void e;
            FFDCFilter.processException((Throwable)clientsList, (String)"com.ibm.ws.security.oauth20.plugins.OidcBaseClientProvider", (String)"94", (Object)this, (Object[])new Object[0]);
            this.logger.log(Level.WARNING, e.getMessage());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"loadClients");
        }
    }

    @Override
    @ManualTrace
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    public boolean exists(String clientIdentifier) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"exists");
        }
        boolean result = clientMap.containsKey(this.getKey(clientIdentifier));
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"exists", (Object)result);
        }
        return result;
    }

    @Override
    @ManualTrace
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    public OidcBaseClient get(String clientIdentifier) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"get");
        }
        OidcBaseClient result = this.getClient(this.getKey(clientIdentifier));
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"get", (Object)result);
        }
        return result;
    }

    @Override
    @ManualTrace
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    public Collection<OidcBaseClient> getAll() throws OidcServerException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getAll");
        }
        Collection<OidcBaseClient> results = this.getAll(null);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getAll");
        }
        return results;
    }

    @Override
    @ManualTrace
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    public Collection<OidcBaseClient> getAll(HttpServletRequest request) throws OidcServerException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getAll(request)");
        }
        ArrayList<OidcBaseClient> results = new ArrayList<OidcBaseClient>();
        for (String key : clientMap.keySet()) {
            if (!this.providerOwns(key)) continue;
            results.add(this.getClient(key, request));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getAll(request)");
        }
        return results;
    }

    @Override
    @ManualTrace
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    public boolean validateClient(String clientIdentifier, String clientSecret) {
        String secret;
        OidcBaseClient client;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"validateClient");
        }
        boolean result = false;
        if (clientIdentifier != null && clientSecret != null && (client = this.getClient(this.getKey(clientIdentifier))) != null && (secret = client.getClientSecret()) != null && secret.equals(clientSecret)) {
            result = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"validateClient", (Object)(result + ""));
        }
        return result;
    }

    @Override
    @ManualTrace
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    public OidcBaseClient update(OidcBaseClient newClient) throws OidcServerException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"update");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"update");
        }
        throw new OidcServerException(ERROR_DESCRIPTION_UNIMPLEMENTED, "server_error", 405);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    protected String getKey(String clientId) {
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getKey", (Object)new Object[]{clientId});
        }
        String string = this.getKey(clientId, this.providerID);
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            string = string;
            Tr.exit((TraceComponent)tc, (String)"getKey", (Object)string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    protected String getKey(String clientId, String providerId) {
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getKey", (Object)new Object[]{clientId, providerId});
        }
        String string = clientId + "_" + providerId;
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            string = string;
            Tr.exit((TraceComponent)tc, (String)"getKey", (Object)string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    protected boolean providerOwns(String key) {
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"providerOwns", (Object)new Object[]{key});
        }
        boolean bl = key.endsWith("_" + this.providerID);
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            bl = bl;
            Tr.exit((TraceComponent)tc, (String)"providerOwns", (Object)bl);
        }
        return bl;
    }

    @ManualTrace
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    protected OidcBaseClient getClient(String key) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getClient " + key));
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"clientMap ", clientMap);
            }
        }
        OidcBaseClient result = this.getClient(key, null);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getClient", (Object)result);
        }
        return result;
    }

    @ManualTrace
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    protected OidcBaseClient getClient(String key, HttpServletRequest request) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getClient " + key));
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"clientMap ", clientMap);
            }
        }
        OidcBaseClient result = null;
        OidcBaseClient retrieved = clientMap.get(key);
        if (retrieved != null) {
            result = OidcBaseClientValidator.getInstance(retrieved).setDefaultsForOmitted();
        }
        if (request != null && result != null) {
            RegistrationEndpointServices.processClientRegistationUri(result, request);
        }
        if (this.hasRewrites && result != null) {
            result = ClientUtils.uriRewrite(result);
        }
        if (result != null) {
            try {
                if (result.getClientName() != null) {
                    result.setClientName(URLDecoder.decode(result.getClientName(), "UTF-8"));
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                FFDCFilter.processException((Throwable)unsupportedEncodingException, (String)"com.ibm.ws.security.oauth20.plugins.OidcBaseClientProvider", (String)"256", (Object)this, (Object[])new Object[]{key, request});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getClient", (Object)result);
        }
        return result;
    }

    @Override
    @ManualTrace
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    public boolean delete(String clientIdentifier) throws OidcServerException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"delete");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"delete");
        }
        throw new OidcServerException(ERROR_DESCRIPTION_UNIMPLEMENTED, "server_error", 405);
    }

    @ManualTrace
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    public boolean deleteOverride(String clientIdentifier) throws OidcServerException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"deleteOverride");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"deleteOverride");
        }
        return clientMap.remove(this.getKey(clientIdentifier)) != null;
    }

    @Override
    @ManualTrace
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    public OidcBaseClient put(OidcBaseClient newClient) throws OidcServerException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"put");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"put");
        }
        throw new OidcServerException(ERROR_DESCRIPTION_UNIMPLEMENTED, "server_error", 405);
    }
}

