/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsoc.outbound;

import com.ibm.websphere.channelfw.osgi.CHFWBundle;
import com.ibm.websphere.channelfw.osgi.ChannelFactoryProvider;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.kernel.productinfo.ProductInfo;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.wsoc.outbound.WsocAddress;
import com.ibm.ws.wsoc.outbound.WsocChain;
import com.ibm.wsspi.channelfw.ChannelConfiguration;
import com.ibm.wsspi.channelfw.ChannelFramework;
import com.ibm.wsspi.channelfw.ChannelFrameworkFactory;
import com.ibm.wsspi.channelfw.VirtualConnection;
import com.ibm.wsspi.channelfw.exception.ChainException;
import com.ibm.wsspi.channelfw.exception.ChannelException;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.kernel.service.utils.FrameworkState;
import com.ibm.wsspi.kernel.service.utils.MetatypeUtils;
import io.openliberty.netty.internal.BootstrapExtended;
import io.openliberty.netty.internal.NettyFramework;
import io.openliberty.netty.internal.tls.NettyTlsProvider;
import java.util.Map;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class WsocOutboundChain {
    private static final TraceComponent tc = Tr.register(WsocOutboundChain.class, (String)"websockets", (String)"com.ibm.ws.wsoc.internal.resources.WebSockets");
    private ChannelConfiguration tcpOptions = null;
    private ChannelConfiguration httpOptions = null;
    private final AtomicServiceReference<ChannelConfiguration> sslOptions = new AtomicServiceReference("sslOptions");
    private final AtomicServiceReference<ChannelFactoryProvider> sslFactoryProvider = new AtomicServiceReference("sslSupport");
    private static CHFWBundle chfw = null;
    private final WsocChain wsocChain = new WsocChain(this, false);
    private final WsocChain wsocSecureChain = new WsocChain(this, true);
    private volatile boolean outboundCalled = true;
    public static final String WS_CHAIN_NAME = "WsocOutboundHttp";
    public static final String WSS_CHAIN_NAME = "WsocOutboundHttpSecure";
    private static NettyFramework nettyBundle;
    private static NettyTlsProvider nettyTlsProvider;
    private static boolean useNettyTransport;
    protected static BootstrapExtended unsecureBootstrap;
    protected static BootstrapExtended secureBootstrap;
    protected static Map<String, Object> currentSSLOptions;
    protected static Map<String, Object> currentHttpOptions;
    private final Object actionLock = new Object(){
        static final long serialVersionUID = 1849963841051220592L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.wsoc.outbound.WsocOutboundChain$1", 1.class, (String)"websockets", (String)"com.ibm.ws.wsoc.internal.resources.WebSockets");
        }
    };
    private final Runnable stopAction = new Runnable(){
        static final long serialVersionUID = -162075288953024403L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Trivial
        public void run() {
            Object object = WsocOutboundChain.this.actionLock;
            synchronized (object) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)("EndpointAction: stopping chains " + WsocOutboundChain.this), (Object[])new Object[]{WsocOutboundChain.this.wsocChain, WsocOutboundChain.this.wsocSecureChain});
                }
                WsocOutboundChain.this.wsocChain.stop();
                WsocOutboundChain.this.wsocSecureChain.stop();
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.wsoc.outbound.WsocOutboundChain$2", 2.class, (String)"websockets", (String)"com.ibm.ws.wsoc.internal.resources.WebSockets");
        }
    };
    private final Runnable stopHttpsOnlyAction = new Runnable(){
        static final long serialVersionUID = 6743230035800030653L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Trivial
        public void run() {
            Object object = WsocOutboundChain.this.actionLock;
            synchronized (object) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)("EndpointAction: stopping https chain " + WsocOutboundChain.this), (Object[])new Object[]{WsocOutboundChain.this.wsocSecureChain});
                }
                WsocOutboundChain.this.wsocSecureChain.stop();
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.wsoc.outbound.WsocOutboundChain$3", 3.class, (String)"websockets", (String)"com.ibm.ws.wsoc.internal.resources.WebSockets");
        }
    };
    private final Runnable updateAction = new Runnable(){
        static final long serialVersionUID = 6299579988865571560L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Trivial
        public void run() {
            Object object = WsocOutboundChain.this.actionLock;
            synchronized (object) {
                if (FrameworkState.isValid() && WsocOutboundChain.this.outboundCalled) {
                    WsocOutboundChain.this.wsocChain.update();
                    WsocOutboundChain.this.wsocSecureChain.update();
                }
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.wsoc.outbound.WsocOutboundChain$4", 4.class, (String)"websockets", (String)"com.ibm.ws.wsoc.internal.resources.WebSockets");
        }
    };
    static final long serialVersionUID = 8125679205057959661L;

    public static VirtualConnection getVCFactory(WsocAddress addr) throws ChainException, ChannelException {
        if (addr.isSecure()) {
            return WsocOutboundChain.getCfw().getOutboundVCFactory(WSS_CHAIN_NAME).createConnection();
        }
        return WsocOutboundChain.getCfw().getOutboundVCFactory(WS_CHAIN_NAME).createConnection();
    }

    public static BootstrapExtended getBootstrap(WsocAddress addr) {
        if (addr.isSecure()) {
            return secureBootstrap;
        }
        return unsecureBootstrap;
    }

    public static boolean isUsingNetty() {
        return useNettyTransport;
    }

    public static Map<String, Object> getCurrentSslOptions() {
        return currentSSLOptions;
    }

    public static Map<String, Object> getCurrentHttpOptions() {
        return currentHttpOptions;
    }

    protected void activate(Map<String, Object> properties, ComponentContext context) {
        this.sslOptions.activate(context);
        this.sslFactoryProvider.activate(context);
        boolean bl = useNettyTransport = ProductInfo.getBetaEdition() && MetatypeUtils.parseBoolean((Object)WS_CHAIN_NAME, (String)"useNettyTransport", (Object)properties.get("useNettyTransport"), (boolean)true);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("activate, Netty bundle: " + nettyBundle), (Object[])new Object[0]);
        }
        if (useNettyTransport) {
            this.wsocChain.init(WS_CHAIN_NAME, nettyBundle);
            this.wsocSecureChain.init(WSS_CHAIN_NAME, nettyBundle);
        } else {
            this.wsocChain.init(WS_CHAIN_NAME, chfw.getFramework());
            this.wsocSecureChain.init(WSS_CHAIN_NAME, chfw.getFramework());
        }
        this.modified(properties);
    }

    @Modified
    protected void modified(Map<String, Object> config) {
        boolean usingNetty = ProductInfo.getBetaEdition() && MetatypeUtils.parseBoolean((Object)WS_CHAIN_NAME, (String)"useNettyTransport", (Object)config.get("useNettyTransport"), (boolean)true);
        boolean unchangedTransport = useNettyTransport && usingNetty;
        useNettyTransport = usingNetty;
        this.modified(unchangedTransport);
    }

    private void modified(boolean unchangedTransport) {
        if (this.sslFactoryProvider.getService() != null) {
            this.wsocSecureChain.setConfigured(true);
        }
        if (!unchangedTransport) {
            if (useNettyTransport) {
                this.wsocChain.init(WS_CHAIN_NAME, nettyBundle);
                this.wsocSecureChain.init(WSS_CHAIN_NAME, nettyBundle);
            } else {
                this.wsocChain.init(WS_CHAIN_NAME, chfw.getFramework());
                this.wsocSecureChain.init(WSS_CHAIN_NAME, chfw.getFramework());
            }
        }
        this.wsocSecureChain.enable();
        this.wsocChain.enable();
        this.performAction(this.updateAction);
    }

    protected void deactivate(ComponentContext context) {
        this.performAction(this.stopAction);
        this.sslOptions.deactivate(context);
        this.sslFactoryProvider.deactivate(context);
    }

    @Trivial
    protected void setTcpOptions(ChannelConfiguration service) {
        this.tcpOptions = service;
        this.performAction(this.updateAction);
    }

    @Trivial
    protected void unsetTcpOptions(ServiceReference<ChannelConfiguration> service) {
    }

    @Trivial
    public Map<String, Object> getTcpOptions() {
        ChannelConfiguration c = this.tcpOptions;
        return c == null ? null : c.getConfiguration();
    }

    protected void setHttpOptions(ChannelConfiguration service) {
        this.httpOptions = service;
        this.performAction(this.updateAction);
    }

    @Trivial
    protected void unsetHttpOptions(ServiceReference<ChannelConfiguration> service) {
    }

    public Map<String, Object> getHttpOptions() {
        ChannelConfiguration c = this.httpOptions;
        return c == null ? null : c.getConfiguration();
    }

    @Trivial
    protected void setSslOptions(ServiceReference<ChannelConfiguration> service) {
        this.sslOptions.setReference(service);
        this.wsocSecureChain.setConfigured(true);
        this.performAction(this.updateAction);
    }

    @Trivial
    protected void unsetSslOptions(ServiceReference<ChannelFactoryProvider> ref) {
        if (this.sslFactoryProvider.unsetReference(ref)) {
            this.wsocSecureChain.setConfigured(false);
        }
    }

    public Map<String, Object> getSslOptions() {
        ChannelConfiguration c = (ChannelConfiguration)this.sslOptions.getService();
        return c == null ? null : c.getConfiguration();
    }

    @Reference(name="chfwBundle")
    protected void setChfwBundle(CHFWBundle bundle) {
        chfw = bundle;
    }

    protected void unsetChfwBundle(CHFWBundle bundle) {
    }

    protected CHFWBundle getChfwBundle() {
        return chfw;
    }

    public static ChannelFramework getCfw() {
        if (null == chfw) {
            return ChannelFrameworkFactory.getChannelFramework();
        }
        return chfw.getFramework();
    }

    @Reference(name="nettyTlsProvider")
    protected void setNettyTlsProvider(NettyTlsProvider bundle) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("Setting nettyTlsBundle " + bundle), (Object[])new Object[0]);
        }
        nettyTlsProvider = bundle;
    }

    public static NettyTlsProvider getNettyTlsProvider() {
        return nettyTlsProvider;
    }

    @Reference(name="nettyBundle")
    protected void setNettyBundle(NettyFramework bundle) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("Setting nettyBundle " + bundle), (Object[])new Object[0]);
        }
        nettyBundle = bundle;
    }

    protected void unsetNettyBundle(NettyFramework bundle) {
    }

    public static NettyFramework getNettyFramework() {
        return nettyBundle;
    }

    private void performAction(Runnable action) {
        action.run();
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        useNettyTransport = false;
    }
}

