/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.servlet;

import graphql.schema.GraphQLSchema;
import io.smallrye.graphql.execution.SchemaPrinter;
import io.smallrye.graphql.servlet.SmallRyeGraphQLServletLogging;
import jakarta.inject.Inject;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;

@WebServlet(name="SmallRyeGraphQLSchemaServlet", urlPatterns={"/graphql/schema.graphql"}, loadOnStartup=2)
public class SchemaServlet
extends HttpServlet {
    public static final String SCHEMA_PROP = "io.smallrye.graphql.servlet.bootstrap";
    @Inject
    private SchemaPrinter schemaPrinter;
    private static final String CONTENT_TYPE = "text/plain";

    public SchemaServlet() {
    }

    public SchemaServlet(SchemaPrinter schemaPrinter) {
        this.schemaPrinter = schemaPrinter;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) {
        response.setContentType(CONTENT_TYPE);
        try (PrintWriter out = response.getWriter();){
            GraphQLSchema schema = (GraphQLSchema)request.getServletContext().getAttribute(SCHEMA_PROP);
            out.print(this.schemaPrinter.print(schema));
            out.flush();
        }
        catch (IOException ex) {
            SmallRyeGraphQLServletLogging.log.ioException(ex);
        }
    }
}

