/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.springboot.support.shutdown;

import com.ibm.ws.app.manager.springboot.container.ApplicationTr;
import org.springframework.boot.EnvironmentPostProcessor;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.SpringBootVersion;
import org.springframework.core.env.ConfigurableEnvironment;

public class FeatureAuditor40
implements EnvironmentPostProcessor {
    protected static String asResourceName(String className) {
        return className.replace('.', '/') + ".class";
    }

    protected static boolean isClassAvailable(String className) {
        String resourceName;
        ClassLoader classLoader = FeatureAuditor40.class.getClassLoader();
        boolean foundClass = classLoader.getResource(resourceName = FeatureAuditor40.asResourceName(className)) != null;
        return foundClass;
    }

    protected static void warning(ApplicationTr.Type msgId, Object ... parms) {
        ApplicationTr.warning((ApplicationTr.Type)msgId, (Object[])parms);
    }

    public void postProcessEnvironment(ConfigurableEnvironment env, SpringApplication app) {
        String appSpringBootVersion = SpringBootVersion.getVersion();
        boolean appHasSpring40 = appSpringBootVersion.compareTo("4.0.0") >= 0;
        boolean appUsesServlets = FeatureAuditor40.isClassAvailable("org.springframework.web.WebApplicationInitializer");
        boolean appUsesWebsockets = FeatureAuditor40.isClassAvailable("org.springframework.web.socket.WebSocketHandler");
        boolean libertyHasSpring15 = FeatureAuditor40.isClassAvailable("com.ibm.ws.springboot.support.web.server.version15.container.LibertyConfiguration");
        boolean libertyHasSpring20 = FeatureAuditor40.isClassAvailable("com.ibm.ws.springboot.support.web.server.version20.container.LibertyConfiguration");
        boolean libertyHasSpring30 = FeatureAuditor40.isClassAvailable("io.openliberty.springboot.support.web.server.version30.container.LibertyConfiguration");
        boolean libertyHasSpring40 = FeatureAuditor40.isClassAvailable("io.openliberty.springboot.support.web.server.version40.container.LibertyConfiguration");
        String libertySpringFeature = libertyHasSpring15 ? "springBoot-1.5" : (libertyHasSpring20 ? "springBoot-2.0" : (libertyHasSpring30 ? "springBoot-3.0" : (libertyHasSpring40 ? "springBoot-4.0" : null)));
        boolean libertyHasJakartaServlets = FeatureAuditor40.isClassAvailable("jakarta.servlet.Servlet");
        boolean libertyHasJakartaWebsockets = FeatureAuditor40.isClassAvailable("jakarta.websocket.WebSocketContainer");
        String javaVersion = System.getProperty("java.version");
        String javaSpecVersion = System.getProperty("java.vm.specification.version");
        int javaSpecVersionNo = 0;
        javaSpecVersionNo = javaSpecVersion.contains(".") ? Integer.parseInt(javaSpecVersion.substring(javaSpecVersion.indexOf(".") + 1, javaSpecVersion.length())) : Integer.parseInt(javaSpecVersion);
        if (appHasSpring40) {
            int requiredJavaVersion = 17;
            String requiredVersionText = "JavaSE-17.0";
            if (javaSpecVersionNo < requiredJavaVersion) {
                ApplicationTr.warning((String)"warning.unsupported.spring.java.version", (Object[])new Object[]{javaVersion, appSpringBootVersion, requiredVersionText});
            }
        }
        if (appHasSpring40) {
            if (libertyHasSpring15 || libertyHasSpring20 || libertyHasSpring30) {
                ApplicationTr.error((String)"error.spring4.required", (Object[])new Object[]{"springBoot-4.0", libertySpringFeature, "4.0"});
            } else if (appUsesServlets && !libertyHasJakartaServlets) {
                ApplicationTr.error((String)"error.spring4.requires.servlet61.or.later.application", (Object[])new Object[0]);
            } else if (appUsesWebsockets && !libertyHasJakartaWebsockets) {
                ApplicationTr.error((String)"error.spring4.requires.websocket22.or.later.application", (Object[])new Object[0]);
            }
        }
    }
}

