/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.springboot.support.shutdown;

import com.ibm.ws.app.manager.springboot.container.SpringBootConfigFactory;
import org.springframework.boot.EnvironmentPostProcessor;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.core.env.ConfigurableEnvironment;

public class ApplicationContextCloser40
implements EnvironmentPostProcessor {
    private static final Object token = new Object(){};

    public void postProcessEnvironment(ConfigurableEnvironment env, SpringApplication app) {
        if (env.getPropertySources().contains("bootstrap")) {
            return;
        }
        SpringBootConfigFactory factory = SpringBootConfigFactory.findFactory((Object)token);
        app.addInitializers(new ApplicationContextInitializer[]{c -> {
            factory.addShutdownHook(() -> c.close());
            c.addApplicationListener(e -> {
                if (e instanceof ContextClosedEvent) {
                    factory.rootContextClosed();
                } else if (e instanceof ApplicationReadyEvent) {
                    factory.getApplicationReadyLatch().countDown();
                }
            });
        }});
    }
}

