/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.mcp.internal.schemas;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.Optional;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class TypeUtility {
    static final long serialVersionUID = -6515722742264741522L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public static MapTypes getMapTypes(Type rootType) {
        List<Type> route = TypeUtility.getRouteToType(rootType, Map.class);
        Type[] resolvedParameters = TypeUtility.resolveTypeArguments(route);
        return new MapTypes(resolvedParameters[0], resolvedParameters[1]);
    }

    public static Type getCollectionType(Type rootType) {
        List<Type> route = TypeUtility.getRouteToType(rootType, Collection.class);
        Type[] resolvedParameters = TypeUtility.resolveTypeArguments(route);
        return resolvedParameters[0];
    }

    public static Type getOptionalType(Type rootType) {
        List<Type> route = TypeUtility.getRouteToType(rootType, Optional.class);
        Type[] resolvedParameters = TypeUtility.resolveTypeArguments(route);
        return resolvedParameters[0];
    }

    public static Type[] resolveTypeArguments(List<Type> typeList) {
        Type typeToResolve = typeList.get(0);
        if (!(typeToResolve instanceof ParameterizedType)) {
            return new Type[0];
        }
        ParameterizedType pTypeToResolve = (ParameterizedType)typeToResolve;
        Class rawTypeToResolve = (Class)pTypeToResolve.getRawType();
        TypeVariable<Class<T>>[] startingTypeParameters = rawTypeToResolve.getTypeParameters();
        Type[] currentTypes = (Type[])Arrays.copyOf(startingTypeParameters, startingTypeParameters.length, Type[].class);
        for (Type t : typeList) {
            if (!(t instanceof ParameterizedType)) continue;
            ParameterizedType pt = (ParameterizedType)t;
            Type[] actualTypeArguments = pt.getActualTypeArguments();
            TypeVariable<Class<T>>[] typeParameters = ((Class)pt.getRawType()).getTypeParameters();
            for (int i = 0; i < currentTypes.length; ++i) {
                for (int j = 0; j < typeParameters.length; ++j) {
                    if (currentTypes[i] != typeParameters[j]) continue;
                    currentTypes[i] = actualTypeArguments[j];
                }
            }
        }
        return currentTypes;
    }

    public static List<Type> getRouteToType(Type start, Class<?> target) {
        ArrayDeque<Type> route = new ArrayDeque<Type>();
        boolean successful = TypeUtility.buildRouteToType(start, target, route);
        if (!successful) {
            throw new IllegalArgumentException("Type " + String.valueOf(start) + " does not extend " + String.valueOf(target));
        }
        return List.copyOf(route);
    }

    private static boolean buildRouteToType(Type current, Class<?> target, Deque<Type> routeSoFar) {
        Class c;
        if (current instanceof ParameterizedType) {
            Type[] p = (Type[])current;
            c = (Class)p.getRawType();
        } else if (current instanceof Class) {
            Class cls;
            c = cls = (Class)current;
        } else {
            return false;
        }
        if (c == target) {
            routeSoFar.addFirst(current);
            return true;
        }
        routeSoFar.addFirst(current);
        for (Type iface : c.getGenericInterfaces()) {
            if (!TypeUtility.buildRouteToType(iface, target, routeSoFar)) continue;
            return true;
        }
        Type superCls = c.getGenericSuperclass();
        if (superCls != null && TypeUtility.buildRouteToType(superCls, target, routeSoFar)) {
            return true;
        }
        routeSoFar.removeFirst();
        return false;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"io.openliberty.mcp.internal.schemas.TypeUtility", TypeUtility.class, (String)"MCP", null);
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    public record MapTypes(Type key, Type value) {
        static final long serialVersionUID = -1467206478446303164L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"io.openliberty.mcp.internal.schemas.TypeUtility$MapTypes", MapTypes.class, (String)"MCP", null);
        }
    }
}

