/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.mcp.internal.responses;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.mcp.internal.requests.McpRequestId;
import jakarta.json.bind.annotation.JsonbNillable;

@JsonbNillable
@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public abstract class McpResponse {
    private String jsonrpc;
    private McpRequestId id;
    private static final TraceComponent tc = Tr.register(McpResponse.class, (String)"MCP", (String)"io.openliberty.mcp.internal.resources.CWMCM");
    static final long serialVersionUID = 7553599153954355807L;

    public McpResponse(String jsonrpc, McpRequestId id) {
        if (jsonrpc == null || !jsonrpc.equals("2.0")) {
            throw new IllegalArgumentException(Tr.formatMessage((TraceComponent)tc, (String)"jsonrpc field must be present. Only JSONRPC 2.0 is currently supported\"", (Object[])new Object[]{jsonrpc}));
        }
        if (id == null) {
            throw new IllegalArgumentException(Tr.formatMessage((TraceComponent)tc, (String)"id must not be null", (Object[])new Object[]{id}));
        }
        this.jsonrpc = jsonrpc;
        this.id = id;
    }

    public String getJsonrpc() {
        return this.jsonrpc;
    }

    public McpRequestId getId() {
        return this.id;
    }
}

