/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.arquillian.support;

import com.ibm.ws.container.service.state.ApplicationStateListener;
import com.ibm.ws.ffdc.FFDC;
import com.ibm.wsspi.logging.IncidentForwarder;
import io.openliberty.arquillian.support.DeploymentExceptionMBeanImpl;
import io.openliberty.arquillian.support.IncidentListener;
import java.lang.management.ManagementFactory;
import java.util.Dictionary;
import java.util.Hashtable;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class Initializer
implements BundleActivator {
    private static final ObjectName on;
    private ServiceRegistration<ApplicationStateListener> appStateListenerRegistration;
    private IncidentListener listener = new IncidentListener();

    public void start(BundleContext bContext) {
        FFDC.registerIncidentForwarder((IncidentForwarder)this.listener);
        Hashtable<String, Integer> properties = new Hashtable<String, Integer>();
        ((Dictionary)properties).put("service.ranking", 5000);
        this.appStateListenerRegistration = bContext.registerService(ApplicationStateListener.class, (Object)this.listener, properties);
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        try {
            mbs.registerMBean(new DeploymentExceptionMBeanImpl(this.listener), on);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void stop(BundleContext ctx) {
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        try {
            mbs.unregisterMBean(on);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        FFDC.deregisterIncidentForwarder((IncidentForwarder)this.listener);
        this.appStateListenerRegistration.unregister();
    }

    static {
        StringBuilder sb = new StringBuilder("LibertyArquillian:");
        sb.append("type=").append("DeploymentExceptionMBean");
        try {
            on = new ObjectName(sb.toString());
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException(e);
        }
    }
}

