/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.arquillian.support;

import com.ibm.ws.container.service.app.deploy.ApplicationInfo;
import com.ibm.ws.container.service.state.ApplicationStateListener;
import com.ibm.ws.container.service.state.StateChangeException;
import com.ibm.wsspi.logging.Incident;
import com.ibm.wsspi.logging.IncidentForwarder;
import java.util.concurrent.atomic.AtomicReference;

public class IncidentListener
implements IncidentForwarder,
ApplicationStateListener {
    private AtomicReference<ExceptionInfo> lastException = new AtomicReference();
    private AtomicReference<String> appName = new AtomicReference<Object>(null);

    public void process(Incident incident, Throwable exception) {
        if (exception instanceof StateChangeException) {
            ExceptionInfo info = new ExceptionInfo(exception, this.appName.get());
            this.lastException.set(info);
        }
    }

    public ExceptionInfo getLastException() {
        return this.lastException.get();
    }

    public void clear() {
        this.lastException.set(null);
    }

    public void applicationStarting(ApplicationInfo appInfo) throws StateChangeException {
        this.appName.set(appInfo.getName());
    }

    public void applicationStarted(ApplicationInfo arg0) throws StateChangeException {
    }

    public void applicationStopped(ApplicationInfo arg0) {
    }

    public void applicationStopping(ApplicationInfo arg0) {
    }

    public static class ExceptionInfo {
        private Throwable exception;
        private String appName;

        public ExceptionInfo(Throwable exception, String appName) {
            this.exception = exception;
            this.appName = appName;
        }

        public Throwable getException() {
            return this.exception;
        }

        public String getAppName() {
            return this.appName;
        }
    }
}

