/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.openapi31;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.microprofile.openapi.impl.core.util.Json;
import com.ibm.ws.microprofile.openapi.impl.core.util.Yaml;
import com.ibm.ws.microprofile.openapi.impl.parser.ObjectMapperFactory;
import com.ibm.ws.openapi31.OASProviderFilterBuilder;
import com.ibm.ws.openapi31.OASProviderWrapper;
import com.ibm.ws.openapi31.OpenAPIUtils;
import com.ibm.ws.openapi31.ProxySupportUtil;
import com.ibm.ws.openapi31.ServerInfo;
import com.ibm.ws.openapi31.merge.OASMergeService;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.http.VirtualHost;
import com.ibm.wsspi.openapi31.OASProvider;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(name="OpenAPIAggregator", service={OpenAPIAggregator.class}, configurationPolicy=ConfigurationPolicy.IGNORE, immediate=true, property={"service.vendor=IBM"})
public class OpenAPIAggregator {
    private static final TraceComponent tc = Tr.register(OpenAPIAggregator.class, (String)"OpenAPI", (String)"com.ibm.ws.openapi31.resources.OpenAPIMessages");
    private static final String EXCLUDE_CONTEXT_ROOTS = "mp.openapi.extensions.liberty.exclude.context.roots";
    private static final String QUERY_ROOT = "root";
    private final OASMergeService mergeService = new OASMergeService();
    private boolean isActivated = false;
    private final ConcurrentHashMap<OASProvider, OASProviderWrapper> oasProviderWrappers = new ConcurrentHashMap();
    private final ServerInfo serverInfo = new ServerInfo(null, -1, -1);
    private OpenAPI customizationOpenAPI = null;
    private final Set<String> excludedContextRoots;
    static final long serialVersionUID = -9190014622717468842L;

    public OpenAPIAggregator() {
        Config config = ConfigProvider.getConfig((ClassLoader)OpenAPIAggregator.class.getClassLoader());
        this.excludedContextRoots = OpenAPIUtils.getConfigPropAsSet(config, EXCLUDE_CONTEXT_ROOTS);
    }

    @Activate
    protected void activate(ComponentContext context, Map<String, Object> properties) {
        this.isActivated = true;
        if (OpenAPIUtils.isEventEnabled(tc)) {
            Tr.event((Object)this, (TraceComponent)tc, (String)"Activating OpenAPIAggregator", (Object[])new Object[]{properties});
        }
    }

    @Deactivate
    protected void deactivate(ComponentContext context, int reason) {
        this.isActivated = false;
        if (OpenAPIUtils.isEventEnabled(tc)) {
            Tr.event((Object)this, (TraceComponent)tc, (String)("Deactivating OpenAPIAggregator, reason=" + reason), (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Reference(service=OASProvider.class, policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.MULTIPLE, policyOption=ReferencePolicyOption.GREEDY)
    protected void setProvider(OASProvider provider) {
        if (!this.excludedContextRoots.contains(provider.getContextRoot())) {
            OASProviderWrapper wrapper = new OASProviderWrapper(provider);
            if (wrapper.getOpenAPI() != null) {
                wrapper.validate();
                OASMergeService oASMergeService = this.mergeService;
                synchronized (oASMergeService) {
                    this.addOpenAPI(wrapper);
                }
            }
            this.oasProviderWrappers.put(provider, wrapper);
        }
        if (OpenAPIUtils.isEventEnabled(tc)) {
            Tr.event((Object)this, (TraceComponent)tc, (String)("Finished processing the provider: " + provider), (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unsetProvider(OASProvider provider) {
        OASProviderWrapper wrapper = this.oasProviderWrappers.remove(provider);
        if (wrapper == null || wrapper.getOpenAPI() == null) {
            return;
        }
        OASMergeService oASMergeService = this.mergeService;
        synchronized (oASMergeService) {
            this.removeOpenAPI(wrapper);
        }
        if (OpenAPIUtils.isEventEnabled(tc)) {
            Tr.event((Object)this, (TraceComponent)tc, (String)("Finished removing the provider: " + provider), (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean addOpenAPI(OASProviderWrapper wrapper) {
        block2: {
            try {
                this.mergeService.addAPIProvider(wrapper);
            }
            catch (Exception exception) {
                void e;
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.openapi31.OpenAPIAggregator", (String)"135", (Object)this, (Object[])new Object[]{wrapper});
                if (!OpenAPIUtils.isEventEnabled(tc)) break block2;
                Tr.event((Object)this, (TraceComponent)tc, (String)("Exception occurred while merging the Open API from the provider: " + wrapper.getOpenAPIProvider() + e), (Object[])new Object[0]);
            }
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private void removeOpenAPI(OASProviderWrapper wrapper) {
        block2: {
            try {
                this.mergeService.removeAPIProvider(wrapper);
            }
            catch (Exception exception) {
                void e;
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.openapi31.OpenAPIAggregator", (String)"146", (Object)this, (Object[])new Object[]{wrapper});
                if (!OpenAPIUtils.isEventEnabled(tc)) break block2;
                Tr.event((Object)this, (TraceComponent)tc, (String)("Exception occured while removing the Open API from the provider: " + wrapper.getOpenAPIProvider() + e), (Object[])new Object[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OpenAPI getMergedDocumentation(OASProviderFilterBuilder filterBuilder) {
        OpenAPI openAPI = this.createOpenAPI();
        OASMergeService oASMergeService = this.mergeService;
        synchronized (oASMergeService) {
            Stream<OASProviderWrapper> s = this.oasProviderWrappers.values().stream().filter(filterBuilder.getPredicate());
            if (filterBuilder.getFindFirst()) {
                OASProviderWrapper w = s.findFirst().orElse(null);
                if (w != null && w.getOpenAPI() != null) {
                    this.mergeService.mergeOpenAPI(openAPI, w.getOpenAPI());
                }
            } else {
                s.forEach(v -> {
                    if (v.getOpenAPI() != null) {
                        this.mergeService.mergeOpenAPI(openAPI, v.getOpenAPI());
                    }
                });
            }
        }
        return openAPI;
    }

    public boolean getPublicDocumentation(HttpServletRequest request, boolean compact, boolean yaml, HttpServletResponse response) {
        return this.getDocumentation(request, compact, yaml, response, new OASProviderFilterBuilder().addPredicate(OASProviderFilterBuilder.publicFilter()));
    }

    public boolean getDocumentation(HttpServletRequest request, boolean compact, boolean yaml, HttpServletResponse response) {
        return this.getDocumentation(request, compact, yaml, response, new OASProviderFilterBuilder());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public boolean getDocumentation(HttpServletRequest request, boolean compact, boolean yaml, HttpServletResponse response, OASProviderFilterBuilder filterBuilder) {
        String serializedDocument;
        block15: {
            if (!this.isActivated) {
                return false;
            }
            this.processRequest(request, filterBuilder);
            serializedDocument = null;
            OpenAPI openAPI = this.getMergedDocumentation(filterBuilder);
            ServerInfo reqServerInfo = null;
            ServerInfo serverInfo = this.serverInfo;
            synchronized (serverInfo) {
                reqServerInfo = new ServerInfo(this.serverInfo);
            }
            ProxySupportUtil.processRequest(request, reqServerInfo);
            reqServerInfo.updateServers(openAPI);
            try {
                if (yaml) {
                    serializedDocument = Yaml.mapper().writeValueAsString((Object)openAPI);
                } else if (!yaml && !compact) {
                    serializedDocument = Json.pretty().writeValueAsString((Object)openAPI);
                } else if (!yaml && compact) {
                    serializedDocument = Json.mapper().writeValueAsString((Object)openAPI);
                }
            }
            catch (JsonProcessingException jsonProcessingException) {
                void e;
                FFDCFilter.processException((Throwable)jsonProcessingException, (String)"com.ibm.ws.openapi31.OpenAPIAggregator", (String)"203", (Object)this, (Object[])new Object[]{request, compact, yaml, response, filterBuilder});
                if (!OpenAPIUtils.isEventEnabled(tc)) break block15;
                Tr.event((TraceComponent)tc, (String)("Exception occurred while trying to convert OpenAPI object to String. \n exception: " + e), (Object[])new Object[0]);
            }
        }
        if (OpenAPIUtils.isDumpEnabled(tc)) {
            Tr.dump((TraceComponent)tc, (String)("Returning document into the response: compact? " + compact + " yaml?" + yaml + " \n" + serializedDocument), (Object[])new Object[0]);
        }
        try {
            response.setCharacterEncoding("UTF-8");
            response.getWriter().write(serializedDocument);
            return true;
        }
        catch (IOException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.openapi31.OpenAPIAggregator", (String)"217", (Object)this, (Object[])new Object[]{request, compact, yaml, response, filterBuilder});
            if (OpenAPIUtils.isEventEnabled(tc)) {
                Tr.event((Object)this, (TraceComponent)tc, (String)("Exception occured while writing to document to the response: " + e.getMessage()), (Object[])new Object[0]);
            }
            return true;
        }
    }

    private void processRequest(HttpServletRequest request, OASProviderFilterBuilder filterBuilder) {
        String contextRoot = request.getParameter(QUERY_ROOT);
        if (contextRoot != null && !contextRoot.isEmpty()) {
            filterBuilder.addPredicate(OASProviderFilterBuilder.contextRootFilter(contextRoot));
        }
    }

    @Reference(service=VirtualHost.class, target="(&(enabled=true)(id=default_host)(|(aliases=*)(httpsAlias=*)))", policy=ReferencePolicy.STATIC, cardinality=ReferenceCardinality.MANDATORY)
    protected void setVirtualHost(VirtualHost vhost, Map<String, Object> props) {
        this.updateOpenAPIServer(vhost, props);
    }

    protected void updatedVirtualHost(VirtualHost vhost, Map<String, Object> props) {
        this.updateOpenAPIServer(vhost, props);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateOpenAPIServer(VirtualHost vhost, Map<String, Object> props) {
        Object value = props.get("httpsAlias");
        if (value == null) {
            CharSequence[] aliases = (String[])props.get("aliases");
            if (OpenAPIUtils.isEventEnabled(tc)) {
                Tr.event((Object)this, (TraceComponent)tc, (String)("httpsAlias is null. aliases : " + String.join((CharSequence)", ", aliases)), (Object[])new Object[0]);
            }
            value = Arrays.stream(aliases).filter(a -> !a.endsWith(":-1")).findFirst().orElse(null);
            if (OpenAPIUtils.isEventEnabled(tc)) {
                Tr.event((Object)this, (TraceComponent)tc, (String)("Found non-secure alias: " + value), (Object[])new Object[0]);
            }
        }
        String alias = String.valueOf(value);
        if (OpenAPIUtils.isEventEnabled(tc)) {
            Tr.event((Object)this, (TraceComponent)tc, (String)("Received new alias: " + alias), (Object[])new Object[0]);
        }
        ServerInfo serverInfo = this.serverInfo;
        synchronized (serverInfo) {
            this.serverInfo.setHost(vhost.getHostName(alias));
            this.serverInfo.setHttpPort(vhost.getHttpPort(alias));
            this.serverInfo.setHttpsPort(vhost.getSecureHttpPort(alias));
            this.checkVCAPHost(this.serverInfo);
        }
        if (OpenAPIUtils.isEventEnabled(tc)) {
            Tr.event((Object)this, (TraceComponent)tc, (String)("Updated server information: " + this.serverInfo), (Object[])new Object[0]);
        }
    }

    @FFDCIgnore(value={Exception.class})
    private void checkVCAPHost(ServerInfo server) {
        block5: {
            String VCAP_APPLICATION = System.getenv("VCAP_APPLICATION");
            if (VCAP_APPLICATION != null) {
                try {
                    JsonNode node = (JsonNode)ObjectMapperFactory.createJson().readValue(VCAP_APPLICATION, JsonNode.class);
                    ArrayNode uris = (ArrayNode)node.get("uris");
                    if (uris != null && uris.size() > 0 && uris.get(0) != null) {
                        server.setHost(uris.get(0).textValue());
                    }
                    if (OpenAPIUtils.isEventEnabled(tc)) {
                        Tr.event((Object)this, (TraceComponent)tc, (String)("Changed hostPort using VCAP_APPLICATION.  New value: " + server.getHost()), (Object[])new Object[0]);
                    }
                }
                catch (Exception e) {
                    if (!OpenAPIUtils.isEventEnabled(tc)) break block5;
                    Tr.event((Object)this, (TraceComponent)tc, (String)("Exception while parsing VCAP_APPLICATION env: " + e.getMessage()), (Object[])new Object[0]);
                }
            }
        }
    }

    public void setOpenAPICustomization(OpenAPI customOpenAPI) {
        this.customizationOpenAPI = customOpenAPI;
        if (this.customizationOpenAPI != null) {
            this.serverInfo.setCustomServers(customOpenAPI.getServers());
        } else {
            this.serverInfo.setCustomServers(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OpenAPI createOpenAPI() {
        OASMergeService oASMergeService = this.mergeService;
        synchronized (oASMergeService) {
            OpenAPI openAPI = OpenAPIUtils.createDefaultOpenAPI();
            if (this.customizationOpenAPI != null) {
                openAPI.setInfo(OpenAPIUtils.ensureValidInfo(this.customizationOpenAPI.getInfo()));
                openAPI.setSecurity(this.customizationOpenAPI.getSecurity());
                openAPI.setExternalDocs(this.customizationOpenAPI.getExternalDocs());
                if (this.customizationOpenAPI.getServers() != null && !this.customizationOpenAPI.getServers().isEmpty()) {
                    openAPI.setServers(this.customizationOpenAPI.getServers());
                } else if (this.serverInfo != null) {
                    this.serverInfo.updateServers(openAPI);
                }
                OpenAPIUtils.copyOpenAPIObjectExtensions(this.customizationOpenAPI, openAPI);
            }
            return openAPI;
        }
    }
}

