/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.tx.jta.ut.util;

import java.io.Serializable;
import javax.transaction.xa.Xid;

public class XID
implements Serializable,
Xid {
    private byte[] gid = null;
    private byte[] branchQualifier = null;
    private int formatId = -1;

    @Override
    public byte[] getGlobalTransactionId() {
        return this.gid;
    }

    @Override
    public byte[] getBranchQualifier() {
        return this.branchQualifier;
    }

    @Override
    public int getFormatId() {
        return this.formatId;
    }

    public XID(int formatId, byte[] gid, byte[] branchQualifier) {
        this.branchQualifier = branchQualifier;
        this.formatId = formatId;
        this.gid = gid;
    }

    public boolean equals(Object o) {
        if (o instanceof XID && o != null) {
            int i;
            XID x = (XID)o;
            if (this.formatId != x.getFormatId()) {
                return false;
            }
            if (this.gid != null || x.gid != null) {
                if (this.gid == null || x.gid == null) {
                    return false;
                }
                if (this.gid.length == x.getGlobalTransactionId().length) {
                    for (i = 0; i < this.gid.length; ++i) {
                        if (this.gid[i] == x.getGlobalTransactionId()[i]) continue;
                        return false;
                    }
                }
            }
            if (this.branchQualifier != null || x.getBranchQualifier() != null) {
                if (this.branchQualifier == null || x.getBranchQualifier() == null) {
                    return false;
                }
                if (this.branchQualifier.length == x.getBranchQualifier().length) {
                    for (i = 0; i < this.branchQualifier.length; ++i) {
                        if (this.branchQualifier[i] == x.getBranchQualifier()[i]) continue;
                        return false;
                    }
                }
            }
            return true;
        }
        return false;
    }

    public String toLongString() {
        if (this.gid == null) {
            return null;
        }
        StringBuffer buf = new StringBuffer("Global ID: ");
        this.toHexString(buf, this.gid);
        buf.append("\n");
        buf.append("Branch qualifier: ");
        this.toHexString(buf, this.branchQualifier);
        buf.append("\n");
        buf.append("Format id: ");
        buf.append(this.formatId);
        return buf.toString();
    }

    public String toString() {
        if (this.gid == null) {
            return null;
        }
        StringBuffer buf = new StringBuffer("Global ID: ");
        this.toHexString(buf, this.gid);
        return buf.toString();
    }

    public static XID[] convertXidArrayToXIDArray(Xid[] id) {
        XID[] retVal = new XID[id.length];
        for (int i = 0; i < id.length; ++i) {
            retVal[i] = new XID(id[i].getFormatId(), id[i].getGlobalTransactionId(), id[i].getBranchQualifier());
        }
        return retVal;
    }

    public static XID convertXidToXID(Xid xid) {
        return new XID(xid.getFormatId(), xid.getGlobalTransactionId(), xid.getBranchQualifier());
    }

    private void toHexString(StringBuffer buf, byte[] array) {
        String digits = "0123456789abcdef";
        for (int i = 0; i < array.length; ++i) {
            buf.append(digits.charAt(array[i] >> 4 & 0xF));
            buf.append(digits.charAt(array[i] & 0xF));
        }
    }
}

