/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.tx.jta.ut.util;

import com.ibm.tx.jta.TransactionManagerFactory;
import com.ibm.tx.jta.impl.LocalTIDTable;
import com.ibm.tx.jta.impl.TransactionImpl;
import com.ibm.tx.jta.ut.util.AlreadyDumpedException;
import com.ibm.tx.jta.ut.util.StateKeeper;
import com.ibm.tx.jta.ut.util.TxTestUtils;
import com.ibm.tx.jta.ut.util.XID;
import com.ibm.ws.Transaction.JTA.Util;
import jakarta.transaction.SystemException;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class XAResourceImpl
implements XAResource,
Serializable {
    static final long serialVersionUID = -2141508727147091254L;
    private static Path wakeUpFile;
    protected static boolean dumped;
    protected static ConcurrentHashMap<String, XAResourceData> _resources;
    protected static StateKeeper stateKeeper;
    private static List<XAEvent> _XAEvents;
    protected String _key;
    private static AtomicInteger _commitSequence;
    public static final int RUNTIME_EXCEPTION = -1000;
    public static final int DIE = -2000;
    public static final int SLEEP_COMMIT = -3000;
    public static final int SLEEP_ROLLBACK = -4000;
    public static final int RETURN_TRUE = -5000;
    public static final int RETURN_FALSE = -6000;
    public static final int SLEEP_RECOVER = -7000;
    public static final int CONDITIONAL_RUNTIME_EXCEPTION = -8000;
    public static final int NOT_STARTED = 1;
    public static final int COMMITTED = 2;
    public static final int ENDED = 4;
    public static final int STARTED = 8;
    public static final int PREPARED = 16;
    public static final int ROLLEDBACK = 32;
    public static final int FORGOTTEN = 64;
    public static final int RECOVERED = 128;
    public static final int COMMITTED_ONE_PHASE = 256;
    protected static File STATE_FILE;
    public static final String DUMP_STATE = "Dump State: ";
    protected static boolean DEBUG_OUTPUT;
    protected static boolean _stateLoaded;
    public static final int DIRECTION_COMMIT = 0;
    public static final int DIRECTION_ROLLBACK = 1;
    public static final int DIRECTION_EITHER = 2;

    public static boolean isStateLoaded() {
        return _stateLoaded;
    }

    public int getExpectedDirection() {
        return this.self().getExpectedDirection();
    }

    public XAResourceImpl setExpectedDirection(int expectedDirection) {
        return this;
    }

    public static synchronized void setStateFile(File path) {
        try {
            System.out.println("setStateFile: " + path.getCanonicalPath());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        STATE_FILE = path;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        return o instanceof XAResourceImpl && this._key.equals(((XAResourceImpl)o)._key);
    }

    public int hashCode() {
        return this._key.hashCode();
    }

    public static int transactionCount() {
        TransactionImpl[] trans = LocalTIDTable.getAllTransactions();
        if (trans == null) {
            return 0;
        }
        return trans.length;
    }

    public static int countInState(int state) {
        int stateCount = 0;
        for (XAResourceData res : _resources.values()) {
            if (res.inState(state)) {
                System.out.println(state + " count: Resource " + res.key + " is in state " + state);
                ++stateCount;
                continue;
            }
            System.out.println(state + "count: Resource " + res.key + " is not in state " + state);
        }
        return stateCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XAResourceImpl() {
        ConcurrentHashMap<String, XAResourceData> concurrentHashMap = _resources;
        synchronized (concurrentHashMap) {
            this._key = UUID.randomUUID().toString();
            System.out.println("Constructing XAResourceImpl: " + this._key);
            _resources.put(this._key, new XAResourceData(this._key));
        }
    }

    public XAResourceImpl(int i) {
        this(Integer.toString(i));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XAResourceImpl(String key) {
        ConcurrentHashMap<String, XAResourceData> concurrentHashMap = _resources;
        synchronized (concurrentHashMap) {
            this._key = key;
            if (!_resources.containsKey(key)) {
                System.out.println("Constructing XAResourceImpl: " + this._key);
                _resources.put(this._key, new XAResourceData(this._key));
            } else {
                System.out.println("XAResourceImpl exists already: " + this._key);
            }
        }
    }

    public static XAResourceImpl getXAResourceImpl(String key) {
        return new XAResourceImpl(key);
    }

    @Override
    public void commit(Xid xid, boolean onePhase) throws XAException {
        if (dumped) {
            throw new AlreadyDumpedException("Test resource state was already dumped");
        }
        System.out.println("commit(" + this._key + ", " + xid + ", " + onePhase + ")");
        this.self().setCommitOrder(_commitSequence.incrementAndGet());
        System.out.println("Commit order is " + this.self().getCommitOrder());
        _XAEvents.add(new XAEvent(XAEventCode.COMMIT, this._key));
        try {
            if (DEBUG_OUTPUT) {
                System.out.println("commit working against " + this.self());
                System.out.println("commit using TM " + TransactionManagerFactory.getTransactionManager());
            }
            this.self().setStatusDuringCommit(TransactionManagerFactory.getTransactionManager().getStatus());
        }
        catch (SystemException e) {
            e.printStackTrace();
        }
        int commitAction = this.self().getCommitAction();
        if (commitAction != 0) {
            int repeatCount = this.self().getCommitRepeatCount();
            this.self().setCommitRepeatCount(repeatCount - 1);
            if (repeatCount >= 0) {
                switch (commitAction) {
                    case -1000: {
                        throw new RuntimeException();
                    }
                    case -2000: {
                        System.out.println("Calling DIE on commit(" + this._key + ", " + xid + ", " + onePhase + ")");
                        try {
                            this.killDoomedServers(true);
                        }
                        catch (SecurityException se) {
                            System.out.println("Caught Security Exc: " + se + " on commit(" + this._key + ", " + xid + ", " + onePhase + ")");
                        }
                    }
                    case -3000: {
                        try {
                            Thread.sleep(this.self().getSleepTime());
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        break;
                    }
                    default: {
                        throw new XAException(commitAction);
                    }
                }
            }
        }
        if (this.self().getExpectedDirection() != 0 && this.self().getExpectedDirection() != 2) {
            System.out.println("Commit is not the expected direction! Test failed.");
            throw new XAException("Test failed because of wrong direction. Commit is not the expected direction.");
        }
        this.setState(2);
        if (onePhase) {
            this.setState(256);
        }
        System.out.println("committed(" + this._key + ", " + xid + ", " + onePhase + ")");
    }

    private void killDoomedServers(boolean dumpState) {
        URL doomedServer = this.self().getDoomedServer();
        if (doomedServer != null) {
            System.out.println("killDoomedServers: " + doomedServer.toString());
            HttpURLConnection conn = null;
            try {
                conn = (HttpURLConnection)doomedServer.openConnection();
                conn.setDoInput(true);
                conn.setDoOutput(true);
                conn.setConnectTimeout(10000);
                conn.setReadTimeout(10000);
                conn.setRequestMethod("GET");
                conn.connect();
                int response_code = conn.getResponseCode();
                if (response_code == 200) {
                    conn.getInputStream();
                    System.out.println("Should not reach here.");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                if (conn != null) {
                    conn.disconnect();
                }
                System.out.println("Get expected exception in killServer " + e.toString());
            }
        }
        if (this.self().getCommitSuicide()) {
            System.out.println("Committing suicide");
            if (dumpState) {
                XAResourceImpl.dumpState();
            }
            try {
                Runtime.getRuntime().halt(-2000);
            }
            catch (Throwable t) {
                System.out.println("Runtime.getRuntime().halt() threw a Throwable:");
                t.printStackTrace();
            }
        }
    }

    @Override
    public void end(Xid xid, int flags) throws XAException {
        if (dumped) {
            throw new AlreadyDumpedException("Test resource state was already dumped");
        }
        System.out.println("end(" + this._key + ", " + xid + ", " + flags + ")");
        _XAEvents.add(new XAEvent(XAEventCode.END, this._key));
        int endAction = this.self().getEndAction();
        if (endAction != 0) {
            switch (endAction) {
                case -1000: {
                    throw new RuntimeException();
                }
                case -2000: {
                    this.killDoomedServers(false);
                }
            }
            throw new XAException(endAction);
        }
        this.setState(4);
    }

    @Override
    public void forget(Xid xid) throws XAException {
        if (dumped) {
            throw new AlreadyDumpedException("Test resource state was already dumped");
        }
        System.out.println("forget(" + this._key + ", " + xid + ")");
        _XAEvents.add(new XAEvent(XAEventCode.FORGET, this._key));
        int forgetAction = this.self().getForgetAction();
        if (forgetAction != 0) {
            int repeatCount = this.self().getForgetRepeatCount();
            this.self().setForgetRepeatCount(repeatCount - 1);
            if (repeatCount >= 0) {
                switch (forgetAction) {
                    case -1000: {
                        throw new RuntimeException();
                    }
                    case -2000: {
                        this.killDoomedServers(false);
                    }
                }
                throw new XAException(forgetAction);
            }
        }
        this.setState(64);
        this.self().setForgetCount(this.self().getForgetCount() + 1);
    }

    @Override
    public int getTransactionTimeout() throws XAException {
        return 0;
    }

    @Override
    public boolean isSameRM(XAResource xares) throws XAException {
        if (xares instanceof XAResourceImpl) {
            return this.self().getRM().equals(((XAResourceImpl)xares).getRM());
        }
        return false;
    }

    @Override
    public int prepare(Xid xid) throws XAException {
        if (dumped) {
            throw new AlreadyDumpedException("Test resource state was already dumped");
        }
        System.out.println("prepare(" + this._key + ", " + xid + ") = " + this.actionFormatter(this.self().getPrepareAction()));
        _XAEvents.add(new XAEvent(XAEventCode.PREPARE, this._key));
        try {
            this.self().setStatusDuringPrepare(TransactionManagerFactory.getTransactionManager().getStatus());
        }
        catch (SystemException e) {
            e.printStackTrace();
        }
        switch (this.self().getPrepareAction()) {
            case -1000: {
                throw new RuntimeException();
            }
            case 0: 
            case 3: {
                this.setState(16);
                return this.self().getPrepareAction();
            }
            case -2000: {
                this.killDoomedServers(true);
            }
            case -3000: {
                try {
                    Thread.sleep(this.self().getSleepTime());
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    throw new RuntimeException();
                }
                this.setState(16);
                return 0;
            }
            case -4000: {
                try {
                    Thread.sleep(this.self().getSleepTime());
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    throw new RuntimeException();
                }
                this.setState(32);
                throw new XAException(100);
            }
        }
        throw new XAException(this.self().getPrepareAction());
    }

    @Override
    public Xid[] recover(int flag) throws XAException {
        HashSet<XID> xidSet;
        if (dumped) {
            throw new AlreadyDumpedException("Test resource state was already dumped");
        }
        System.out.println("recover(" + this._key + ", " + flag + ")");
        if (this.self() == null) {
            if (DEBUG_OUTPUT) {
                System.out.println("No XARecoveryData - returning null xid array");
            }
            return null;
        }
        System.out.println("XAResource state in recover():\n" + this.self());
        _XAEvents.add(new XAEvent(XAEventCode.RECOVER, this._key));
        int recoverAction = this.self().getRecoverAction();
        if (recoverAction != 0) {
            int repeatCount = this.self().getRecoverRepeatCount();
            System.out.println("recoverRepeatCount = " + repeatCount + ", recoverAction = " + this.actionFormatter(recoverAction));
            boolean scupperRecovery = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                @Override
                public Boolean run() {
                    return Boolean.getBoolean("com.ibm.tx.scupperRecovery");
                }
            });
            if (recoverAction == -7000) {
                System.out.println("scupperRecovery is " + scupperRecovery);
                if (scupperRecovery) {
                    Instant wakeUpTime = Instant.now().plusSeconds(this.self().getRecoverDelay());
                    System.out.println("Sleeping till " + TxTestUtils.traceTime(wakeUpTime.toEpochMilli()) + " in RECOVER");
                    while (Instant.now().isBefore(wakeUpTime)) {
                        try {
                            if (Files.deleteIfExists(XAResourceImpl.getWakeUpFile())) {
                                System.out.println("Interrupted sleep in RECOVER");
                                break;
                            }
                            Thread.sleep(1000L);
                        }
                        catch (IOException | InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                    System.out.println("Awoken in RECOVER");
                }
            } else {
                this.self().setRecoverRepeatCount(repeatCount - 1);
                if (repeatCount > 0) {
                    switch (recoverAction) {
                        case -8000: {
                            if (!scupperRecovery) break;
                            throw new RuntimeException();
                        }
                        case -1000: {
                            throw new RuntimeException();
                        }
                        case -2000: {
                            this.killDoomedServers(true);
                            break;
                        }
                        default: {
                            throw new XAException(recoverAction);
                        }
                    }
                }
            }
        }
        this.setState(128);
        if (this.self().inState(16) && !this.self().inState(2) && !this.self().inState(32) && (xidSet = this.getXids()) != null) {
            XID[] xids = new XID[xidSet.size()];
            return xidSet.toArray(xids);
        }
        return null;
    }

    private HashSet<XID> getXids() {
        return this.self().getXids();
    }

    @Override
    public void rollback(Xid xid) throws XAException {
        if (dumped) {
            throw new AlreadyDumpedException("Test resource state was already dumped");
        }
        System.out.println("rollback(" + this._key + ", " + xid + ")");
        if (this.self().getExpectedDirection() != 1 && this.self().getExpectedDirection() != 2) {
            System.out.println("Rollback is not the expected direction! Test failed.");
            throw new XAException("Test failed because of wrong direction. Rollback is not the expected direction.");
        }
        _XAEvents.add(new XAEvent(XAEventCode.ROLLBACK, this._key));
        try {
            this.self().setStatusDuringRollback(TransactionManagerFactory.getTransactionManager().getStatus());
        }
        catch (SystemException e) {
            e.printStackTrace();
        }
        this.self().setRollbackCount(this.self().getRollbackCount() + 1);
        if (this.self().getRollbackAction() != 0) {
            int repeatCount = this.self().getRollbackRepeatCount();
            this.self().setRollbackRepeatCount(repeatCount - 1);
            if (repeatCount >= 0) {
                int rollbackAction = this.self().getRollbackAction();
                switch (rollbackAction) {
                    case -1000: {
                        throw new RuntimeException();
                    }
                    case -2000: {
                        this.killDoomedServers(true);
                    }
                    case -4000: {
                        try {
                            Thread.sleep(this.self().getSleepTime());
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        break;
                    }
                    default: {
                        throw new XAException(rollbackAction);
                    }
                }
            }
        }
        this.setState(32);
    }

    @Override
    public boolean setTransactionTimeout(int seconds) throws XAException {
        _XAEvents.add(new XAEvent(XAEventCode.SETTRANSACTIONTIMEOUT, this._key));
        int setTransactionTimeoutAction = this.self().getSetTransactionTimeoutAction();
        switch (setTransactionTimeoutAction) {
            case -5000: {
                System.out.println(this.getClass().getCanonicalName() + ".setTransactionTimeout(" + seconds + "): TRUE");
                return true;
            }
            case -6000: {
                System.out.println(this.getClass().getCanonicalName() + ".setTransactionTimeout(" + seconds + "): FALSE");
                return false;
            }
        }
        XAException e = new XAException(setTransactionTimeoutAction);
        System.out.println(this.getClass().getCanonicalName() + ".setTransactionTimeout(" + seconds + "): " + e.toString());
        throw e;
    }

    @Override
    public void start(Xid xid, int flags) throws XAException {
        if (dumped) {
            throw new AlreadyDumpedException("Test resource state was already dumped");
        }
        System.out.println("start(" + this._key + ", " + xid + ", " + flags + ")");
        _XAEvents.add(new XAEvent(XAEventCode.START, this._key));
        this.setState(8);
        this.self().setXid(xid);
        int startAction = this.self().getStartAction();
        if (startAction != 0) {
            switch (startAction) {
                case -1000: {
                    throw new RuntimeException();
                }
                case -2000: {
                    this.killDoomedServers(false);
                }
            }
            throw new XAException(startAction);
        }
    }

    private void setState(int state) {
        this.self().setState(state);
    }

    public XAResourceImpl setPrepareAction(int action) {
        this.self().setPrepareAction(action);
        switch (action) {
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                this.self().setHeuristic(true);
                break;
            }
        }
        return this;
    }

    public XAResourceImpl setRollbackAction(int action) {
        this.self().setRollbackAction(action);
        switch (action) {
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                this.self().setHeuristic(true);
                break;
            }
        }
        return this;
    }

    public XAResourceImpl setEndAction(int action) {
        this.self().setEndAction(action);
        return this;
    }

    public XAResourceImpl setStartAction(int action) {
        this.self().setStartAction(action);
        return this;
    }

    public XAResourceImpl setCommitSuicide(boolean b) {
        this.self().setCommitSuicide(b);
        return this;
    }

    public XAResourceImpl setForgetAction(int action) {
        this.self().setForgetAction(action);
        return this;
    }

    public XAResourceImpl setRecoverDelay(int seconds) {
        this.self().setRecoverDelay(seconds);
        return this;
    }

    public XAResourceImpl setRecoverAction(int action) {
        this.self().setRecoverAction(action);
        return this;
    }

    public XAResourceImpl setCommitAction(int action) {
        this.self().setCommitAction(action);
        switch (action) {
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                this.self().setHeuristic(true);
                break;
            }
        }
        return this;
    }

    public XAResourceImpl setSetTransactionTimeoutAction(int action) {
        this.self().setSetTransactionTimeoutAction(action);
        return this;
    }

    public XAResourceImpl setCommitRepeatCount(int repeat) {
        this.self().setCommitRepeatCount(repeat);
        return this;
    }

    public int getCommitRepeatCount() {
        return this.self().getCommitRepeatCount();
    }

    public XAResourceImpl setRecoverRepeatCount(int repeat) {
        this.self().setRecoverRepeatCount(repeat);
        return this;
    }

    public int getRecoverRepeatCount() {
        return this.self().getRecoverRepeatCount();
    }

    public XAResourceImpl setRollbackRepeatCount(int repeat) {
        this.self().setRollbackRepeatCount(repeat);
        return this;
    }

    public int getRollbackCount() {
        return this.self().getRollbackCount();
    }

    public int getForgetCount() {
        return this.self().getForgetCount();
    }

    public XAResourceImpl setForgetRepeatCount(int repeat) {
        this.self().setForgetRepeatCount(repeat);
        return this;
    }

    public int getForgetRepeatCount() {
        return this.self().getForgetRepeatCount();
    }

    public int getStatusDuringPrepare() {
        return this.self().getStatusDuringPrepare();
    }

    public int getStatusDuringRollback() {
        return this.self().getStatusDuringRollback();
    }

    public int getStatusDuringCommit() {
        return this.self().getStatusDuringCommit();
    }

    public UUID getRM() {
        return this.self().getRM();
    }

    public void setRM(UUID rm) {
        this.self().setRM(rm);
    }

    public boolean inState(int state) {
        return this.self().inState(state);
    }

    public int getCommitOrder() {
        return this.self().getCommitOrder();
    }

    public void setAmBusyInLongRunningQuery(boolean busy) {
        this.self().setAmBusyInLongRunningQuery(busy);
    }

    public boolean isBusyInLongRunningQuery() {
        boolean isBusy = this.self().isBusyInLongRunningQuery();
        return isBusy;
    }

    public void setQueryAborted() {
        this.self().setQueryAborted();
    }

    public boolean isQueryAborted() {
        boolean aborted = this.self().isQueryAborted();
        return aborted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void simulateLongRunningQuery(int queryLength) {
        if (DEBUG_OUTPUT) {
            System.out.println("simulateLongRunningQuery(" + this._key + ", " + queryLength + ")");
        }
        SimpleDateFormat df = new SimpleDateFormat("dd-MM-yy:HH:mm:ss");
        this.setAmBusyInLongRunningQuery(true);
        LongSQLQuerySim sqlSim = new LongSQLQuerySim(queryLength * 1000);
        sqlSim.start();
        Date date = new Date();
        if (DEBUG_OUTPUT) {
            System.out.println("simulateLongRunningQuery: Back from call to simulate a long duration SQL query with object, " + sqlSim + ", at: " + df.format(date));
        }
        LongSQLQuerySim longSQLQuerySim = sqlSim;
        synchronized (longSQLQuerySim) {
            block11: {
                try {
                    date = new Date();
                    if (sqlSim.isBusy()) {
                        if (DEBUG_OUTPUT) {
                            System.out.println("Servlet: Start waiting for simulated long query to complete its work at: " + df.format(date));
                        }
                        sqlSim.wait();
                    } else if (DEBUG_OUTPUT) {
                        System.out.println("Servlet: Long SQL query has already finished at: " + df.format(date));
                    }
                }
                catch (InterruptedException iex) {
                    date = new Date();
                    if (!DEBUG_OUTPUT) break block11;
                    System.out.println("Servlet: InterruptedException: simulated long query interrupted at: " + df.format(date));
                }
            }
        }
    }

    public static boolean allInState(int state) {
        for (XAResourceData res : _resources.values()) {
            if (res.inState(state)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printState() {
        StringBuffer sb = new StringBuffer();
        sb.append("Resources:\n");
        _resources.entrySet().stream().forEach(e -> sb.append(e.getValue()).append("\n"));
        sb.append("XA History: ");
        boolean needComma = false;
        List<XAEvent> list = _XAEvents;
        synchronized (list) {
            for (XAEvent event : _XAEvents) {
                if (needComma) {
                    sb.append(", ");
                } else {
                    needComma = true;
                }
                sb.append(event);
            }
        }
        System.out.println(sb.toString());
    }

    public static String checkAtomicity() {
        int committed = 0;
        int prepared = 0;
        int rolledback = 0;
        int numResources = 0;
        StringBuffer sb = new StringBuffer();
        for (XAResourceData res : _resources.values()) {
            if (null != res.getXids()) {
                ++numResources;
                if (res.inState(2)) {
                    ++committed;
                } else if (res.inState(32)) {
                    ++rolledback;
                } else if (res.inState(16)) {
                    ++prepared;
                } else {
                    ++rolledback;
                }
                sb.append(res.stateFormatter()).append(": ").append(res.key).append(" ");
                continue;
            }
            System.out.println("Resource has null Xid. Ignoring in checkAtomicity(): " + res);
        }
        if (committed > 0) {
            if (committed != numResources) {
                return "Unatomic (" + numResources + ") (" + sb.toString() + ")";
            }
            return "allCommitted (" + numResources + ") (" + sb.toString() + ")";
        }
        if (rolledback > 0) {
            if (rolledback != numResources) {
                return "Unatomic (" + numResources + ") (" + sb.toString() + ")";
            }
            return "allRollback (" + numResources + ") (" + sb.toString() + ")";
        }
        if (prepared > 0) {
            return "Unatomic (" + numResources + ") (" + sb.toString() + ")";
        }
        return "allRollback (" + numResources + ") (" + sb.toString() + ")";
    }

    public static boolean checkForgotten() {
        for (XAResourceData res : _resources.values()) {
            if (!res.isHeuristic() || res.isForgotten()) continue;
            return false;
        }
        return true;
    }

    public void setHeuristic() {
        this.self().setHeuristic(true);
    }

    public XAResourceImpl setSleepTime(int sleepTime) {
        this.self().setSleepTime(sleepTime);
        return this;
    }

    private XAResourceData self() {
        XAResourceData xard = _resources.get(this._key);
        if (xard == null) {
            System.out.println("self() is about to return null: >" + this._key + "<");
            for (String key : _resources.keySet()) {
                System.out.println("Key: >" + this._key + "<");
                System.out.println("Value: " + _resources.get(key));
            }
        }
        return xard;
    }

    public static synchronized int resourceCount() {
        if (!_stateLoaded) {
            XAResourceImpl.loadState();
        }
        return _resources.size();
    }

    public static synchronized boolean clear() {
        System.out.println("XAResourceImpl.clear(): Deleting state file: " + STATE_FILE.getAbsolutePath());
        _XAEvents.clear();
        _resources.clear();
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                if (STATE_FILE.exists()) {
                    boolean result = STATE_FILE.delete();
                    System.out.println("Deletion " + (result ? "succeeded" : "failed"));
                    return result;
                }
                System.out.println("Deletion not required");
                return false;
            }
        });
    }

    public static synchronized void dumpState() {
        XAResourceImpl.dumpState(false);
    }

    public static synchronized void dumpState(boolean quietly) {
        stateKeeper.dumpState(quietly);
        System.out.println(DUMP_STATE + _resources.values().size());
    }

    public static synchronized int loadState() {
        int numResources = stateKeeper.loadState();
        _stateLoaded = true;
        XAResourceImpl.printState();
        return numResources;
    }

    public static void destroy(XAResourceImpl xaRes) {
        System.out.println("Destroying: " + xaRes._key);
    }

    public static List<XAEvent> getXAEvents() {
        return _XAEvents;
    }

    private String actionFormatter(int action) {
        switch (action) {
            case -7: {
                return "RMFAIL";
            }
            case 100: {
                return "ROLLBACK";
            }
            case 3: {
                return "READONLY";
            }
            case -1000: {
                return "RUNTIME_EXCEPTION";
            }
            case -8000: {
                return "CONDITIONAL_RUNTIME_EXCEPTION";
            }
            case -2000: {
                return "DIE";
            }
            case -3000: {
                return "SLEEP_COMMIT";
            }
            case -4000: {
                return "SLEEP_ROLLBACK";
            }
            case -5000: {
                return "RETURN_TRUE";
            }
            case -6000: {
                return "RETURN_FALSE";
            }
            case -7000: {
                return "SLEEP_RECOVER";
            }
        }
        return "NO ACTION (" + action + ")";
    }

    public void setDoomedServer(URL url) {
        this.self().setDoomedServer(url);
    }

    public static synchronized void loadState(File stateFile) {
        XAResourceImpl.setStateFile(stateFile);
        XAResourceImpl.loadState();
    }

    public static File getStateFile() {
        return STATE_FILE;
    }

    private static Path getWakeUpFile() {
        if (null == wakeUpFile) {
            wakeUpFile = AccessController.doPrivileged(new PrivilegedAction<Path>(){

                @Override
                public Path run() {
                    return Paths.get(System.getProperty("java.io.tmpdir"), "wakeywakey.dat");
                }
            });
        }
        return wakeUpFile;
    }

    public static void wakeUp() throws IOException {
        Files.createFile(XAResourceImpl.getWakeUpFile(), new FileAttribute[0]);
    }

    public static void resetWakeUp() throws IOException {
        if (wakeUpFile != null) {
            Files.deleteIfExists(wakeUpFile);
        }
    }

    static {
        _resources = new ConcurrentHashMap();
        if (stateKeeper == null) {
            System.out.println("Setting regular state keeper");
            stateKeeper = new StateKeeperImpl();
        }
        _XAEvents = Collections.synchronizedList(new ArrayList());
        _commitSequence = new AtomicInteger(0);
        STATE_FILE = new File("XAResourceData.dat");
        DEBUG_OUTPUT = true;
    }

    public class XAResourceData
    implements Serializable {
        private static final long serialVersionUID = -253646295143893358L;
        public final String key;
        private UUID RM;
        private int prepareAction = 0;
        private int rollbackAction = 0;
        private int commitAction = 0;
        private int endAction = 0;
        private int startAction = 0;
        private int forgetAction = 0;
        private int recoverAction = 0;
        private int setTransactionTimeoutAction = -5000;
        private int expectedDirection = 2;
        private int commitRepeatCount;
        private int rollbackRepeatCount;
        private int forgetRepeatCount;
        private int recoverDelay = 120;
        private int recoverRepeatCount;
        private int statusDuringCommit;
        private int statusDuringRollback;
        private int statusDuringPrepare;
        private int rollbackCount;
        private int forgetCount;
        private boolean heuristic;
        private int _sleepTime;
        private HashSet<XID> _xids;
        private int _state = 1;
        private boolean busyInLongRunningQuery;
        private boolean queryAborted;
        private boolean commitSuicide = true;
        URL doomedServer;
        private int _commitOrder;

        public void setDoomedServer(URL url) {
            this.doomedServer = url;
        }

        public int getExpectedDirection() {
            return this.expectedDirection;
        }

        public void setExpectedDirection(int expectedDirection) {
            StringBuffer sb = new StringBuffer("setExpectedDirection(").append(XAResourceImpl.this._key).append(", ");
            if (expectedDirection == 0) {
                sb.append("commit");
            } else if (expectedDirection == 1) {
                sb.append("rollback");
            } else if (expectedDirection == 2) {
                sb.append("either");
            }
            sb.append(")");
            System.out.println(sb.toString());
            this.expectedDirection = expectedDirection;
        }

        public URL getDoomedServer() {
            return this.doomedServer;
        }

        public void setCommitSuicide(boolean b) {
            this.commitSuicide = b;
        }

        public boolean getCommitSuicide() {
            return this.commitSuicide;
        }

        public void setSleepTime(int sleepTime) {
            this._sleepTime = sleepTime;
        }

        public int getSleepTime() {
            return this._sleepTime;
        }

        public HashSet<XID> getXids() {
            return this._xids;
        }

        public void setXid(Xid xid) {
            System.out.println("setXid(" + XAResourceImpl.this._key + ", " + xid + ")");
            if (this._xids != null) {
                System.out.println("_xid was already set: " + this._xids.size());
            } else {
                this._xids = new HashSet();
            }
            this._xids.add(new XID(xid.getFormatId(), xid.getGlobalTransactionId(), xid.getBranchQualifier()));
        }

        public int getState() {
            return this._state;
        }

        public void setState(int state) {
            this._state |= state;
        }

        public XAResourceData(String _key) {
            this.key = _key;
            this.RM = UUID.randomUUID();
        }

        public int getCommitAction() {
            System.out.println("getCommitAction(" + XAResourceImpl.this._key + ") = " + XAResourceImpl.this.actionFormatter(this.commitAction));
            return this.commitAction;
        }

        public void setCommitAction(int commitAction) {
            System.out.println("setCommitAction(" + XAResourceImpl.this._key + ", " + XAResourceImpl.this.actionFormatter(commitAction) + ")");
            this.commitRepeatCount = 0;
            this.commitAction = commitAction;
        }

        public int getSetTransactionTimeoutAction() {
            return this.setTransactionTimeoutAction;
        }

        public void setSetTransactionTimeoutAction(int action) {
            this.setTransactionTimeoutAction = action;
        }

        public int getPrepareAction() {
            return this.prepareAction;
        }

        public void setPrepareAction(int prepareAction) {
            System.out.println("setPrepareAction(" + XAResourceImpl.this._key + ", " + XAResourceImpl.this.actionFormatter(prepareAction) + ")");
            this.prepareAction = prepareAction;
        }

        public UUID getRM() {
            return this.RM;
        }

        public void setRM(UUID rm) {
            this.RM = rm;
        }

        public int getRollbackAction() {
            return this.rollbackAction;
        }

        public void setRollbackAction(int rollbackAction) {
            System.out.println("setRollbackAction(" + XAResourceImpl.this._key + ", " + XAResourceImpl.this.actionFormatter(rollbackAction) + ")");
            this.rollbackAction = rollbackAction;
        }

        public int getRecoverAction() {
            return this.recoverAction;
        }

        public void setRecoverAction(int recoverAction) {
            System.out.println("setRecoverAction(" + XAResourceImpl.this._key + ", " + XAResourceImpl.this.actionFormatter(recoverAction) + ")");
            this.recoverAction = recoverAction;
        }

        public int getStatusDuringCommit() {
            return this.statusDuringCommit;
        }

        public void setStatusDuringCommit(int statusDuringCommit) {
            this.statusDuringCommit = statusDuringCommit;
        }

        public int getStatusDuringRollback() {
            return this.statusDuringRollback;
        }

        public void setStatusDuringRollback(int statusDuringRollback) {
            this.statusDuringRollback = statusDuringRollback;
        }

        public int getStatusDuringPrepare() {
            return this.statusDuringPrepare;
        }

        public void setStatusDuringPrepare(int statusDuringPrepare) {
            this.statusDuringPrepare = statusDuringPrepare;
        }

        public boolean isForgotten() {
            return (this._state & 0x40) != 0;
        }

        public boolean isHeuristic() {
            return this.heuristic;
        }

        public void setHeuristic(boolean heuristic) {
            this.heuristic = heuristic;
        }

        public int getEndAction() {
            return this.endAction;
        }

        public void setEndAction(int endAction) {
            this.endAction = endAction;
        }

        public int getCommitRepeatCount() {
            return this.commitRepeatCount;
        }

        public void setCommitRepeatCount(int commitRepeatCount) {
            this.commitRepeatCount = commitRepeatCount;
        }

        public int getRecoverDelay() {
            return this.recoverDelay;
        }

        public void setRecoverDelay(int recoverDelay) {
            System.out.println("setRecoverDelay(" + XAResourceImpl.this._key + ", " + recoverDelay + ")");
            this.recoverDelay = recoverDelay;
        }

        public int getRecoverRepeatCount() {
            return this.recoverRepeatCount;
        }

        public void setRecoverRepeatCount(int recoverRepeatCount) {
            System.out.println("setRecoverRepeatCount(" + XAResourceImpl.this._key + ", " + recoverRepeatCount + ")");
            this.recoverRepeatCount = recoverRepeatCount;
        }

        public int getForgetRepeatCount() {
            return this.forgetRepeatCount;
        }

        public void setForgetRepeatCount(int forgetRepeatCount) {
            this.forgetRepeatCount = forgetRepeatCount;
        }

        public int getForgetAction() {
            return this.forgetAction;
        }

        public void setForgetAction(int forgetAction) {
            this.forgetAction = forgetAction;
        }

        public int getRollbackCount() {
            return this.rollbackCount;
        }

        public void setRollbackCount(int rollbackCount) {
            this.rollbackCount = rollbackCount;
        }

        public int getRollbackRepeatCount() {
            return this.rollbackRepeatCount;
        }

        public void setRollbackRepeatCount(int rollbackRepeatCount) {
            this.rollbackRepeatCount = rollbackRepeatCount;
        }

        public int getStartAction() {
            return this.startAction;
        }

        public void setStartAction(int startAction) {
            this.startAction = startAction;
        }

        public int getForgetCount() {
            return this.forgetCount;
        }

        public void setForgetCount(int forgetCount) {
            this.forgetCount = forgetCount;
        }

        public boolean inState(int state) {
            return (this._state & state) != 0;
        }

        public void setAmBusyInLongRunningQuery(boolean busy) {
            this.busyInLongRunningQuery = busy;
        }

        public boolean isBusyInLongRunningQuery() {
            return this.busyInLongRunningQuery;
        }

        public void setQueryAborted() {
            this.queryAborted = true;
        }

        public boolean isQueryAborted() {
            return this.queryAborted;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer("Resource: " + this.key + "\n");
            sb.append("RM: " + this.RM);
            sb.append("\nState: " + this.stateFormatter());
            sb.append("\nXid: " + this._xids);
            sb.append("\nCommit order: " + this._commitOrder);
            sb.append("\nRecover action: " + XAResourceImpl.this.actionFormatter(this.recoverAction));
            return sb.toString();
        }

        private String stateFormatter() {
            StringBuffer sb = new StringBuffer("NOT STARTED");
            if (this.inState(8)) {
                sb.append(", STARTED");
            }
            if (this.inState(4)) {
                sb.append(", ENDED");
            }
            if (this.inState(16)) {
                sb.append(", PREPARED");
            }
            if (this.inState(2)) {
                sb.append(", COMMITTED");
            }
            if (this.inState(32)) {
                sb.append(", ROLLEDBACK");
            }
            if (this.inState(64)) {
                sb.append(", FORGOTTEN");
            }
            if (this.inState(128)) {
                sb.append(", RECOVERED");
            }
            if (this.inState(256)) {
                sb.append(", COMMITTED_ONE_PHASE");
            }
            return sb.toString();
        }

        public int getCommitOrder() {
            return this._commitOrder;
        }

        public void setCommitOrder(int commitOrder) {
            this._commitOrder = commitOrder;
        }

        class TestXidImpl
        implements Xid,
        Serializable {
            private static final long serialVersionUID = 1747768416841464440L;
            protected final int _formatId;
            protected final byte[] _gtrid;
            protected final byte[] _bqual;

            public TestXidImpl(Xid xid) {
                this._formatId = xid.getFormatId();
                this._gtrid = Util.duplicateByteArray((byte[])xid.getGlobalTransactionId());
                this._bqual = Util.duplicateByteArray((byte[])xid.getBranchQualifier());
            }

            @Override
            public byte[] getBranchQualifier() {
                return this._bqual;
            }

            @Override
            public int getFormatId() {
                return this._formatId;
            }

            @Override
            public byte[] getGlobalTransactionId() {
                return this._gtrid;
            }

            public String toString() {
                return "Format id: " + Integer.toHexString(this._formatId) + "\n\tGtrid: " + Util.toHexString((byte[])this._gtrid) + "\n\tBqual: " + Util.toHexString((byte[])this._bqual);
            }
        }
    }

    public class XAEvent {
        private final XAEventCode _event;
        private final String _key;

        public XAEvent(XAEventCode event, String _key2) {
            this._event = event;
            this._key = _key2;
        }

        public boolean isSameAs(XAEventCode event, int key) {
            return event == this._event && this._key.equals(key);
        }

        public String toString() {
            return (Object)((Object)this._event) + " " + this._key;
        }
    }

    public static enum XAEventCode {
        START,
        END,
        PREPARE,
        COMMIT,
        ROLLBACK,
        RECOVER,
        FORGET,
        SETTRANSACTIONTIMEOUT;

    }

    public class LongSQLQuerySim
    extends Thread {
        private final int _busyperiod;

        public LongSQLQuerySim(int busyperiod) {
            this._busyperiod = busyperiod;
        }

        public boolean isBusy() {
            boolean isBusy = XAResourceImpl.this.isBusyInLongRunningQuery();
            return isBusy;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Date date = null;
            long startTime = 0L;
            long endTime = 0L;
            long timeDiff = 0L;
            LongSQLQuerySim longSQLQuerySim = this;
            synchronized (longSQLQuerySim) {
                SimpleDateFormat df = new SimpleDateFormat("dd-MM-yy:HH:mm:ss");
                try {
                    date = new Date();
                    startTime = date.getTime();
                    long count = this._busyperiod / 250;
                    if (DEBUG_OUTPUT) {
                        System.out.println("Simulated long query started at: " + df.format(date) + ", looping over " + count);
                    }
                    for (long counter = 0L; XAResourceImpl.this.isBusyInLongRunningQuery() && counter < count; ++counter) {
                        Thread.sleep(250L);
                    }
                }
                catch (InterruptedException e) {
                    if (DEBUG_OUTPUT) {
                        System.out.println("Simulated long query interrupted");
                    }
                    e.printStackTrace();
                }
                finally {
                    date = new Date();
                    endTime = date.getTime();
                    timeDiff = (endTime - startTime) / 1000L;
                    String elapsedString = "" + timeDiff;
                    if (DEBUG_OUTPUT) {
                        System.out.println("Simulated long query finished at: " + df.format(date) + "after: " + elapsedString);
                    }
                    XAResourceImpl.this.setAmBusyInLongRunningQuery(false);
                    this.notify();
                }
            }
        }
    }

    static class StateKeeperImpl
    implements StateKeeper {
        StateKeeperImpl() {
        }

        @Override
        public void dumpState(boolean quietly) {
            dumped = !quietly;
            System.out.println("Dumping state to " + STATE_FILE);
            XAResourceImpl.printState();
            try (FileOutputStream fos = new FileOutputStream(STATE_FILE);
                 ObjectOutputStream oos = new ObjectOutputStream(fos);){
                _resources.entrySet().stream().forEach(e -> {
                    try {
                        XAResourceData xares = (XAResourceData)e.getValue();
                        System.out.println("Dump Object:\n" + xares);
                        oos.writeObject(xares);
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                });
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        @Override
        public int loadState() {
            new Throwable("com.ibm.tx.jta.ut.util.StateKeeper#loadState()").printStackTrace(System.out);
            int resourceCount = 0;
            _commitSequence.set(0);
            ObjectInputStream ois = null;
            String resKey = "!!!!!!!!";
            FileInputStream fos = null;
            try {
                fos = new FileInputStream(STATE_FILE);
                ois = new ObjectInputStream(fos);
                while (true) {
                    XAResourceData xares = (XAResourceData)ois.readObject();
                    resKey = xares.key;
                    _resources.put(resKey, xares);
                    ++resourceCount;
                }
            }
            catch (EOFException e) {
                System.out.println("Loaded " + resourceCount + " resources");
                try {
                    if (ois != null) {
                        ois.close();
                    }
                    if (fos != null) {
                        fos.close();
                    }
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            }
            catch (FileNotFoundException e) {
                System.out.println("Loaded " + resourceCount + " resources");
            }
            catch (Exception e) {
                e.printStackTrace();
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                try {
                    if (ois != null) {
                        ois.close();
                    }
                    if (fos != null) {
                        fos.close();
                    }
                }
                catch (IOException e3) {
                    e3.printStackTrace();
                }
            }
            {
                finally {
                    try {
                        if (ois != null) {
                            ois.close();
                        }
                        if (fos != null) {
                            fos.close();
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            return resourceCount;
        }
    }
}

