/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.tx.jta.ut.util;

import com.ibm.tx.jta.ExtendedTransactionManager;
import com.ibm.tx.jta.TransactionInflowManager;
import com.ibm.tx.jta.TransactionManagerFactory;
import com.ibm.tx.jta.ut.util.XID;
import jakarta.resource.spi.XATerminator;
import jakarta.resource.spi.work.ExecutionContext;
import jakarta.resource.spi.work.WorkCompletedException;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import javax.transaction.xa.Xid;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

@WebServlet(value={"/inflowmanager"})
public class InflowManagerTestServlet
extends HttpServlet {
    public static final String SUCCESS_MESSAGE = "COMPLETED SUCCESSFULLY";
    public static final String providerID = "Jon's RA";
    private TransactionInflowManager tim;
    private XATerminator xat;
    private ExtendedTransactionManager tm;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String test = request.getParameter("test");
        PrintWriter out = response.getWriter();
        out.println("Starting " + test + "<br>");
        try {
            ((Object)((Object)this)).getClass().getMethod(test, HttpServletRequest.class, HttpServletResponse.class).invoke((Object)this, request, response);
            out.println(test + " " + SUCCESS_MESSAGE);
        }
        catch (Throwable x) {
            if (x instanceof InvocationTargetException) {
                x = x.getCause();
            }
            out.println("<pre>ERROR in " + test + ":");
            x.printStackTrace(out);
            out.println("</pre>");
        }
    }

    public void testEC001(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ExecutionContext ec = new ExecutionContext();
        ec.setTransactionTimeout(120L);
        if (this.tm.getStatus() != 6) {
            throw new Exception("Unexpected transaction on thread (1)");
        }
        XID xid = new XID(180, "MAMWL1".getBytes(), "CAL".getBytes());
        ec.setXid((Xid)xid);
        this.tim.associate(ec, providerID);
        if (this.tm.getStatus() != 0) {
            throw new Exception("No transaction on thread");
        }
        this.tim.dissociate();
        if (this.tm.getStatus() != 6) {
            throw new Exception("Unexpected transaction on thread (2)");
        }
        this.xat.commit((Xid)xid, true);
    }

    public void testEC002(HttpServletRequest request, HttpServletResponse response) throws Exception {
        XID xid;
        block5: {
            ExecutionContext ec = new ExecutionContext();
            ec.setTransactionTimeout(120L);
            if (this.tm.getStatus() != 6) {
                throw new Exception("Unexpected transaction on thread (1)");
            }
            xid = new XID(180, "MAMWL1".getBytes(), "CAL".getBytes());
            ec.setXid((Xid)xid);
            this.tim.associate(ec, providerID);
            if (this.tm.getStatus() != 0) {
                throw new Exception("No transaction on thread");
            }
            try {
                this.tim.associate(ec, providerID);
            }
            catch (WorkCompletedException e) {
                if (e.getErrorCode().equals("3")) break block5;
                throw e;
            }
        }
        this.tim.dissociate();
        if (this.tm.getStatus() != 6) {
            throw new Exception("Unexpected transaction on thread (2)");
        }
        this.xat.commit((Xid)xid, true);
    }

    public void testEC003(HttpServletRequest request, HttpServletResponse response) throws Exception {
        block4: {
            ExecutionContext ec = new ExecutionContext();
            ec.setTransactionTimeout(120L);
            if (this.tm.getStatus() != 6) {
                throw new Exception("Unexpected transaction on thread (1)");
            }
            XID xid = new XID(180, "MAMWL1".getBytes(), "CAL".getBytes());
            ec.setXid((Xid)xid);
            this.tm.begin();
            if (this.tm.getStatus() != 0) {
                throw new Exception("No transaction on thread");
            }
            try {
                this.tim.associate(ec, providerID);
            }
            catch (WorkCompletedException e) {
                if (e.getErrorCode().equals("3")) break block4;
                throw e;
            }
        }
        this.tm.commit();
    }

    public void init() throws ServletException {
        super.init();
        BundleContext bc = FrameworkUtil.getBundle(Servlet.class).getBundleContext();
        ServiceTracker st = new ServiceTracker(bc, TransactionInflowManager.class, null);
        st.open();
        ServiceReference sr = st.getServiceReference();
        this.tim = (TransactionInflowManager)bc.getService(sr);
        this.xat = this.tim.getXATerminator(providerID);
        this.tm = TransactionManagerFactory.getTransactionManager();
    }
}

