/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.tx.jta.ut.util;

import com.ibm.tx.jta.ut.util.HADBTestConstants;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;

public class HADBTestControl {
    private static final String controlFilename = "testControl.csv";
    private static Path testControlPath;
    private static final String DELIMITER = ",";
    private HADBTestConstants.HADBTestType _testType;
    private int _failingOperation;
    private int _numberOfFailuresInt;
    private int _simsqlcodeInt;
    private String _sqltag;

    private HADBTestControl(String ... values) {
        this._testType = HADBTestConstants.HADBTestType.from(Integer.parseInt(values[0]));
        this._simsqlcodeInt = Integer.parseInt(values[1]);
        this._failingOperation = Integer.parseInt(values[2]);
        this._numberOfFailuresInt = Integer.parseInt(values[3]);
        this._sqltag = values.length > 4 ? values[4] : "";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static HADBTestControl read() {
        try (BufferedReader reader = Files.newBufferedReader(testControlPath);){
            String record = reader.lines().findFirst().orElse(null);
            if (record == null) return null;
            String[] values = record.split(DELIMITER);
            if (values.length <= 3) return null;
            HADBTestControl hADBTestControl = new HADBTestControl(values);
            return hADBTestControl;
        }
        catch (IOException | NullPointerException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static void clear() throws IOException {
        Files.deleteIfExists(testControlPath);
    }

    public String toString() {
        return String.join((CharSequence)DELIMITER, this._testType.toString(), String.valueOf(this._simsqlcodeInt), String.valueOf(this._failingOperation), String.valueOf(this._numberOfFailuresInt), this._sqltag);
    }

    public int getFailingOperation() {
        return this._failingOperation;
    }

    public int getNumberOfFailuresInt() {
        return this._numberOfFailuresInt;
    }

    public int getSimsqlcodeInt() {
        return this._simsqlcodeInt;
    }

    public String getSqltag() {
        return this._sqltag;
    }

    public HADBTestConstants.HADBTestType getTestType() {
        return this._testType;
    }

    public static void init(String serverSharedPath) {
        testControlPath = Paths.get(serverSharedPath, new String[0]).resolve(controlFilename);
    }

    public static void write(HADBTestConstants.HADBTestType testType, int simsqlcodeInt, int failingOperation, int numberOfFailuresInt) {
        HADBTestControl.write(testType, simsqlcodeInt, failingOperation, numberOfFailuresInt, "");
    }

    public static void write(HADBTestConstants.HADBTestType testType, int simsqlcodeInt, int failingOperation, int numberOfFailuresInt, String sqltag) {
        try (BufferedWriter bw = Files.newBufferedWriter(testControlPath, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);){
            bw.write(String.join((CharSequence)DELIMITER, String.valueOf(testType.ordinal()), String.valueOf(simsqlcodeInt), String.valueOf(failingOperation), String.valueOf(numberOfFailuresInt), sqltag));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setSqltag(String sqltag) {
        this._sqltag = sqltag;
    }
}

