/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jpa.management;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.jpa.management.JPANoTxEmInvocation;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.EntityTransaction;
import jakarta.persistence.FlushModeType;
import jakarta.persistence.LockModeType;
import jakarta.persistence.Query;
import jakarta.persistence.TypedQuery;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.metamodel.Metamodel;
import java.io.Serializable;
import java.util.Map;

public abstract class JPAEntityManager
implements EntityManager,
Serializable {
    private static final long serialVersionUID = -377956679492029198L;
    private static final TraceComponent tc = Tr.register(JPAEntityManager.class, (String)"JPA", (String)"com.ibm.ws.jpa.jpa");
    protected boolean ivUnsynchronized = false;

    protected JPAEntityManager() {
    }

    protected JPAEntityManager(boolean txUnsynchronized) {
        this.ivUnsynchronized = txUnsynchronized;
    }

    public boolean isTxUnsynchronized() {
        return this.ivUnsynchronized;
    }

    abstract EntityManager getEMInvocationInfo(boolean var1);

    abstract EntityManager getEMInvocationInfo(boolean var1, LockModeType var2);

    abstract void closeTxEntityManager(EntityManager var1, boolean var2);

    abstract void closeNoTxEntityManager(JPANoTxEmInvocation var1);

    public void persist(Object entity) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("em.persist(" + entity + ");\n" + this.toString()), (Object[])new Object[0]);
        }
        this.getEMInvocationInfo(true).persist(entity);
    }

    public <T> T merge(T entity) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("em.merge(" + entity + ");\n" + this.toString()), (Object[])new Object[0]);
        }
        return (T)this.getEMInvocationInfo(true).merge(entity);
    }

    public void remove(Object entity) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("em.remove(" + entity + ");\n" + this.toString()), (Object[])new Object[0]);
        }
        this.getEMInvocationInfo(true).remove(entity);
    }

    public void refresh(Object entity) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("em.refresh(" + entity + ");\n" + this.toString()), (Object[])new Object[0]);
        }
        this.getEMInvocationInfo(true).refresh(entity);
    }

    public <T> T find(Class<T> entityClass, Object primaryKey) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("em.find(" + entityClass + ',' + primaryKey + ");\n" + this.toString()), (Object[])new Object[0]);
        }
        return (T)this.getEMInvocationInfo(false).find(entityClass, primaryKey);
    }

    public <T> T getReference(Class<T> entityClass, Object primaryKey) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("em.getReference(" + entityClass + ',' + primaryKey + ");\n" + this.toString()), (Object[])new Object[0]);
        }
        return (T)this.getEMInvocationInfo(false).getReference(entityClass, primaryKey);
    }

    public void flush() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("em.flush();\n" + this.toString()), (Object[])new Object[0]);
        }
        this.getEMInvocationInfo(true).flush();
    }

    public void setFlushMode(FlushModeType flushMode) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("em.setFlushMode(" + flushMode + ");\n" + this.toString()), (Object[])new Object[0]);
        }
        this.getEMInvocationInfo(false).setFlushMode(flushMode);
    }

    public FlushModeType getFlushMode() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("em.getFlushMode() + getEmDebugString();\n" + this.toString()), (Object[])new Object[0]);
        }
        return this.getEMInvocationInfo(false).getFlushMode();
    }

    public void lock(Object entity, LockModeType lockMode) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("em.lock(" + entity + ',' + lockMode + ");\n" + this.toString()), (Object[])new Object[0]);
        }
        this.getEMInvocationInfo(true).lock(entity, lockMode);
    }

    public void clear() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("em.clear();\n" + this.toString()), (Object[])new Object[0]);
        }
        this.getEMInvocationInfo(false).clear();
    }

    public boolean contains(Object entity) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("em.contains(" + entity + ");\n" + this.toString()), (Object[])new Object[0]);
        }
        return this.getEMInvocationInfo(false).contains(entity);
    }

    public Query createQuery(String qlString) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("em.createQuery(" + qlString + ");\n" + this.toString()), (Object[])new Object[0]);
        }
        return this.getEMInvocationInfo(false).createQuery(qlString);
    }

    public Query createNamedQuery(String name) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("em.createNamedQuery(" + name + ");\n" + this.toString()), (Object[])new Object[0]);
        }
        return this.getEMInvocationInfo(false).createNamedQuery(name);
    }

    public Query createNativeQuery(String sqlString) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("em.createNativeQuery(" + sqlString + ");\n" + this.toString()), (Object[])new Object[0]);
        }
        return this.getEMInvocationInfo(false).createNativeQuery(sqlString);
    }

    public Query createNativeQuery(String sqlString, Class resultClass) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("em.createNativeQuery(" + sqlString + ',' + resultClass + ");\n" + this.toString()), (Object[])new Object[0]);
        }
        return this.getEMInvocationInfo(false).createNativeQuery(sqlString, resultClass);
    }

    public Query createNativeQuery(String sqlString, String resultSetMapping) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("em.createNativeQuery(" + sqlString + ',' + resultSetMapping + ");\n" + this.toString()), (Object[])new Object[0]);
        }
        return this.getEMInvocationInfo(false).createNativeQuery(sqlString, resultSetMapping);
    }

    public void joinTransaction() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("em.joinTransaction();\n" + this.toString()), (Object[])new Object[0]);
        }
        this.getEMInvocationInfo(true).joinTransaction();
    }

    public Object getDelegate() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("em.getDelegate();\n" + this.toString()), (Object[])new Object[0]);
        }
        return this.getEMInvocationInfo(false).getDelegate();
    }

    public void close() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("em.close();\n" + this.toString()), (Object[])new Object[0]);
        }
        throw new IllegalStateException("Can not close EntityManager session in container-managed entity manager (JPA 5.9.1).");
    }

    public boolean isOpen() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("em.isOpen();\n" + this.toString()), (Object[])new Object[0]);
        }
        return this.getEMInvocationInfo(false).isOpen();
    }

    public EntityTransaction getTransaction() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("em.getTransaction();\n" + this.toString()), (Object[])new Object[0]);
        }
        return this.getEMInvocationInfo(false).getTransaction();
    }

    public void detach(Object entity) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("em.detach(" + entity + ");\n" + this.toString()), (Object[])new Object[0]);
        }
        this.getEMInvocationInfo(false).detach(entity);
    }

    public <T> TypedQuery<T> createQuery(CriteriaQuery<T> arg0) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("em.createQuery();\n" + this.toString()), (Object[])new Object[0]);
        }
        return this.getEMInvocationInfo(false).createQuery(arg0);
    }

    public <T> T find(Class<T> arg0, Object arg1, LockModeType arg2) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("em.find();\n" + this.toString()), (Object[])new Object[0]);
        }
        return (T)this.getEMInvocationInfo(false, arg2).find(arg0, arg1, arg2);
    }

    public <T> T find(Class<T> arg0, Object arg1, LockModeType arg2, Map<String, Object> arg3) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("em.find();\n" + this.toString()), (Object[])new Object[0]);
        }
        return (T)this.getEMInvocationInfo(false, arg2).find(arg0, arg1, arg2, arg3);
    }

    public <T> T find(Class<T> arg0, Object arg1, Map<String, Object> arg2) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("em.find();\n" + this.toString()), (Object[])new Object[0]);
        }
        return (T)this.getEMInvocationInfo(false).find(arg0, arg1, arg2);
    }

    public EntityManagerFactory getEntityManagerFactory() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("em.getEntityManagerFactory();\n" + this.toString()), (Object[])new Object[0]);
        }
        return this.getEMInvocationInfo(false).getEntityManagerFactory();
    }

    public LockModeType getLockMode(Object arg0) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("em.getLockMode();\n" + this.toString()), (Object[])new Object[0]);
        }
        return this.getEMInvocationInfo(true).getLockMode(arg0);
    }

    public Map<String, Object> getProperties() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("em.getProperties();\n" + this.toString()), (Object[])new Object[0]);
        }
        return this.getEMInvocationInfo(false).getProperties();
    }

    public void setProperty(String arg0, Object arg1) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("em.setProperties();\n" + this.toString()), (Object[])new Object[0]);
        }
        this.getEMInvocationInfo(false).setProperty(arg0, arg1);
    }

    public CriteriaBuilder getCriteriaBuilder() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("em.getQueryBuilder();\n" + this.toString()), (Object[])new Object[0]);
        }
        return this.getEMInvocationInfo(false).getCriteriaBuilder();
    }

    public void lock(Object arg0, LockModeType arg1, Map<String, Object> arg2) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("em.lock();\n" + this.toString()), (Object[])new Object[0]);
        }
        this.getEMInvocationInfo(true).lock(arg0, arg1, arg2);
    }

    public void refresh(Object arg0, LockModeType arg1) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("em.refresh();\n" + this.toString()), (Object[])new Object[0]);
        }
        this.getEMInvocationInfo(true, arg1).refresh(arg0, arg1);
    }

    public void refresh(Object arg0, LockModeType arg1, Map<String, Object> arg2) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("em.refresh();\n" + this.toString()), (Object[])new Object[0]);
        }
        this.getEMInvocationInfo(true, arg1).refresh(arg0, arg1, arg2);
    }

    public void refresh(Object arg0, Map<String, Object> arg1) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("em.refresh();\n" + this.toString()), (Object[])new Object[0]);
        }
        this.getEMInvocationInfo(true).refresh(arg0, arg1);
    }

    public <T> T unwrap(Class<T> arg0) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("em.unwrap();\n" + this.toString()), (Object[])new Object[0]);
        }
        return (T)this.getEMInvocationInfo(false).unwrap(arg0);
    }

    public Metamodel getMetamodel() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("em.getMetaModel();\n" + this.toString()), (Object[])new Object[0]);
        }
        return this.getEMInvocationInfo(false).getMetamodel();
    }

    public <T> TypedQuery<T> createNamedQuery(String arg0, Class<T> arg1) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("em.createNamedQuery();\n" + this.toString()), (Object[])new Object[0]);
        }
        return this.getEMInvocationInfo(false).createNamedQuery(arg0, arg1);
    }

    public <T> TypedQuery<T> createQuery(String arg0, Class<T> arg1) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("em.createQuery();\n" + this.toString()), (Object[])new Object[0]);
        }
        return this.getEMInvocationInfo(false).createQuery(arg0, arg1);
    }
}

