/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsp.translator.visitor.generator;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.jsp.translator.visitor.generator.JavaCodeWriter;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringReader;
import java.util.Map;
import org.w3c.dom.Element;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@TraceOptions
public class JavaFileWriter
extends JavaCodeWriter {
    private static final int TAB_WIDTH = 2;
    private static final int NUMBER_OF_SPACES = 128;
    private char[] spaces = null;
    private int indent = 0;
    private int lineNum = 1;
    private int lineCount = 0;
    private int syntaxLineNum = 0;
    private Map jspElementMap = null;
    private Map cdataJspIdMap = null;
    private Map customTagMethodJspIdMap = null;
    private boolean newLine = true;
    static final long serialVersionUID = 1815131561564530941L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public JavaFileWriter(String filePath, Map jspElementMap, Map cdataJspIdMap, Map customTagMethodJspIdMap, String encoding) throws IOException {
        super(new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filePath), encoding))));
        this.jspElementMap = jspElementMap;
        this.cdataJspIdMap = cdataJspIdMap;
        this.customTagMethodJspIdMap = customTagMethodJspIdMap;
        this.spaces = new char[128];
        for (int i = 0; i < 128; ++i) {
            this.spaces[i] = 32;
        }
    }

    public JavaFileWriter(PrintWriter writer, Map jspElementMap, Map cdataJspIdMap, Map customTagMethodJspIdMap) throws IOException {
        super(writer);
        this.jspElementMap = jspElementMap;
        this.cdataJspIdMap = cdataJspIdMap;
        this.customTagMethodJspIdMap = customTagMethodJspIdMap;
        this.spaces = new char[128];
        for (int i = 0; i < 128; ++i) {
            this.spaces[i] = 32;
        }
    }

    @Override
    public void println(String line) {
        this.newLine = true;
        int index = 0;
        while ((index = line.indexOf(10, index)) > -1) {
            ++this.lineNum;
            ++this.lineCount;
            ++index;
        }
        if (line.indexOf("/* ElementId[") != -1) {
            Integer elementId = Integer.valueOf(line.substring(line.indexOf("/* ElementId[") + 13, line.indexOf("]")));
            Element e = (Element)this.jspElementMap.get(elementId);
            String jspId = e.getAttributeNS("http://java.sun.com/JSP/Page", "id");
            if (line.indexOf("sb") != -1) {
                this.lineCount = 0;
                this.syntaxLineNum = this.lineNum;
            } else if (line.indexOf("se") != -1) {
                jspId = jspId + ":[" + this.syntaxLineNum + "," + this.lineCount + "]";
                e.setAttributeNS("http://java.sun.com/JSP/Page", "jsp:id", jspId);
            } else if (line.indexOf("eb") != -1) {
                this.lineCount = 0;
                this.syntaxLineNum = this.lineNum;
            } else if (line.indexOf("ee") != -1) {
                jspId = jspId + "[" + this.syntaxLineNum + "," + this.lineCount + "]";
                e.setAttributeNS("http://java.sun.com/JSP/Page", "jsp:id", jspId);
            } else if (line.indexOf("ctmb") != -1) {
                this.lineCount = 0;
                this.syntaxLineNum = this.lineNum;
            } else if (line.indexOf("ctme") != -1) {
                this.customTagMethodJspIdMap.put(e, this.syntaxLineNum + "," + this.lineCount);
            }
        } else if (line.indexOf("/* CDATAId[") != -1) {
            Integer cdataId = Integer.valueOf(line.substring(line.indexOf("/* CDATAId[") + 11, line.indexOf("]")));
            String jspId = (String)this.cdataJspIdMap.get(cdataId);
            if (jspId != null) {
                if (line.indexOf("sb") != -1) {
                    this.lineCount = 0;
                    this.syntaxLineNum = this.lineNum;
                } else if (line.indexOf("se") != -1) {
                    jspId = jspId + ":[" + this.syntaxLineNum + "," + this.lineCount + "]";
                    this.cdataJspIdMap.put(cdataId, jspId);
                }
            }
        } else {
            int numberOfSpaces;
            ++this.lineCount;
            ++this.lineNum;
            int charCount = 0;
            charCount = this.lookFor('}', line);
            if (charCount > 0) {
                this.indent -= charCount;
            }
            if ((numberOfSpaces = this.indent * 2) > 0) {
                if (numberOfSpaces > this.spaces.length) {
                    this.reallocateSpaces();
                }
                this.write(this.spaces, 0, numberOfSpaces);
            }
            super.println(line);
            charCount = this.lookFor('{', line);
            if (charCount > 0) {
                this.indent += charCount;
            }
        }
    }

    @Override
    public void println() {
        this.newLine = true;
        ++this.lineCount;
        ++this.lineNum;
        super.println();
    }

    @Override
    public void print(String s) {
        int index = 0;
        if (s != null) {
            while ((index = s.indexOf(10, index)) > -1) {
                ++this.lineNum;
                ++this.lineCount;
                ++index;
            }
        }
        int charCount = 0;
        charCount = this.lookFor('}', s);
        if (charCount > 0) {
            this.indent -= charCount;
        }
        if (this.newLine) {
            int numberOfSpaces = this.indent * 2;
            if (numberOfSpaces > 0) {
                if (numberOfSpaces > this.spaces.length) {
                    this.reallocateSpaces();
                }
                this.write(this.spaces, 0, numberOfSpaces);
            }
            this.newLine = false;
        }
        super.print(s);
        charCount = this.lookFor('{', s);
        if (charCount > 0) {
            this.indent += charCount;
        }
    }

    @Override
    public void printMultiLn(String multiline) {
        BufferedReader reader = new BufferedReader(new StringReader(multiline));
        try {
            String line = null;
            while ((line = reader.readLine()) != null) {
                this.println(line);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private int lookFor(char character, String s) {
        int count = 0;
        boolean inQuotes = false;
        if (s != null) {
            for (int i = 0; i < s.length(); ++i) {
                char ch = s.charAt(i);
                if (ch == '\"') {
                    if (inQuotes) {
                        inQuotes = false;
                        continue;
                    }
                    inQuotes = true;
                    continue;
                }
                if (ch != character || inQuotes) continue;
                ++count;
            }
        }
        return count;
    }

    public int getCurrentLineNumber() {
        return this.lineNum;
    }

    private void reallocateSpaces() {
        int newSize = this.spaces.length + 128;
        this.spaces = new char[newSize];
        for (int i = 0; i < newSize; ++i) {
            this.spaces[i] = 32;
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.jsp.translator.visitor.generator.JavaFileWriter", JavaFileWriter.class, null, null);
    }
}

