/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.policy;

import jakarta.annotation.Resource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.apache.cxf.Bus;
import org.apache.cxf.common.injection.NoJSR250Annotations;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.configuration.ConfiguredBeanLocator;
import org.apache.cxf.extension.BusExtension;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.service.factory.FactoryBeanListener;
import org.apache.cxf.service.factory.FactoryBeanListenerManager;
import org.apache.cxf.service.model.BindingFaultInfo;
import org.apache.cxf.service.model.BindingMessageInfo;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.transport.Destination;
import org.apache.cxf.ws.policy.AlternativeSelector;
import org.apache.cxf.ws.policy.AssertionBuilderRegistry;
import org.apache.cxf.ws.policy.Assertor;
import org.apache.cxf.ws.policy.ClientPolicyInFaultInterceptor;
import org.apache.cxf.ws.policy.EffectivePolicy;
import org.apache.cxf.ws.policy.EffectivePolicyImpl;
import org.apache.cxf.ws.policy.EndpointPolicy;
import org.apache.cxf.ws.policy.EndpointPolicyImpl;
import org.apache.cxf.ws.policy.PolicyAnnotationListener;
import org.apache.cxf.ws.policy.PolicyEngine;
import org.apache.cxf.ws.policy.PolicyInInterceptor;
import org.apache.cxf.ws.policy.PolicyInterceptorProvider;
import org.apache.cxf.ws.policy.PolicyInterceptorProviderRegistry;
import org.apache.cxf.ws.policy.PolicyOutInterceptor;
import org.apache.cxf.ws.policy.PolicyProvider;
import org.apache.cxf.ws.policy.PolicyRegistryImpl;
import org.apache.cxf.ws.policy.PolicyUtils;
import org.apache.cxf.ws.policy.PolicyVerificationInFaultInterceptor;
import org.apache.cxf.ws.policy.ServerPolicyOutFaultInterceptor;
import org.apache.cxf.ws.policy.selector.MinimalAlternativeSelector;
import org.apache.neethi.Assertion;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyComponent;
import org.apache.neethi.PolicyOperator;
import org.apache.neethi.PolicyReference;
import org.apache.neethi.PolicyRegistry;

@NoJSR250Annotations(unlessNull={"bus"})
public class PolicyEngineImpl
implements PolicyEngine,
BusExtension {
    private static final Logger LOG = LogUtils.getL7dLogger(PolicyEngineImpl.class);
    private static final String POLICY_INFO_REQUEST_SERVER = "policy-engine-info-serve-request";
    private static final String POLICY_INFO_FAULT_SERVER = "policy-engine-info-serve-fault";
    private static final String POLICY_INFO_RESPONSE_SERVER = "policy-engine-info-serve-response";
    private static final String POLICY_INFO_ENDPOINT_SERVER = "policy-engine-info-serve-rendpoint";
    private static final String POLICY_INFO_REQUEST_CLIENT = "policy-engine-info-client-request";
    private static final String POLICY_INFO_FAULT_CLIENT = "policy-engine-info-client-fault";
    private static final String POLICY_INFO_RESPONSE_CLIENT = "policy-engine-info-client-response";
    private static final String POLICY_INFO_ENDPOINT_CLIENT = "policy-engine-info-client-endpoint";
    private Bus bus;
    private PolicyRegistry registry;
    private Collection<PolicyProvider> policyProviders;
    private Collection<PolicyProvider> preSetPolicyProviders = new LinkedList<PolicyProvider>();
    private Policy busPolicy;
    private boolean enabled = true;
    private Boolean ignoreUnknownAssertions;
    private boolean addedBusInterceptors;
    private AlternativeSelector alternativeSelector;
    private static boolean ignoreUnsupportedPolicy;

    public PolicyEngineImpl() {
        this.init();
    }

    public PolicyEngineImpl(boolean en) {
        this.enabled = en;
        this.init();
    }

    public PolicyEngineImpl(Bus b) {
        this.init();
        this.setBus(b);
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Resource
    public final void setBus(Bus b) {
        if (this.bus == b) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest("setBus: Bus already initialized, returning");
            }
            return;
        }
        this.bus = b;
        this.addBusInterceptors();
        FactoryBeanListenerManager fblm = (FactoryBeanListenerManager)this.bus.getExtension(FactoryBeanListenerManager.class);
        if (fblm != null) {
            for (FactoryBeanListener l : fblm.getListeners()) {
                if (!(l instanceof PolicyAnnotationListener)) continue;
                if (LOG.isLoggable(Level.FINEST)) {
                    LOG.finest("setBus: PolicyAnnotationListener instance found, returning");
                }
                return;
            }
            fblm.addListener((FactoryBeanListener)new PolicyAnnotationListener(this.bus));
        }
    }

    public Bus getBus() {
        return this.bus;
    }

    @Override
    public void addPolicy(Policy p) {
        this.busPolicy = this.busPolicy == null ? p : this.busPolicy.merge(p);
    }

    public void setPolicyProviders(Collection<PolicyProvider> p) {
        this.policyProviders = new CopyOnWriteArrayList<PolicyProvider>(p);
    }

    public synchronized void addPolicyProvider(PolicyProvider p) {
        if (this.policyProviders != null) {
            this.policyProviders.add(p);
        } else {
            this.preSetPolicyProviders.add(p);
        }
    }

    public synchronized Collection<PolicyProvider> getPolicyProviders() {
        if (this.policyProviders == null) {
            ConfiguredBeanLocator loc;
            this.policyProviders = new CopyOnWriteArrayList<PolicyProvider>();
            if (this.bus != null && (loc = (ConfiguredBeanLocator)this.bus.getExtension(ConfiguredBeanLocator.class)) != null) {
                loc.getBeansOfType(PolicyProvider.class);
            }
            this.policyProviders.addAll(this.preSetPolicyProviders);
            this.preSetPolicyProviders = null;
        }
        return this.policyProviders;
    }

    public void setRegistry(PolicyRegistry r) {
        this.registry = r;
    }

    @Override
    public PolicyRegistry getRegistry() {
        return this.registry;
    }

    @Override
    public synchronized void setEnabled(boolean e) {
        this.enabled = e;
        if (this.enabled && !this.addedBusInterceptors) {
            this.addBusInterceptors();
        } else if (!this.enabled && this.addedBusInterceptors) {
            this.removeBusInterceptors();
        }
    }

    @Override
    public synchronized AlternativeSelector getAlternativeSelector() {
        if (this.alternativeSelector == null && this.enabled) {
            this.alternativeSelector = new MinimalAlternativeSelector();
        }
        return this.alternativeSelector;
    }

    @Override
    public void setAlternativeSelector(AlternativeSelector as) {
        this.alternativeSelector = as;
    }

    @Override
    public boolean isIgnoreUnknownAssertions() {
        return this.ignoreUnknownAssertions == null || this.ignoreUnknownAssertions != false;
    }

    @Override
    public void setIgnoreUnknownAssertions(boolean ignore) {
        this.ignoreUnknownAssertions = ignore;
    }

    public Class<?> getRegistrationType() {
        return PolicyEngine.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EffectivePolicy getEffectiveClientRequestPolicy(EndpointInfo ei, BindingOperationInfo boi, Conduit c, Message m) {
        EffectivePolicy effectivePolicy = (EffectivePolicy)boi.getProperty(POLICY_INFO_REQUEST_CLIENT);
        if (effectivePolicy == null) {
            EndpointInfo endpointInfo = ei;
            synchronized (endpointInfo) {
                effectivePolicy = (EffectivePolicy)boi.getProperty(POLICY_INFO_REQUEST_CLIENT);
                if (null == effectivePolicy) {
                    EffectivePolicyImpl epi = this.createOutPolicyInfo();
                    Assertor assertor = PolicyUtils.createAsserter(c);
                    epi.initialise(ei, boi, this, assertor, true, true, m);
                    if (m != null) {
                        boi.setProperty(POLICY_INFO_REQUEST_CLIENT, (Object)epi);
                    }
                    effectivePolicy = epi;
                }
            }
        }
        return effectivePolicy;
    }

    @Override
    public void setEffectiveClientRequestPolicy(EndpointInfo ei, BindingOperationInfo boi, EffectivePolicy ep) {
        boi.setProperty(POLICY_INFO_REQUEST_CLIENT, (Object)ep);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EffectivePolicy getEffectiveServerResponsePolicy(EndpointInfo ei, BindingOperationInfo boi, Destination d, List<List<Assertion>> incoming, Message m) {
        if (incoming == null) {
            EffectivePolicy effectivePolicy = (EffectivePolicy)boi.getProperty(POLICY_INFO_RESPONSE_SERVER);
            if (effectivePolicy == null) {
                EndpointInfo endpointInfo = ei;
                synchronized (endpointInfo) {
                    effectivePolicy = (EffectivePolicy)boi.getProperty(POLICY_INFO_RESPONSE_SERVER);
                    if (null == effectivePolicy) {
                        EffectivePolicyImpl epi = this.createOutPolicyInfo();
                        Assertor assertor = PolicyUtils.createAsserter(d);
                        epi.initialise(ei, boi, this, assertor, false, false, null);
                        if (m != null) {
                            boi.setProperty(POLICY_INFO_RESPONSE_SERVER, (Object)epi);
                        }
                        effectivePolicy = epi;
                    }
                }
            }
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Returning effectivePolicy for null incoming");
            }
            return effectivePolicy;
        }
        EffectivePolicyImpl epi = this.createOutPolicyInfo();
        Assertor assertor = PolicyUtils.createAsserter(d);
        epi.initialise(ei, boi, (PolicyEngine)this, assertor, incoming, m);
        return epi;
    }

    @Override
    public void setEffectiveServerResponsePolicy(EndpointInfo ei, BindingOperationInfo boi, EffectivePolicy ep) {
        boi.setProperty(POLICY_INFO_RESPONSE_SERVER, (Object)ep);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EffectivePolicy getEffectiveServerFaultPolicy(EndpointInfo ei, BindingOperationInfo boi, BindingFaultInfo bfi, Destination d, Message m) {
        if (bfi == null) {
            EffectivePolicyImpl epi = this.createOutPolicyInfo();
            Assertor assertor = PolicyUtils.createAsserter(d);
            epi.initialise(ei, boi, null, this, assertor, m);
            return epi;
        }
        EffectivePolicy effectivePolicy = (EffectivePolicy)(bfi = this.mapToWrappedBindingFaultInfo(bfi)).getProperty(POLICY_INFO_FAULT_SERVER);
        if (effectivePolicy == null) {
            EndpointInfo endpointInfo = ei;
            synchronized (endpointInfo) {
                effectivePolicy = (EffectivePolicy)bfi.getProperty(POLICY_INFO_FAULT_SERVER);
                if (null == effectivePolicy) {
                    EffectivePolicyImpl epi = this.createOutPolicyInfo();
                    Assertor assertor = PolicyUtils.createAsserter(d);
                    epi.initialise(ei, boi, bfi, this, assertor, m);
                    if (m != null) {
                        bfi.setProperty(POLICY_INFO_FAULT_SERVER, (Object)epi);
                    }
                    effectivePolicy = epi;
                }
            }
        }
        return effectivePolicy;
    }

    private BindingFaultInfo mapToWrappedBindingFaultInfo(BindingFaultInfo bfi) {
        BindingOperationInfo boi = bfi.getBindingOperation();
        if (boi != null && boi.isUnwrapped()) {
            boi = boi.getWrappedOperation();
            for (BindingFaultInfo bf2 : boi.getFaults()) {
                if (!bf2.getFaultInfo().getName().equals(bfi.getFaultInfo().getName())) continue;
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("bf1 and bf2 faultinfo is same, returning bf2");
                }
                return bf2;
            }
        }
        return bfi;
    }

    @Override
    public void setEffectiveServerFaultPolicy(EndpointInfo ei, BindingFaultInfo bfi, EffectivePolicy ep) {
        bfi.setProperty(POLICY_INFO_FAULT_SERVER, (Object)ep);
    }

    @Override
    public EndpointPolicy getClientEndpointPolicy(EndpointInfo ei, Conduit conduit, Message m) {
        Assertor assertor = PolicyUtils.createAsserter(conduit);
        return this.getEndpointPolicy(ei, true, assertor, m);
    }

    @Override
    public EndpointPolicy getServerEndpointPolicy(EndpointInfo ei, Destination destination, Message m) {
        Assertor assertor = PolicyUtils.createAsserter(destination);
        return this.getEndpointPolicy(ei, false, assertor, m);
    }

    private EndpointPolicy getEndpointPolicy(EndpointInfo ei, boolean isRequestor, Assertor assertor, Message m) {
        return this.createEndpointPolicyInfo(ei, isRequestor, assertor, m);
    }

    @Override
    public void setClientEndpointPolicy(EndpointInfo ei, EndpointPolicy ep) {
        ei.setProperty(POLICY_INFO_ENDPOINT_CLIENT, (Object)ep);
    }

    @Override
    public void setServerEndpointPolicy(EndpointInfo ei, EndpointPolicy ep) {
        ei.setProperty(POLICY_INFO_ENDPOINT_SERVER, (Object)ep);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EffectivePolicy getEffectiveServerRequestPolicy(EndpointInfo ei, BindingOperationInfo boi, Message m) {
        EffectivePolicy effectivePolicy = (EffectivePolicy)boi.getProperty(POLICY_INFO_REQUEST_SERVER);
        if (effectivePolicy == null) {
            EndpointInfo endpointInfo = ei;
            synchronized (endpointInfo) {
                effectivePolicy = (EffectivePolicy)boi.getProperty(POLICY_INFO_REQUEST_SERVER);
                if (null == effectivePolicy) {
                    EffectivePolicyImpl epi = this.createOutPolicyInfo();
                    epi.initialise(ei, boi, (PolicyEngine)this, false, true, m);
                    if (m != null) {
                        boi.setProperty(POLICY_INFO_REQUEST_SERVER, (Object)epi);
                    }
                    effectivePolicy = epi;
                }
            }
        }
        return effectivePolicy;
    }

    @Override
    public void setEffectiveServerRequestPolicy(EndpointInfo ei, BindingOperationInfo boi, EffectivePolicy ep) {
        boi.setProperty(POLICY_INFO_REQUEST_SERVER, (Object)ep);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EffectivePolicy getEffectiveClientResponsePolicy(EndpointInfo ei, BindingOperationInfo boi, Message m) {
        EffectivePolicy effectivePolicy = (EffectivePolicy)boi.getProperty(POLICY_INFO_RESPONSE_CLIENT);
        if (effectivePolicy == null) {
            EndpointInfo endpointInfo = ei;
            synchronized (endpointInfo) {
                effectivePolicy = (EffectivePolicy)boi.getProperty(POLICY_INFO_RESPONSE_CLIENT);
                if (null == effectivePolicy) {
                    EffectivePolicyImpl epi = this.createOutPolicyInfo();
                    epi.initialise(ei, boi, (PolicyEngine)this, true, false, m);
                    if (m != null) {
                        boi.setProperty(POLICY_INFO_RESPONSE_CLIENT, (Object)epi);
                    }
                    effectivePolicy = epi;
                }
            }
        }
        return effectivePolicy;
    }

    @Override
    public void setEffectiveClientResponsePolicy(EndpointInfo ei, BindingOperationInfo boi, EffectivePolicy ep) {
        boi.setProperty(POLICY_INFO_RESPONSE_CLIENT, (Object)ep);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EffectivePolicy getEffectiveClientFaultPolicy(EndpointInfo ei, BindingOperationInfo boi, BindingFaultInfo bfi, Message m) {
        EffectivePolicy effectivePolicy = null;
        if (bfi != null) {
            effectivePolicy = (EffectivePolicy)bfi.getProperty(POLICY_INFO_FAULT_CLIENT);
        }
        if (effectivePolicy == null) {
            EndpointInfo endpointInfo = ei;
            synchronized (endpointInfo) {
                if (bfi != null) {
                    effectivePolicy = (EffectivePolicy)bfi.getProperty(POLICY_INFO_FAULT_CLIENT);
                }
                if (null == effectivePolicy) {
                    EffectivePolicyImpl epi = this.createOutPolicyInfo();
                    epi.initialisePolicy(ei, boi, bfi, this, m);
                    if (bfi != null) {
                        bfi.setProperty(POLICY_INFO_FAULT_CLIENT, (Object)epi);
                    }
                    effectivePolicy = epi;
                }
            }
        }
        return effectivePolicy;
    }

    @Override
    public void setEffectiveClientFaultPolicy(EndpointInfo ei, BindingFaultInfo bfi, EffectivePolicy ep) {
        bfi.setProperty(POLICY_INFO_FAULT_CLIENT, (Object)ep);
    }

    protected final void init() {
        this.registry = new PolicyRegistryImpl();
    }

    public synchronized void removeBusInterceptors() {
        this.bus.getInInterceptors().remove((Object)PolicyInInterceptor.INSTANCE);
        this.bus.getOutInterceptors().remove((Object)PolicyOutInterceptor.INSTANCE);
        this.bus.getInFaultInterceptors().remove((Object)ClientPolicyInFaultInterceptor.INSTANCE);
        this.bus.getOutFaultInterceptors().remove((Object)ServerPolicyOutFaultInterceptor.INSTANCE);
        this.bus.getInFaultInterceptors().remove((Object)PolicyVerificationInFaultInterceptor.INSTANCE);
        this.addedBusInterceptors = false;
    }

    public final synchronized void addBusInterceptors() {
        AssertionBuilderRegistry abr;
        if (null == this.bus || !this.enabled) {
            return;
        }
        if (this.ignoreUnknownAssertions != null && null != (abr = (AssertionBuilderRegistry)this.bus.getExtension(AssertionBuilderRegistry.class))) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Setting ignoreUnknownAssertions to: " + this.ignoreUnknownAssertions);
            }
            abr.setIgnoreUnknownAssertions(this.ignoreUnknownAssertions);
        }
        this.bus.getInInterceptors().add(PolicyInInterceptor.INSTANCE);
        this.bus.getOutInterceptors().add(PolicyOutInterceptor.INSTANCE);
        this.bus.getInFaultInterceptors().add(ClientPolicyInFaultInterceptor.INSTANCE);
        this.bus.getOutFaultInterceptors().add(ServerPolicyOutFaultInterceptor.INSTANCE);
        this.bus.getInFaultInterceptors().add(PolicyVerificationInFaultInterceptor.INSTANCE);
        this.addedBusInterceptors = true;
    }

    Policy getAggregatedServicePolicy(ServiceInfo si, Message m) {
        if (si == null) {
            return new Policy();
        }
        Policy aggregated = this.busPolicy;
        for (PolicyProvider pp : this.getPolicyProviders()) {
            Policy p = pp.getEffectivePolicy(si, m);
            if (null == aggregated) {
                aggregated = p;
                continue;
            }
            if (p == null) continue;
            aggregated = aggregated.merge(p);
        }
        return aggregated == null ? new Policy() : aggregated;
    }

    Policy getAggregatedEndpointPolicy(EndpointInfo ei, Message m) {
        Policy aggregated = null;
        for (PolicyProvider pp : this.getPolicyProviders()) {
            Policy p = pp.getEffectivePolicy(ei, m);
            if (null == aggregated) {
                aggregated = p;
                continue;
            }
            if (p == null) continue;
            aggregated = aggregated.merge(p);
        }
        return aggregated == null ? new Policy() : aggregated;
    }

    Policy getAggregatedOperationPolicy(BindingOperationInfo boi, Message m) {
        Policy aggregated = null;
        for (PolicyProvider pp : this.getPolicyProviders()) {
            Policy p = pp.getEffectivePolicy(boi, m);
            if (null == aggregated) {
                aggregated = p;
                continue;
            }
            if (p == null) continue;
            aggregated = aggregated.merge(p);
        }
        return aggregated == null ? new Policy() : aggregated;
    }

    Policy getAggregatedMessagePolicy(BindingMessageInfo bmi, Message m) {
        Policy aggregated = null;
        for (PolicyProvider pp : this.getPolicyProviders()) {
            Policy p = pp.getEffectivePolicy(bmi, m);
            if (null == aggregated) {
                aggregated = p;
                continue;
            }
            if (p == null) continue;
            aggregated = aggregated.merge(p);
        }
        return aggregated == null ? new Policy() : aggregated;
    }

    Policy getAggregatedFaultPolicy(BindingFaultInfo bfi, Message m) {
        Policy aggregated = null;
        for (PolicyProvider pp : this.getPolicyProviders()) {
            Policy p = pp.getEffectivePolicy(bfi, m);
            if (null == aggregated) {
                aggregated = p;
                continue;
            }
            if (p == null) continue;
            aggregated = aggregated.merge(p);
        }
        return aggregated == null ? new Policy() : aggregated;
    }

    Collection<Assertion> getAssertions(PolicyComponent pc, boolean includeOptional) {
        ArrayList<Assertion> assertions = new ArrayList<Assertion>();
        if (5 == pc.getType()) {
            Assertion a = (Assertion)pc;
            if (includeOptional || !a.isOptional()) {
                if (LOG.isLoggable(Level.FINEST)) {
                    LOG.finest("Adding required assertions 1: " + a.getName());
                }
                assertions.add(a);
            }
        } else {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest("Adding optional assertions 1: " + includeOptional);
            }
            this.addAssertions(pc, includeOptional, assertions);
        }
        return assertions;
    }

    Collection<Assertion> getAssertions(EffectivePolicy pc, boolean includeOptional) {
        if (pc == null || pc.getChosenAlternative() == null) {
            return null;
        }
        ArrayList<Assertion> assertions = new ArrayList<Assertion>();
        for (Assertion assertion : pc.getChosenAlternative()) {
            if (5 == assertion.getType()) {
                if (!includeOptional && assertion.isOptional()) continue;
                assertions.add(assertion);
                continue;
            }
            this.addAssertions((PolicyComponent)assertion, includeOptional, assertions);
        }
        return assertions;
    }

    void addAssertions(PolicyComponent pc, boolean includeOptional, Collection<Assertion> assertions) {
        if (5 == pc.getType()) {
            Assertion a = (Assertion)pc;
            if (includeOptional || !a.isOptional()) {
                if (LOG.isLoggable(Level.FINEST)) {
                    LOG.finest("Adding required assertions 2: " + a.getName());
                }
                assertions.add((Assertion)pc);
            }
            return;
        }
        if (4 == pc.getType()) {
            PolicyReference pr = (PolicyReference)pc;
            pc = pr.normalize(this.registry, false);
        }
        PolicyOperator po = (PolicyOperator)pc;
        List pcs = CastUtils.cast((List)po.getPolicyComponents(), PolicyComponent.class);
        for (PolicyComponent child : pcs) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.finest("Adding optional assertions 2: " + includeOptional);
            }
            this.addAssertions(child, includeOptional, assertions);
        }
    }

    Set<QName> getVocabulary(PolicyComponent pc, boolean includeOptional) {
        Collection<Assertion> assertions = this.getAssertions(pc, includeOptional);
        HashSet<QName> vocabulary = new HashSet<QName>();
        for (Assertion a : assertions) {
            vocabulary.add(a.getName());
        }
        return vocabulary;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    EndpointPolicy createEndpointPolicyInfo(EndpointInfo ei, boolean isRequestor, Assertor assertor, Message m) {
        EndpointPolicy ep = (EndpointPolicy)ei.getProperty(isRequestor ? POLICY_INFO_ENDPOINT_CLIENT : POLICY_INFO_ENDPOINT_SERVER);
        if (ep == null) {
            EndpointInfo endpointInfo = ei;
            synchronized (endpointInfo) {
                ep = (EndpointPolicy)ei.getProperty(isRequestor ? POLICY_INFO_ENDPOINT_CLIENT : POLICY_INFO_ENDPOINT_SERVER);
                if (ep == null) {
                    EndpointPolicyImpl epi = new EndpointPolicyImpl(ei, this, isRequestor, assertor);
                    epi.initialize(m);
                    if (m != null) {
                        ei.setProperty(isRequestor ? POLICY_INFO_ENDPOINT_CLIENT : POLICY_INFO_ENDPOINT_SERVER, (Object)epi);
                    }
                    ep = epi;
                }
            }
        }
        return ep;
    }

    @Override
    public boolean supportsAlternative(Collection<? extends PolicyComponent> alternative, Assertor assertor, Message m) {
        PolicyInterceptorProviderRegistry pipr = (PolicyInterceptorProviderRegistry)this.bus.getExtension(PolicyInterceptorProviderRegistry.class);
        boolean doLog = LOG.isLoggable(Level.FINE);
        for (PolicyComponent policyComponent : alternative) {
            if (policyComponent instanceof Assertion) {
                Assertion a = (Assertion)policyComponent;
                if (a.isOptional() || null != assertor && assertor.canAssert(a.getName())) continue;
                Set s = (Set)pipr.get(a.getName());
                if (s.isEmpty()) {
                    if (doLog) {
                        LOG.fine("Alternative " + a.getName() + " is not supported");
                    }
                    if (ignoreUnsupportedPolicy) {
                        if (doLog) {
                            LOG.fine("WARNING: Unsupported policy assertions will be ignored because property cxf.ignore.unsupported.policy is set to true.");
                        }
                        return true;
                    }
                    if (doLog) {
                        LOG.fine("ignoreUnsupportedPolicy is not set, returning false 1");
                    }
                    return false;
                }
                for (PolicyInterceptorProvider p : s) {
                    if (p.configurationPresent(m, a)) continue;
                    if (doLog) {
                        LOG.fine("Alternative " + a.getName() + " is not supported");
                    }
                    if (ignoreUnsupportedPolicy) {
                        if (doLog) {
                            LOG.fine("WARNING: Unsupported policy assertions will be ignored because property cxf.ignore.unsupported.policy is set to true.");
                        }
                        return true;
                    }
                    if (doLog) {
                        LOG.fine("ignoreUnsupportedPolicy is not set, returning false 2");
                    }
                    return false;
                }
                continue;
            }
            if (doLog) {
                LOG.fine("Not policy assertion, returning false");
            }
            return false;
        }
        return true;
    }

    EffectivePolicyImpl createOutPolicyInfo() {
        return new EffectivePolicyImpl();
    }

    static {
        String skipPolicyCheck = System.getProperty("cxf.ignore.unsupported.policy");
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "cxf.ignore.unsupported.policy property is set to " + skipPolicyCheck);
        }
        ignoreUnsupportedPolicy = skipPolicyCheck != null && skipPolicyCheck.trim().length() > 0 && skipPolicyCheck.trim().equalsIgnoreCase("true");
    }
}

