/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.jaas.config.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.jaas.config.internal.ParserException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.security.auth.login.AppConfigurationEntry;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public abstract class Parser {
    private static final TraceComponent tc = Tr.register(Parser.class, (String)"security", (String)"com.ibm.ws.security.jaas.common.internal.resources.JAASCommonMessages");
    StreamTokenizer st;
    int lookahead;
    Map<String, List<AppConfigurationEntry>> login = new HashMap<String, List<AppConfigurationEntry>>();
    static final long serialVersionUID = 2206033934096667480L;

    public Map<String, List<AppConfigurationEntry>> parse(Reader rdr) throws IOException, ParserException {
        this.clearFileEntry();
        this.init(rdr);
        this.lookahead = this.st.nextToken();
        while (this.lookahead != -1) {
            while (!this.peek("}")) {
                List<AppConfigurationEntry> g;
                String name = this.getString();
                if (this.peek("{")) {
                    this.skipChar(123);
                }
                if ((g = this.parseAppConfigurationEntry()) == null || name == null || name.trim().length() <= 0) continue;
                if (this.login.containsKey(name)) {
                    Tr.error((TraceComponent)tc, (String)"security.jaas.duplicate.config", (Object[])new Object[]{name});
                }
                this.login.put(name, g);
            }
            if (this.peek("}")) {
                this.skipChar(125);
            }
            this.match(";");
        }
        return this.login;
    }

    public void clearFileEntry() {
        this.login.clear();
    }

    /*
     * WARNING - void declaration
     */
    public List<AppConfigurationEntry> parseAppConfigurationEntry() {
        Vector<AppConfigurationEntry> appEntry = new Vector<AppConfigurationEntry>();
        try {
            while (!this.peek("}")) {
                String lmName = this.getString();
                String flag = this.getString();
                HashMap<String, String> opt = new HashMap<String, String>();
                while (!this.peek(";")) {
                    String opName = this.getString();
                    this.skipChar(61);
                    String opValue = this.getString();
                    opt.put(opName, opValue);
                }
                appEntry.add(new AppConfigurationEntry(lmName, this.buildFlag(flag), opt));
                if (!this.peek(";")) continue;
                this.skipChar(59);
            }
        }
        catch (IOException lmName) {
            void e;
            FFDCFilter.processException((Throwable)lmName, (String)"com.ibm.ws.security.jaas.config.internal.Parser", (String)"86", (Object)this, (Object[])new Object[0]);
            Tr.error((TraceComponent)tc, (String)"security.jaas.app.parseIO", (Object[])new Object[]{e});
            appEntry = null;
        }
        catch (ParserException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.jaas.config.internal.Parser", (String)"90", (Object)this, (Object[])new Object[0]);
            Tr.error((TraceComponent)tc, (String)"security.jaas.app.parse", (Object[])new Object[]{e});
        }
        return appEntry;
    }

    public String getString() throws IOException, ParserException {
        String s1 = null;
        switch (this.lookahead) {
            case 10: {
                throw new ParserException(this.st.lineno(), " read end of Line");
            }
            case -1: {
                throw new ParserException(this.st.lineno(), " getString:read end of file");
            }
            case -3: {
                s1 = this.st.sval;
                this.lookahead = this.st.nextToken();
                break;
            }
            case 34: {
                s1 = this.st.sval;
                this.lookahead = this.st.nextToken();
                break;
            }
            default: {
                throw new ParserException(this.st.lineno(), s1, new String(new char[]{(char)this.lookahead}));
            }
        }
        return s1;
    }

    public String match(String str) throws IOException, ParserException {
        String s1 = null;
        switch (this.lookahead) {
            case -2: {
                throw new ParserException(this.st.lineno(), "number " + this.st.nval);
            }
            case 10: {
                throw new ParserException(this.st.lineno(), " read end of Line");
            }
            case -1: {
                throw new ParserException(this.st.lineno(), " match;read end of FILE");
            }
            case -3: {
                s1 = this.st.sval;
                this.lookahead = this.st.nextToken();
                break;
            }
            case 59: {
                if (str.equalsIgnoreCase(";")) {
                    this.lookahead = this.st.nextToken();
                    break;
                }
                throw new ParserException(this.st.lineno(), str, ";");
            }
            case 61: {
                if (str.equalsIgnoreCase("=")) {
                    this.lookahead = this.st.nextToken();
                    break;
                }
                throw new ParserException(this.st.lineno(), str, "=");
            }
            case 123: {
                if (str.equalsIgnoreCase("{")) {
                    this.lookahead = this.st.nextToken();
                    break;
                }
                throw new ParserException(this.st.lineno(), str, "{");
            }
            case 125: {
                if (str.equalsIgnoreCase("}")) {
                    this.lookahead = this.st.nextToken();
                    break;
                }
                throw new ParserException(this.st.lineno(), str, "}");
            }
            default: {
                throw new ParserException(this.st.lineno(), s1, new String(new char[]{(char)this.lookahead}));
            }
        }
        return s1;
    }

    private AppConfigurationEntry.LoginModuleControlFlag buildFlag(String flag) {
        if (flag.equalsIgnoreCase("sufficient")) {
            return AppConfigurationEntry.LoginModuleControlFlag.SUFFICIENT;
        }
        if (flag.equalsIgnoreCase("optional")) {
            return AppConfigurationEntry.LoginModuleControlFlag.OPTIONAL;
        }
        if (flag.equalsIgnoreCase("required")) {
            return AppConfigurationEntry.LoginModuleControlFlag.REQUIRED;
        }
        if (flag.equalsIgnoreCase("requisite")) {
            return AppConfigurationEntry.LoginModuleControlFlag.REQUISITE;
        }
        return null;
    }

    @Sensitive
    public boolean peek(String str) {
        boolean flag = false;
        switch (this.lookahead) {
            case -3: {
                flag = str.equalsIgnoreCase(this.st.sval);
                break;
            }
            case 59: {
                flag = str.equalsIgnoreCase(";");
                break;
            }
            case 123: {
                flag = str.equalsIgnoreCase("{");
                break;
            }
            case 125: {
                flag = str.equalsIgnoreCase("}");
                break;
            }
            case 61: {
                flag = str.equalsIgnoreCase("=");
                break;
            }
            case 32: {
                flag = str.equalsIgnoreCase(" ");
                break;
            }
        }
        return flag;
    }

    public void skipChar(int str) throws IOException, ParserException {
        switch (str) {
            case 61: {
                this.lookahead = this.st.nextToken();
                break;
            }
            case 59: {
                this.lookahead = this.st.nextToken();
                break;
            }
            case 123: {
                this.lookahead = this.st.nextToken();
                break;
            }
            case 125: {
                this.lookahead = this.st.nextToken();
                break;
            }
            default: {
                if (this.lookahead == -1) break;
                this.lookahead = this.st.nextToken();
            }
        }
    }

    private void init(Reader rdr) {
        this.st = rdr instanceof BufferedReader ? new StreamTokenizer(new BufferedReader(rdr)) : new StreamTokenizer(rdr);
        this.st.resetSyntax();
        this.st.wordChars(97, 122);
        this.st.wordChars(65, 90);
        this.st.wordChars(48, 58);
        this.st.wordChars(45, 47);
        this.st.wordChars(92, 92);
        this.st.wordChars(95, 95);
        this.st.wordChars(36, 36);
        this.st.wordChars(160, 255);
        this.st.whitespaceChars(0, 32);
        this.st.quoteChar(39);
        this.st.quoteChar(34);
        this.st.lowerCaseMode(false);
        this.st.slashSlashComments(true);
        this.st.slashStarComments(true);
    }
}

