/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jdeparser;

import java.util.ArrayList;
import java.util.List;
import org.jboss.jdeparser.JAnonymousClass;
import org.jboss.jdeparser.JClass;
import org.jboss.jdeparser.JDefinedClass;
import org.jboss.jdeparser.JExpr;
import org.jboss.jdeparser.JExpression;
import org.jboss.jdeparser.JExpressionImpl;
import org.jboss.jdeparser.JFormatter;
import org.jboss.jdeparser.JGenerable;
import org.jboss.jdeparser.JMethod;
import org.jboss.jdeparser.JStatement;
import org.jboss.jdeparser.JType;

public final class JInvocation
extends JExpressionImpl
implements JStatement {
    private JGenerable object;
    private String name;
    private JMethod method;
    private boolean isConstructor = false;
    private List<JExpression> args = new ArrayList<JExpression>();
    private JType type = null;

    JInvocation(JExpression object, String name) {
        this((JGenerable)object, name);
    }

    JInvocation(JExpression object, JMethod method) {
        this((JGenerable)object, method);
    }

    JInvocation(JClass type, String name) {
        this((JGenerable)type, name);
    }

    JInvocation(JClass type, JMethod method) {
        this((JGenerable)type, method);
    }

    private JInvocation(JGenerable object, String name) {
        this.object = object;
        if (name.indexOf(46) >= 0) {
            throw new IllegalArgumentException("method name contains '.': " + name);
        }
        this.name = name;
    }

    private JInvocation(JGenerable object, JMethod method) {
        this.object = object;
        this.method = method;
    }

    JInvocation(JType c) {
        this.isConstructor = true;
        this.type = c;
    }

    public JInvocation arg(JExpression arg) {
        if (arg == null) {
            throw new IllegalArgumentException();
        }
        this.args.add(arg);
        return this;
    }

    public JInvocation arg(String v) {
        return this.arg(JExpr.lit(v));
    }

    public JExpression[] listArgs() {
        return this.args.toArray(new JExpression[this.args.size()]);
    }

    @Override
    public void generate(JFormatter f) {
        if (this.isConstructor && this.type.isArray()) {
            f.p("new").g(this.type).p('{');
        } else if (this.isConstructor) {
            f.p("new").g(this.type).p('(');
        } else {
            String name = this.name;
            if (name == null) {
                name = this.method.name();
            }
            if (this.object != null) {
                f.g(this.object).p('.').p(name).p('(');
            } else {
                f.id(name).p('(');
            }
        }
        f.g(this.args);
        if (this.isConstructor && this.type.isArray()) {
            f.p('}');
        } else {
            f.p(')');
        }
        if (this.type instanceof JDefinedClass && ((JDefinedClass)this.type).isAnonymous()) {
            ((JAnonymousClass)this.type).declareBody(f);
        }
    }

    @Override
    public void state(JFormatter f) {
        f.g(this).p(';').nl();
    }
}

