/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.converters;

import jakarta.persistence.AttributeConverter;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.jpa.metadata.ORMetadata;
import org.eclipse.persistence.internal.jpa.metadata.accessors.MetadataAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.ClassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.EmbeddableAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.MappingAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataClass;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLEntityMappings;
import org.eclipse.persistence.internal.mappings.converters.AttributeNamePrefix;
import org.eclipse.persistence.mappings.DatabaseMapping;

public class ConvertMetadata
extends ORMetadata {
    private String m_text;
    private Boolean m_isForMapKey;
    private Boolean m_disableConversion;
    private MetadataClass m_converterClass;
    private String m_converterClassName;
    private String m_attributeName;

    public ConvertMetadata() {
        super("<convert>");
    }

    public ConvertMetadata(MetadataAnnotation convert, MetadataAccessor accessor) {
        super(convert, accessor);
        this.m_converterClass = this.getMetadataClass(convert.getAttributeClass("converter", AttributeConverter.class));
        this.m_attributeName = convert.getAttributeString("attributeName");
        this.m_disableConversion = convert.getAttributeBooleanDefaultFalse("disableConversion");
    }

    public boolean disableConversion() {
        return this.m_disableConversion != null && this.m_disableConversion != false;
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (objectToCompare instanceof ConvertMetadata) {
            ConvertMetadata convert = (ConvertMetadata)objectToCompare;
            if (!this.valuesMatch(this.m_text, convert.getText())) {
                return false;
            }
            if (!this.valuesMatch(this.m_converterClassName, convert.getConverterClassName())) {
                return false;
            }
            if (!this.valuesMatch(this.m_attributeName, convert.getAttributeName())) {
                return false;
            }
            return this.valuesMatch(this.m_disableConversion, convert.getDisableConversion());
        }
        return false;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.m_text != null ? this.m_text.hashCode() : 0);
        result = 31 * result + (this.m_disableConversion != null ? this.m_disableConversion.hashCode() : 0);
        result = 31 * result + (this.m_converterClassName != null ? this.m_converterClassName.hashCode() : 0);
        result = 31 * result + (this.m_attributeName != null ? this.m_attributeName.hashCode() : 0);
        return result;
    }

    public String getAttributeName() {
        return this.m_attributeName;
    }

    public MetadataClass getConverterClass() {
        return this.m_converterClass;
    }

    public String getConverterClassName() {
        return this.m_converterClassName;
    }

    public Boolean getDisableConversion() {
        return this.m_disableConversion;
    }

    @Override
    protected String getText() {
        return this.m_text;
    }

    public boolean hasAttributeName() {
        return this.m_attributeName != null && !this.m_attributeName.isEmpty();
    }

    public boolean hasConverterClass() {
        return this.m_converterClass != null && !this.m_converterClass.isClass(AttributeConverter.class) && !this.m_converterClass.isVoid();
    }

    @Override
    public void initXMLObject(MetadataAccessibleObject accessibleObject, XMLEntityMappings entityMappings) {
        super.initXMLObject(accessibleObject, entityMappings);
        if (this.m_text != null) {
            this.m_text = this.m_text.trim();
        }
        this.m_converterClass = this.initXMLClassName(this.m_converterClassName);
    }

    public boolean isForMapKey() {
        if (this.m_isForMapKey == null) {
            String key = AttributeNamePrefix.KEY.getName();
            if (this.m_attributeName != null && this.m_attributeName.startsWith(key)) {
                this.m_attributeName = this.m_attributeName.equals(key) ? "" : this.m_attributeName.substring(key.length() + 1);
                this.m_isForMapKey = true;
            } else {
                this.m_isForMapKey = false;
            }
        }
        return this.m_isForMapKey;
    }

    private MetadataClass verify(DatabaseMapping mapping, MetadataClass referenceClass, ClassAccessor accessor, String embeddedAttributeName) throws ValidationException {
        if (this.hasAttributeName()) {
            String attributeName;
            if (mapping.isAggregateObjectMapping()) {
                attributeName = this.getAttributeName();
            } else if (mapping.isAggregateCollectionMapping() && embeddedAttributeName != null && !embeddedAttributeName.isEmpty()) {
                attributeName = embeddedAttributeName;
            } else {
                throw ValidationException.invalidMappingForConvertWithAttributeName(accessor.getJavaClassName(), mapping.getAttributeName());
            }
            EmbeddableAccessor embeddableAccessor = this.getProject().getEmbeddableAccessor(referenceClass);
            MappingAccessor mappingAccessor = embeddableAccessor.getDescriptor().getMappingAccessor(attributeName);
            if (mappingAccessor == null) {
                throw ValidationException.embeddableAttributeNameForConvertNotFound(accessor.getJavaClassName(), mapping.getAttributeName(), embeddableAccessor.getJavaClassName(), this.getAttributeName());
            }
            return mappingAccessor.getReferenceClass();
        }
        if (mapping.isAggregateObjectMapping()) {
            throw ValidationException.missingMappingConvertAttributeName(accessor.getJavaClassName(), mapping.getAttributeName());
        }
        return referenceClass;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void apply(DatabaseMapping mapping, MetadataClass referenceClass, ClassAccessor accessor, boolean isForMapKey) {
        if (this.hasConverterClass()) {
            if (!this.getProject().hasConverterAccessor(this.getConverterClass())) throw ValidationException.converterClassNotFound(accessor.getJavaClassName(), mapping.getAttributeName(), this.getConverterClass().getName());
            this.getProject().getConverterAccessor(this.getConverterClass()).process(mapping, isForMapKey, this.getAttributeName());
            return;
        } else {
            if (!this.getProject().hasAutoApplyConverter(referenceClass)) return;
            if (this.disableConversion()) {
                if (!mapping.isAggregateObjectMapping()) return;
                this.getProject().getAutoApplyConverter(referenceClass).process(mapping, isForMapKey, this.getAttributeName(), true);
                return;
            } else {
                this.getProject().getAutoApplyConverter(referenceClass).process(mapping, isForMapKey, this.getAttributeName());
            }
        }
    }

    public void process(DatabaseMapping mapping, MetadataClass referenceClass, ClassAccessor accessor, String embeddedAttributeName) {
        MetadataClass targetReferenceClass = this.verify(mapping, referenceClass, accessor, embeddedAttributeName);
        this.apply(mapping, targetReferenceClass, accessor, false);
    }

    public void process(DatabaseMapping mapping, MetadataClass referenceClass, ClassAccessor accessor, boolean isForMapKey) {
        MetadataClass targetReferenceClass = this.verify(mapping, referenceClass, accessor, null);
        this.apply(mapping, targetReferenceClass, accessor, isForMapKey);
    }

    public void setAttributeName(String attributeName) {
        this.m_attributeName = attributeName;
    }

    public void setConverterClassName(String converterClassName) {
        this.m_converterClassName = converterClassName;
    }

    public void setDisableConversion(Boolean disableConversion) {
        this.m_disableConversion = disableConversion;
    }

    public void setText(String text) {
        this.m_text = text;
    }
}

