/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.jpql;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.internal.jpa.jpql.ConstructorQueryMappings;
import org.eclipse.persistence.internal.jpa.jpql.Declaration;
import org.eclipse.persistence.internal.jpa.jpql.DeclarationResolver;
import org.eclipse.persistence.internal.jpa.jpql.HermesParser;
import org.eclipse.persistence.internal.jpa.jpql.JPQLQueryContext;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.jpa.jpql.Assert;
import org.eclipse.persistence.jpa.jpql.parser.AbstractEclipseLinkTraverseChildrenVisitor;
import org.eclipse.persistence.jpa.jpql.parser.DefaultEclipseLinkJPQLGrammar;
import org.eclipse.persistence.jpa.jpql.parser.DeleteClause;
import org.eclipse.persistence.jpa.jpql.parser.Expression;
import org.eclipse.persistence.jpa.jpql.parser.FromClause;
import org.eclipse.persistence.jpa.jpql.parser.JPQLExpression;
import org.eclipse.persistence.jpa.jpql.parser.JPQLGrammar;
import org.eclipse.persistence.jpa.jpql.parser.SimpleSelectStatement;
import org.eclipse.persistence.jpa.jpql.parser.UpdateClause;
import org.eclipse.persistence.queries.DatabaseQuery;

public class JPQLQueryHelper {
    private JPQLGrammar jpqlGrammar;

    public JPQLQueryHelper() {
        this(DefaultEclipseLinkJPQLGrammar.instance());
    }

    public JPQLQueryHelper(JPQLGrammar jpqlGrammar) {
        Assert.isNotNull(jpqlGrammar, "The JPQLGrammar cannot be null");
        this.jpqlGrammar = jpqlGrammar;
    }

    public List<ClassDescriptor> getClassDescriptors(CharSequence jpqlQuery, AbstractSession session) {
        HermesParser hermesParser = new HermesParser();
        hermesParser.setValidationLevel((String)session.getProperty("eclipselink.jpql.validation"));
        JPQLExpression jpqlExpression = hermesParser.buildJPQLExpression(jpqlQuery);
        JPQLQueryContext queryContext = new JPQLQueryContext(this.jpqlGrammar);
        queryContext.cache(session, null, jpqlExpression, jpqlQuery);
        DescriptorCollector collector = new DescriptorCollector(queryContext);
        jpqlExpression.accept(collector);
        return new ArrayList<ClassDescriptor>(collector.descriptors);
    }

    public List<ConstructorQueryMappings> getConstructorQueryMappings(AbstractSession session) {
        LinkedList<ConstructorQueryMappings> allMappings = new LinkedList<ConstructorQueryMappings>();
        for (DatabaseQuery query : session.getJPAQueries()) {
            ConstructorQueryMappings mappings = this.getConstructorQueryMappings(session, query);
            allMappings.add(mappings);
        }
        return allMappings;
    }

    public ConstructorQueryMappings getConstructorQueryMappings(AbstractSession session, DatabaseQuery query) {
        JPQLQueryContext queryContext = new JPQLQueryContext(query, this.jpqlGrammar);
        ConstructorQueryMappings mappings = new ConstructorQueryMappings(query);
        mappings.populate(this.jpqlGrammar);
        return mappings;
    }

    public JPQLGrammar getGrammar() {
        return this.jpqlGrammar;
    }

    private static class DescriptorCollector
    extends AbstractEclipseLinkTraverseChildrenVisitor {
        private Set<ClassDescriptor> descriptors = new HashSet<ClassDescriptor>();
        private JPQLQueryContext queryContext;
        private DeclarationResolver resolver;

        private DescriptorCollector(JPQLQueryContext queryContext) {
            this.queryContext = queryContext;
        }

        private void collectDescriptors(Expression expression, DeclarationResolver resolver) {
            resolver.populate(expression);
            for (Declaration declaration : resolver.getDeclarations()) {
                ClassDescriptor descriptor = declaration.getDescriptor();
                if (descriptor == null) continue;
                this.descriptors.add(descriptor);
            }
        }

        @Override
        public void visit(DeleteClause expression) {
            this.resolver = new DeclarationResolver(this.queryContext, null);
            this.collectDescriptors(expression, this.resolver);
        }

        @Override
        public void visit(FromClause expression) {
            this.resolver = new DeclarationResolver(this.queryContext, null);
            this.collectDescriptors(expression, this.resolver);
        }

        @Override
        public void visit(SimpleSelectStatement expression) {
            this.resolver = new DeclarationResolver(this.queryContext, this.resolver);
            this.collectDescriptors(expression, this.resolver);
            this.resolver = this.resolver.getParent();
        }

        @Override
        public void visit(UpdateClause expression) {
            this.resolver = new DeclarationResolver(this.queryContext, null);
            this.collectDescriptors(expression, this.resolver);
        }
    }
}

